<?php
declare(strict_types=1);

namespace PrinsFrank\Standards\Language;

use PrinsFrank\Standards\Country\CountryAlpha2;
use PrinsFrank\Standards\InvalidArgumentException;
use PrinsFrank\Standards\LanguageTag\LanguageTag;
use PrinsFrank\Standards\LanguageTag\LanguageTagVariant;
use PrinsFrank\Standards\LanguageTag\PrivateUseRegionSubtag;
use PrinsFrank\Standards\Region\GeographicRegion;
use PrinsFrank\Standards\Scripts\ScriptCode;

/**
 * @standard ISO639_3
 * @source https://iso639-3.sil.org/code_tables/download_tables#Complete%20Code%20Tables
 * @source https://iso639-3.sil.org/sites/iso639-3/files/downloads/iso-639-3_Latin1.tab
 *
 * @updated-by \PrinsFrank\Standards\Dev\DataSource\Mapping\LanguageExtensiveMapping
 */
enum LanguageAlpha3Extensive: string {
    case Ghotuo = 'aaa';
    case Alumu_Tesu = 'aab';
    case Ari = 'aac';
    case Amal = 'aad';
    case Arbereshe_Albanian = 'aae';
    case Aranadan = 'aaf';
    case Ambrak = 'aag';
    case Abu_Arapesh = 'aah';
    case Arifama_Miniafia = 'aai';
    case Ankave = 'aak';
    case Afade = 'aal';
    case Anambe = 'aan';
    case Algerian_Saharan_Arabic = 'aao';
    case Para_Arara = 'aap';
    case Eastern_Abnaki = 'aaq';
    case Afar = 'aar';
    case Aasax = 'aas';
    case Arvanitika_Albanian = 'aat';
    case Abau = 'aau';
    case Solong = 'aaw';
    case Mandobo_Atas = 'aax';
    case Amarasi = 'aaz';
    case Abe = 'aba';
    case Bankon = 'abb';
    case Ambala_Ayta = 'abc';
    case Manide = 'abd';
    case Western_Abnaki = 'abe';
    case Abai_Sungai = 'abf';
    case Abaga = 'abg';
    case Tajiki_Arabic = 'abh';
    case Abidji = 'abi';
    case Aka_Bea = 'abj';
    case Abkhazian = 'abk';
    case Lampung_Nyo = 'abl';
    case Abanyom = 'abm';
    case Abua = 'abn';
    case Abon = 'abo';
    case Abellen_Ayta = 'abp';
    case Abaza = 'abq';
    case Abron = 'abr';
    case Ambonese_Malay = 'abs';
    case Ambulas = 'abt';
    case Abure = 'abu';
    case Baharna_Arabic = 'abv';
    case Pal = 'abw';
    case Inabaknon = 'abx';
    case Aneme_Wake = 'aby';
    case Abui = 'abz';
    case Achagua = 'aca';
    case Anca = 'acb';
    case Gikyode = 'acd';
    case Achinese = 'ace';
    case Saint_Lucian_Creole_French = 'acf';
    case Acoli = 'ach';
    case Aka_Cari = 'aci';
    case Aka_Kora = 'ack';
    case Akar_Bale = 'acl';
    case Mesopotamian_Arabic = 'acm';
    case Achang = 'acn';
    case Eastern_Acipa = 'acp';
    case Ta_izzi_Adeni_Arabic = 'acq';
    case Achi = 'acr';
    case Acroa = 'acs';
    case Achterhoeks = 'act';
    case Achuar_Shiwiar = 'acu';
    case Achumawi = 'acv';
    case Hijazi_Arabic = 'acw';
    case Omani_Arabic = 'acx';
    case Cypriot_Arabic = 'acy';
    case Acheron = 'acz';
    case Adangme = 'ada';
    case Atauran = 'adb';
    case Lidzonka = 'add';
    case Adele = 'ade';
    case Dhofari_Arabic = 'adf';
    case Andegerebinha = 'adg';
    case Adhola = 'adh';
    case Adi = 'adi';
    case Adioukrou = 'adj';
    case Galo = 'adl';
    case Adang = 'adn';
    case Abu = 'ado';
    case Adangbe = 'adq';
    case Adonara = 'adr';
    case Adamorobe_Sign_Language = 'ads';
    case Adnyamathanha = 'adt';
    case Aduge = 'adu';
    case Amundava = 'adw';
    case Amdo_Tibetan = 'adx';
    case Adyghe = 'ady';
    case Adzera = 'adz';
    case Areba = 'aea';
    case Tunisian_Arabic = 'aeb';
    case Saidi_Arabic = 'aec';
    case Argentine_Sign_Language = 'aed';
    case Northeast_Pashai = 'aee';
    case Haeke = 'aek';
    case Ambele = 'ael';
    case Arem = 'aem';
    case Armenian_Sign_Language = 'aen';
    case Aer = 'aeq';
    case Eastern_Arrernte = 'aer';
    case Alsea = 'aes';
    case Akeu = 'aeu';
    case Ambakich = 'aew';
    case Amele = 'aey';
    case Aeka = 'aez';
    case Gulf_Arabic = 'afb';
    case Andai = 'afd';
    case Putukwam = 'afe';
    case Afghan_Sign_Language = 'afg';
    case Afrihili = 'afh';
    case Akrukay = 'afi';
    case Nanubae = 'afk';
    case Defaka = 'afn';
    case Eloyi = 'afo';
    case Tapei = 'afp';
    case Afrikaans = 'afr';
    case Afro_Seminole_Creole = 'afs';
    case Afitti = 'aft';
    case Awutu = 'afu';
    case Obokuitai = 'afz';
    case Aguano = 'aga';
    case Legbo = 'agb';
    case Agatu = 'agc';
    case Agarabi = 'agd';
    case Angal = 'age';
    case Arguni = 'agf';
    case Angor = 'agg';
    case Ngelima = 'agh';
    case Agariya = 'agi';
    case Argobba = 'agj';
    case Isarog_Agta = 'agk';
    case Fembe = 'agl';
    case Angaataha = 'agm';
    case Agutaynen = 'agn';
    case Tainae = 'ago';
    case Aghem = 'agq';
    case Aguaruna = 'agr';
    case Esimbi = 'ags';
    case Central_Cagayan_Agta = 'agt';
    case Aguacateco = 'agu';
    case Remontado_Dumagat = 'agv';
    case Kahua = 'agw';
    case Aghul = 'agx';
    case Southern_Alta = 'agy';
    case Mt_Iriga_Agta = 'agz';
    case Ahanta = 'aha';
    case Axamb = 'ahb';
    case Qimant = 'ahg';
    case Aghu = 'ahh';
    case Tiagbamrin_Aizi = 'ahi';
    case Akha = 'ahk';
    case Igo = 'ahl';
    case Mobumrin_Aizi = 'ahm';
    case Ahan = 'ahn';
    case Ahom = 'aho';
    case Aproumu_Aizi = 'ahp';
    case Ahirani = 'ahr';
    case Ashe = 'ahs';
    case Ahtena = 'aht';
    case Arosi = 'aia';
    case Ainu_China = 'aib';
    case Ainbai = 'aic';
    case Alngith = 'aid';
    case Amara = 'aie';
    case Agi = 'aif';
    case Antigua_and_Barbuda_Creole_English = 'aig';
    case Ai_Cham = 'aih';
    case Assyrian_Neo_Aramaic = 'aii';
    case Lishanid_Noshan = 'aij';
    case Ake = 'aik';
    case Aimele = 'ail';
    case Aimol = 'aim';
    case Ainu_Japan = 'ain';
    case Aiton = 'aio';
    case Burumakok = 'aip';
    case Aimaq = 'aiq';
    case Airoran = 'air';
    case Arikem = 'ait';
    case Aari = 'aiw';
    case Aighon = 'aix';
    case Ali = 'aiy';
    case Aja_South_Sudan = 'aja';
    case Aja_Benin = 'ajg';
    case Ajie = 'aji';
    case Andajin = 'ajn';
    case Algerian_Jewish_Sign_Language = 'ajs';
    case Judeo_Moroccan_Arabic = 'aju';
    case Ajawa = 'ajw';
    case Amri_Karbi = 'ajz';
    case Akan = 'aka';
    case Batak_Angkola = 'akb';
    case Mpur = 'akc';
    case Ukpet_Ehom = 'akd';
    case Akawaio = 'ake';
    case Akpa = 'akf';
    case Anakalangu = 'akg';
    case Angal_Heneng = 'akh';
    case Aiome = 'aki';
    case Aka_Jeru = 'akj';
    case Akkadian = 'akk';
    case Aklanon = 'akl';
    case Aka_Bo = 'akm';
    case Akurio = 'ako';
    case Siwu = 'akp';
    case Ak = 'akq';
    case Araki = 'akr';
    case Akaselem = 'aks';
    case Akolet = 'akt';
    case Akum = 'aku';
    case Akhvakh = 'akv';
    case Akwa = 'akw';
    case Aka_Kede = 'akx';
    case Aka_Kol = 'aky';
    case Alabama = 'akz';
    case Alago = 'ala';
    case Qawasqar = 'alc';
    case Alladian = 'ald';
    case Aleut = 'ale';
    case Alege = 'alf';
    case Alawa = 'alh';
    case Amaimon = 'ali';
    case Alangan = 'alj';
    case Alak = 'alk';
    case Allar = 'all';
    case Amblong = 'alm';
    case Gheg_Albanian = 'aln';
    case Larike_Wakasihu = 'alo';
    case Alune = 'alp';
    case Algonquin = 'alq';
    case Alutor = 'alr';
    case Tosk_Albanian = 'als';
    case Southern_Altai = 'alt';
    case Are_are = 'alu';
    case Alaba_K_abeena = 'alw';
    case Amol = 'alx';
    case Alyawarr = 'aly';
    case Alur = 'alz';
    case Amanaye = 'ama';
    case Ambo = 'amb';
    case Amahuaca = 'amc';
    case Yanesha = 'ame';
    case Hamer_Banna = 'amf';
    case Amurdak = 'amg';
    case Amharic = 'amh';
    case Amis = 'ami';
    case Amdang = 'amj';
    case Ambai = 'amk';
    case War_Jaintia = 'aml';
    case Ama_Papua_New_Guinea = 'amm';
    case Amanab = 'amn';
    case Amo = 'amo';
    case Alamblak = 'amp';
    case Amahai = 'amq';
    case Amarakaeri = 'amr';
    case Southern_Amami_Oshima = 'ams';
    case Amto = 'amt';
    case Guerrero_Amuzgo = 'amu';
    case Ambelau = 'amv';
    case Western_Neo_Aramaic = 'amw';
    case Anmatyerre = 'amx';
    case Ami = 'amy';
    case Atampaya = 'amz';
    case Andaqui = 'ana';
    case Andoa = 'anb';
    case Ngas = 'anc';
    case Ansus = 'and';
    case Xaracuu = 'ane';
    case Animere = 'anf';
    case Old_English_ca_450_1100 = 'ang';
    case Nend = 'anh';
    case Andi = 'ani';
    case Anor = 'anj';
    case Goemai = 'ank';
    case Anu_Hkongso_Chin = 'anl';
    case Anal = 'anm';
    case Obolo = 'ann';
    case Andoque = 'ano';
    case Angika = 'anp';
    case Jarawa_India = 'anq';
    case Andh = 'anr';
    case Anserma = 'ans';
    case Antakarinya = 'ant';
    case Anuak = 'anu';
    case Denya = 'anv';
    case Anaang = 'anw';
    case Andra_Hus = 'anx';
    case Anyin = 'any';
    case Anem = 'anz';
    case Angolar = 'aoa';
    case Abom = 'aob';
    case Pemon = 'aoc';
    case Andarum = 'aod';
    case Angal_Enen = 'aoe';
    case Bragat = 'aof';
    case Angoram = 'aog';
    case Anindilyakwa = 'aoi';
    case Mufian = 'aoj';
    case Arho = 'aok';
    case Alor = 'aol';
    case Omie = 'aom';
    case Bumbita_Arapesh = 'aon';
    case Aore = 'aor';
    case Taikat = 'aos';
    case Atong_India = 'aot';
    case A_ou = 'aou';
    case Atorada = 'aox';
    case Uab_Meto = 'aoz';
    case Sa_a = 'apb';
    case Levantine_Arabic = 'apc';
    case Sudanese_Arabic = 'apd';
    case Bukiyip = 'ape';
    case Pahanan_Agta = 'apf';
    case Ampanang = 'apg';
    case Athpariya = 'aph';
    case Apiaka = 'api';
    case Jicarilla_Apache = 'apj';
    case Kiowa_Apache = 'apk';
    case Lipan_Apache = 'apl';
    case Mescalero_Chiricahua_Apache = 'apm';
    case Apinaye = 'apn';
    case Ambul = 'apo';
    case Apma = 'app';
    case A_Pucikwar = 'apq';
    case Arop_Lokep = 'apr';
    case Arop_Sissano = 'aps';
    case Apatani = 'apt';
    case Apurina = 'apu';
    case Alapmunte = 'apv';
    case Western_Apache = 'apw';
    case Aputai = 'apx';
    case Apalai = 'apy';
    case Safeyoka = 'apz';
    case Archi = 'aqc';
    case Ampari_Dogon = 'aqd';
    case Arigidi = 'aqg';
    case Aninka = 'aqk';
    case Atohwaim = 'aqm';
    case Northern_Alta = 'aqn';
    case Atakapa = 'aqp';
    case Arha = 'aqr';
    case Angaite = 'aqt';
    case Akuntsu = 'aqz';
    case Arabic = 'ara';
    case Standard_Arabic = 'arb';
    case Official_Aramaic_700_300_BCE = 'arc';
    case Arabana = 'ard';
    case Western_Arrarnta = 'are';
    case Aragonese = 'arg';
    case Arhuaco = 'arh';
    case Arikara = 'ari';
    case Arapaso = 'arj';
    case Arikapu = 'ark';
    case Arabela = 'arl';
    case Mapudungun = 'arn';
    case Araona = 'aro';
    case Arapaho = 'arp';
    case Algerian_Arabic = 'arq';
    case Karo_Brazil = 'arr';
    case Najdi_Arabic = 'ars';
    case Arua_Amazonas_State = 'aru';
    case Arbore = 'arv';
    case Arawak = 'arw';
    case Arua_Rodonia_State = 'arx';
    case Moroccan_Arabic = 'ary';
    case Egyptian_Arabic = 'arz';
    case Asu_Tanzania = 'asa';
    case Assiniboine = 'asb';
    case Casuarina_Coast_Asmat = 'asc';
    case American_Sign_Language = 'ase';
    case Auslan = 'asf';
    case Cishingini = 'asg';
    case Abishira = 'ash';
    case Buruwai = 'asi';
    case Sari = 'asj';
    case Ashkun = 'ask';
    case Asilulu = 'asl';
    case Assamese = 'asm';
    case Xingu_Asurini = 'asn';
    case Dano = 'aso';
    case Algerian_Sign_Language = 'asp';
    case Austrian_Sign_Language = 'asq';
    case Asuri = 'asr';
    case Ipulo = 'ass';
    case Asturian = 'ast';
    case Tocantins_Asurini = 'asu';
    case Asoa = 'asv';
    case Australian_Aborigines_Sign_Language = 'asw';
    case Muratayak = 'asx';
    case Yaosakor_Asmat = 'asy';
    case As = 'asz';
    case Pele_Ata = 'ata';
    case Zaiwa = 'atb';
    case Atsahuaca = 'atc';
    case Ata_Manobo = 'atd';
    case Atemble = 'ate';
    case Ivbie_North_Okpela_Arhe = 'atg';
    case Attie = 'ati';
    case Atikamekw = 'atj';
    case Ati = 'atk';
    case Mt_Iraya_Agta = 'atl';
    case Ata = 'atm';
    case Ashtiani = 'atn';
    case Atong_Cameroon = 'ato';
    case Pudtol_Atta = 'atp';
    case Aralle_Tabulahan = 'atq';
    case Waimiri_Atroari = 'atr';
    case Gros_Ventre = 'ats';
    case Pamplona_Atta = 'att';
    case Reel = 'atu';
    case Northern_Altai = 'atv';
    case Atsugewi = 'atw';
    case Arutani = 'atx';
    case Aneityum = 'aty';
    case Arta = 'atz';
    case Asumboa = 'aua';
    case Alugu = 'aub';
    case Waorani = 'auc';
    case Anuta = 'aud';
    case Aguna = 'aug';
    case Aushi = 'auh';
    case Anuki = 'aui';
    case Awjilah = 'auj';
    case Heyo = 'auk';
    case Aulua = 'aul';
    case Asu_Nigeria = 'aum';
    case Molmo_One = 'aun';
    case Auyokawa = 'auo';
    case Makayam = 'aup';
    case Anus = 'auq';
    case Aruek = 'aur';
    case Austral = 'aut';
    case Auye = 'auu';
    case Awyi = 'auw';
    case Aura = 'aux';
    case Awiyaana = 'auy';
    case Uzbeki_Arabic = 'auz';
    case Avaric = 'ava';
    case Avau = 'avb';
    case Alviri_Vidari = 'avd';
    case Avestan = 'ave';
    case Avikam = 'avi';
    case Kotava = 'avk';
    case Eastern_Egyptian_Bedawi_Arabic = 'avl';
    case Angkamuthi = 'avm';
    case Avatime = 'avn';
    case Agavotaguerra = 'avo';
    case Aushiri = 'avs';
    case Au = 'avt';
    case Avokaya = 'avu';
    case Ava_Canoeiro = 'avv';
    case Awadhi = 'awa';
    case Awa_Papua_New_Guinea = 'awb';
    case Cicipu = 'awc';
    case Aweti = 'awe';
    case Anguthimri = 'awg';
    case Awbono = 'awh';
    case Aekyom = 'awi';
    case Awabakal = 'awk';
    case Arawum = 'awm';
    case Awngi = 'awn';
    case Awak = 'awo';
    case Awera = 'awr';
    case South_Awyu = 'aws';
    case Arawete = 'awt';
    case Central_Awyu = 'awu';
    case Jair_Awyu = 'awv';
    case Awun = 'aww';
    case Awara = 'awx';
    case Edera_Awyu = 'awy';
    case Abipon = 'axb';
    case Ayerrerenge = 'axe';
    case Mato_Grosso_Arara = 'axg';
    case Yaka_Central_African_Republic = 'axk';
    case Lower_Southern_Aranda = 'axl';
    case Middle_Armenian = 'axm';
    case Xaragure = 'axx';
    case Awar = 'aya';
    case Ayizo_Gbe = 'ayb';
    case Southern_Aymara = 'ayc';
    case Ayabadhu = 'ayd';
    case Ayere = 'aye';
    case Ginyanga = 'ayg';
    case Hadrami_Arabic = 'ayh';
    case Leyigha = 'ayi';
    case Akuku = 'ayk';
    case Libyan_Arabic = 'ayl';
    case Aymara = 'aym';
    case Sanaani_Arabic = 'ayn';
    case Ayoreo = 'ayo';
    case North_Mesopotamian_Arabic = 'ayp';
    case Ayi_Papua_New_Guinea = 'ayq';
    case Central_Aymara = 'ayr';
    case Sorsogon_Ayta = 'ays';
    case Magbukun_Ayta = 'ayt';
    case Ayu = 'ayu';
    case Mai_Brat = 'ayz';
    case Azha = 'aza';
    case South_Azerbaijani = 'azb';
    case Eastern_Durango_Nahuatl = 'azd';
    case Azerbaijani = 'aze';
    case San_Pedro_Amuzgos_Amuzgo = 'azg';
    case North_Azerbaijani = 'azj';
    case Ipalapa_Amuzgo = 'azm';
    case Western_Durango_Nahuatl = 'azn';
    case Awing = 'azo';
    case Faire_Atta = 'azt';
    case Highland_Puebla_Nahuatl = 'azz';
    case Babatana = 'baa';
    case Bainouk_Gunyuno = 'bab';
    case Badui = 'bac';
    case Bare = 'bae';
    case Nubaca = 'baf';
    case Tuki = 'bag';
    case Bahamas_Creole_English = 'bah';
    case Barakai = 'baj';
    case Bashkir = 'bak';
    case Baluchi = 'bal';
    case Bambara = 'bam';
    case Balinese = 'ban';
    case Waimaha = 'bao';
    case Bantawa = 'bap';
    case Bavarian = 'bar';
    case Basa_Cameroon = 'bas';
    case Bada_Nigeria = 'bau';
    case Vengo = 'bav';
    case Bambili_Bambui = 'baw';
    case Bamun = 'bax';
    case Batuley = 'bay';
    case Baatonum = 'bba';
    case Barai = 'bbb';
    case Batak_Toba = 'bbc';
    case Bau = 'bbd';
    case Bangba = 'bbe';
    case Baibai = 'bbf';
    case Barama = 'bbg';
    case Bugan = 'bbh';
    case Barombi = 'bbi';
    case Ghomala = 'bbj';
    case Babanki = 'bbk';
    case Bats = 'bbl';
    case Babango = 'bbm';
    case Uneapa = 'bbn';
    case Northern_Bobo_Madare = 'bbo';
    case West_Central_Banda = 'bbp';
    case Bamali = 'bbq';
    case Girawa = 'bbr';
    case Bakpinka = 'bbs';
    case Mburku = 'bbt';
    case Kulung_Nigeria = 'bbu';
    case Karnai = 'bbv';
    case Baba = 'bbw';
    case Bubia = 'bbx';
    case Befang = 'bby';
    case Central_Bai = 'bca';
    case Bainouk_Samik = 'bcb';
    case Southern_Balochi = 'bcc';
    case North_Babar = 'bcd';
    case Bamenyam = 'bce';
    case Bamu = 'bcf';
    case Baga_Pokur = 'bcg';
    case Bariai = 'bch';
    case Baoule = 'bci';
    case Bardi = 'bcj';
    case Bunuba = 'bck';
    case Central_Bikol = 'bcl';
    case Bannoni = 'bcm';
    case Bali_Nigeria = 'bcn';
    case Kaluli = 'bco';
    case Bali_Democratic_Republic_of_Congo = 'bcp';
    case Bench = 'bcq';
    case Babine = 'bcr';
    case Kohumono = 'bcs';
    case Bendi = 'bct';
    case Awad_Bing = 'bcu';
    case Shoo_Minda_Nye = 'bcv';
    case Bana = 'bcw';
    case Bacama = 'bcy';
    case Bainouk_Gunyaamolo = 'bcz';
    case Bayot = 'bda';
    case Basap = 'bdb';
    case Embera_Baudo = 'bdc';
    case Bunama = 'bdd';
    case Bade = 'bde';
    case Biage = 'bdf';
    case Bonggi = 'bdg';
    case Baka_South_Sudan = 'bdh';
    case Burun = 'bdi';
    case Bai_South_Sudan = 'bdj';
    case Budukh = 'bdk';
    case Indonesian_Bajau = 'bdl';
    case Buduma = 'bdm';
    case Baldemu = 'bdn';
    case Morom = 'bdo';
    case Bende = 'bdp';
    case Bahnar = 'bdq';
    case West_Coast_Bajau = 'bdr';
    case Burunge = 'bds';
    case Bokoto = 'bdt';
    case Oroko = 'bdu';
    case Bodo_Parja = 'bdv';
    case Baham = 'bdw';
    case Budong_Budong = 'bdx';
    case Bandjalang = 'bdy';
    case Badeshi = 'bdz';
    case Beaver = 'bea';
    case Bebele = 'beb';
    case Iceve_Maci = 'bec';
    case Bedoanas = 'bed';
    case Byangsi = 'bee';
    case Benabena = 'bef';
    case Belait = 'beg';
    case Biali = 'beh';
    case Bekati = 'bei';
    case Beja = 'bej';
    case Bebeli = 'bek';
    case Belarusian = 'bel';
    case Bemba_Zambia = 'bem';
    case Bengali = 'ben';
    case Beami = 'beo';
    case Besoa = 'bep';
    case Beembe = 'beq';
    case Besme = 'bes';
    case Guiberoua_Bete = 'bet';
    case Blagar = 'beu';
    case Daloa_Bete = 'bev';
    case Betawi = 'bew';
    case Jur_Modo = 'bex';
    case Beli_Papua_New_Guinea = 'bey';
    case Bena_Tanzania = 'bez';
    case Bari = 'bfa';
    case Pauri_Bareli = 'bfb';
    case Panyi_Bai = 'bfc';
    case Bafut = 'bfd';
    case Betaf = 'bfe';
    case Bofi = 'bff';
    case Busang_Kayan = 'bfg';
    case Blafe = 'bfh';
    case British_Sign_Language = 'bfi';
    case Bafanji = 'bfj';
    case Ban_Khor_Sign_Language = 'bfk';
    case Banda_Ndele = 'bfl';
    case Mmen = 'bfm';
    case Bunak = 'bfn';
    case Malba_Birifor = 'bfo';
    case Beba = 'bfp';
    case Badaga = 'bfq';
    case Bazigar = 'bfr';
    case Southern_Bai = 'bfs';
    case Balti = 'bft';
    case Gahri = 'bfu';
    case Bondo = 'bfw';
    case Bantayanon = 'bfx';
    case Bagheli = 'bfy';
    case Mahasu_Pahari = 'bfz';
    case Gwamhi_Wuri = 'bga';
    case Bobongko = 'bgb';
    case Haryanvi = 'bgc';
    case Rathwi_Bareli = 'bgd';
    case Bauria = 'bge';
    case Bangandu = 'bgf';
    case Bugun = 'bgg';
    case Giangan = 'bgi';
    case Bangolan = 'bgj';
    case Bit = 'bgk';
    case Bo_Laos = 'bgl';
    case Western_Balochi = 'bgn';
    case Baga_Koga = 'bgo';
    case Eastern_Balochi = 'bgp';
    case Bagri = 'bgq';
    case Bawm_Chin = 'bgr';
    case Tagabawa = 'bgs';
    case Bughotu = 'bgt';
    case Mbongno = 'bgu';
    case Warkay_Bipim = 'bgv';
    case Bhatri = 'bgw';
    case Balkan_Gagauz_Turkish = 'bgx';
    case Benggoi = 'bgy';
    case Banggai = 'bgz';
    case Bharia = 'bha';
    case Bhili = 'bhb';
    case Biga = 'bhc';
    case Bhadrawahi = 'bhd';
    case Bhaya = 'bhe';
    case Odiai = 'bhf';
    case Binandere = 'bhg';
    case Bukharic = 'bhh';
    case Bhilali = 'bhi';
    case Bahing = 'bhj';
    case Bimin = 'bhl';
    case Bathari = 'bhm';
    case Bohtan_Neo_Aramaic = 'bhn';
    case Bhojpuri = 'bho';
    case Bima = 'bhp';
    case Tukang_Besi_South = 'bhq';
    case Bara_Malagasy = 'bhr';
    case Buwal = 'bhs';
    case Bhattiyali = 'bht';
    case Bhunjia = 'bhu';
    case Bahau = 'bhv';
    case Biak = 'bhw';
    case Bhalay = 'bhx';
    case Bhele = 'bhy';
    case Bada_Indonesia = 'bhz';
    case Badimaya = 'bia';
    case Bissa = 'bib';
    case Bidiyo = 'bid';
    case Bepour = 'bie';
    case Biafada = 'bif';
    case Biangai = 'big';
    case Bikol = 'bik';
    case Bile = 'bil';
    case Bimoba = 'bim';
    case Bini = 'bin';
    case Nai = 'bio';
    case Bila = 'bip';
    case Bipi = 'biq';
    case Bisorio = 'bir';
    case Bislama = 'bis';
    case Berinomo = 'bit';
    case Biete = 'biu';
    case Southern_Birifor = 'biv';
    case Kol_Cameroon = 'biw';
    case Bijori = 'bix';
    case Birhor = 'biy';
    case Baloi = 'biz';
    case Budza = 'bja';
    case Banggarla = 'bjb';
    case Bariji = 'bjc';
    case Biao_Jiao_Mien = 'bje';
    case Barzani_Jewish_Neo_Aramaic = 'bjf';
    case Bidyogo = 'bjg';
    case Bahinemo = 'bjh';
    case Burji = 'bji';
    case Kanauji = 'bjj';
    case Barok = 'bjk';
    case Bulu_Papua_New_Guinea = 'bjl';
    case Bajelani = 'bjm';
    case Banjar = 'bjn';
    case Mid_Southern_Banda = 'bjo';
    case Fanamaket = 'bjp';
    case Binumarien = 'bjr';
    case Bajan = 'bjs';
    case Balanta_Ganja = 'bjt';
    case Busuu = 'bju';
    case Bedjond = 'bjv';
    case Bakwe = 'bjw';
    case Banao_Itneg = 'bjx';
    case Bayali = 'bjy';
    case Baruga = 'bjz';
    case Kyak = 'bka';
    case Baka_Cameroon = 'bkc';
    case Binukid = 'bkd';
    case Beeke = 'bkf';
    case Buraka = 'bkg';
    case Bakoko = 'bkh';
    case Baki = 'bki';
    case Pande = 'bkj';
    case Brokskat = 'bkk';
    case Berik = 'bkl';
    case Kom_Cameroon = 'bkm';
    case Bukitan = 'bkn';
    case Kwa = 'bko';
    case Boko_Democratic_Republic_of_Congo = 'bkp';
    case Bakairi = 'bkq';
    case Bakumpai = 'bkr';
    case Northern_Sorsoganon = 'bks';
    case Boloki = 'bkt';
    case Buhid = 'bku';
    case Bekwarra = 'bkv';
    case Bekwel = 'bkw';
    case Baikeno = 'bkx';
    case Bokyi = 'bky';
    case Bungku = 'bkz';
    case Siksika = 'bla';
    case Bilua = 'blb';
    case Bella_Coola = 'blc';
    case Bolango = 'bld';
    case Balanta_Kentohe = 'ble';
    case Buol = 'blf';
    case Kuwaa = 'blh';
    case Bolia = 'bli';
    case Bolongan = 'blj';
    case Pa_o_Karen = 'blk';
    case Biloxi = 'bll';
    case Beli_South_Sudan = 'blm';
    case Southern_Catanduanes_Bikol = 'bln';
    case Anii = 'blo';
    case Blablanga = 'blp';
    case Baluan_Pam = 'blq';
    case Blang = 'blr';
    case Balaesang = 'bls';
    case Tai_Dam = 'blt';
    case Kibala = 'blv';
    case Balangao = 'blw';
    case Mag_Indi_Ayta = 'blx';
    case Notre = 'bly';
    case Balantak = 'blz';
    case Lame = 'bma';
    case Bembe = 'bmb';
    case Biem = 'bmc';
    case Baga_Manduri = 'bmd';
    case Limassa = 'bme';
    case Bom_Kim = 'bmf';
    case Bamwe = 'bmg';
    case Kein = 'bmh';
    case Bagirmi = 'bmi';
    case Bote_Majhi = 'bmj';
    case Ghayavi = 'bmk';
    case Bomboli = 'bml';
    case Northern_Betsimisaraka_Malagasy = 'bmm';
    case Bina_Papua_New_Guinea = 'bmn';
    case Bambalang = 'bmo';
    case Bulgebi = 'bmp';
    case Bomu = 'bmq';
    case Muinane = 'bmr';
    case Bilma_Kanuri = 'bms';
    case Biao_Mon = 'bmt';
    case Somba_Siawari = 'bmu';
    case Bum = 'bmv';
    case Bomwali = 'bmw';
    case Baimak = 'bmx';
    case Baramu = 'bmz';
    case Bonerate = 'bna';
    case Bookan = 'bnb';
    case Bontok = 'bnc';
    case Banda_Indonesia = 'bnd';
    case Bintauna = 'bne';
    case Masiwang = 'bnf';
    case Benga = 'bng';
    case Bangi = 'bni';
    case Eastern_Tawbuid = 'bnj';
    case Bierebo = 'bnk';
    case Boon = 'bnl';
    case Batanga = 'bnm';
    case Bunun = 'bnn';
    case Bantoanon = 'bno';
    case Bola = 'bnp';
    case Bantik = 'bnq';
    case Butmas_Tur = 'bnr';
    case Bundeli = 'bns';
    case Bentong = 'bnu';
    case Bonerif = 'bnv';
    case Bisis = 'bnw';
    case Bangubangu = 'bnx';
    case Bintulu = 'bny';
    case Beezen = 'bnz';
    case Bora = 'boa';
    case Aweer = 'bob';
    case Tibetan = 'bod';
    case Mundabli = 'boe';
    case Bolon = 'bof';
    case Bamako_Sign_Language = 'bog';
    case Boma = 'boh';
    case Barbareno = 'boi';
    case Anjam = 'boj';
    case Bonjo = 'bok';
    case Bole = 'bol';
    case Berom = 'bom';
    case Bine = 'bon';
    case Tiemacewe_Bozo = 'boo';
    case Bonkiman = 'bop';
    case Bogaya = 'boq';
    case Bororo = 'bor';
    case Bosnian = 'bos';
    case Bongo = 'bot';
    case Bondei = 'bou';
    case Tuwuli = 'bov';
    case Rema = 'bow';
    case Buamu = 'box';
    case Bodo_Central_African_Republic = 'boy';
    case Tieyaxo_Bozo = 'boz';
    case Daakaka = 'bpa';
    case Mbuk = 'bpc';
    case Banda_Banda = 'bpd';
    case Bauni = 'bpe';
    case Bonggo = 'bpg';
    case Botlikh = 'bph';
    case Bagupi = 'bpi';
    case Binji = 'bpj';
    case Orowe = 'bpk';
    case Broome_Pearling_Lugger_Pidgin = 'bpl';
    case Biyom = 'bpm';
    case Dzao_Min = 'bpn';
    case Anasi = 'bpo';
    case Kaure = 'bpp';
    case Banda_Malay = 'bpq';
    case Koronadal_Blaan = 'bpr';
    case Sarangani_Blaan = 'bps';
    case Barrow_Point = 'bpt';
    case Bongu = 'bpu';
    case Bian_Marind = 'bpv';
    case Bo_Papua_New_Guinea = 'bpw';
    case Palya_Bareli = 'bpx';
    case Bishnupriya = 'bpy';
    case Bilba = 'bpz';
    case Tchumbuli = 'bqa';
    case Bagusa = 'bqb';
    case Boko_Benin = 'bqc';
    case Bung = 'bqd';
    case Baga_Kaloum = 'bqf';
    case Bago_Kusuntu = 'bqg';
    case Baima = 'bqh';
    case Bakhtiari = 'bqi';
    case Bandial = 'bqj';
    case Banda_Mbres = 'bqk';
    case Bilakura = 'bql';
    case Wumboko = 'bqm';
    case Bulgarian_Sign_Language = 'bqn';
    case Balo = 'bqo';
    case Busa = 'bqp';
    case Biritai = 'bqq';
    case Burusu = 'bqr';
    case Bosngun = 'bqs';
    case Bamukumbit = 'bqt';
    case Boguru = 'bqu';
    case Koro_Wachi = 'bqv';
    case Buru_Nigeria = 'bqw';
    case Baangi = 'bqx';
    case Bengkala_Sign_Language = 'bqy';
    case Bakaka = 'bqz';
    case Braj = 'bra';
    case Brao = 'brb';
    case Berbice_Creole_Dutch = 'brc';
    case Baraamu = 'brd';
    case Breton = 'bre';
    case Bira = 'brf';
    case Baure = 'brg';
    case Brahui = 'brh';
    case Mokpwe = 'bri';
    case Bieria = 'brj';
    case Birked = 'brk';
    case Birwa = 'brl';
    case Barambu = 'brm';
    case Boruca = 'brn';
    case Brokkat = 'bro';
    case Barapasi = 'brp';
    case Breri = 'brq';
    case Birao = 'brr';
    case Baras = 'brs';
    case Bitare = 'brt';
    case Eastern_Bru = 'bru';
    case Western_Bru = 'brv';
    case Bellari = 'brw';
    case Bodo_India = 'brx';
    case Burui = 'bry';
    case Bilbil = 'brz';
    case Abinomn = 'bsa';
    case Brunei_Bisaya = 'bsb';
    case Bassari = 'bsc';
    case Wushi = 'bse';
    case Bauchi = 'bsf';
    case Bashkardi = 'bsg';
    case Kati = 'bsh';
    case Bassossi = 'bsi';
    case Bangwinji = 'bsj';
    case Burushaski = 'bsk';
    case Basa_Gumna = 'bsl';
    case Busami = 'bsm';
    case Barasana_Eduria = 'bsn';
    case Buso = 'bso';
    case Baga_Sitemu = 'bsp';
    case Bassa = 'bsq';
    case Bassa_Kontagora = 'bsr';
    case Akoose = 'bss';
    case Basketo = 'bst';
    case Bahonsuai = 'bsu';
    case Baga_Sobane = 'bsv';
    case Baiso = 'bsw';
    case Yangkam = 'bsx';
    case Sabah_Bisaya = 'bsy';
    case Bata = 'bta';
    case Bati_Cameroon = 'btc';
    case Batak_Dairi = 'btd';
    case Gamo_Ningi = 'bte';
    case Birgit = 'btf';
    case Gagnoa_Bete = 'btg';
    case Biatah_Bidayuh = 'bth';
    case Burate = 'bti';
    case Bacanese_Malay = 'btj';
    case Batak_Mandailing = 'btm';
    case Ratagnon = 'btn';
    case Rinconada_Bikol = 'bto';
    case Budibud = 'btp';
    case Batek = 'btq';
    case Baetora = 'btr';
    case Batak_Simalungun = 'bts';
    case Bete_Bendi = 'btt';
    case Batu = 'btu';
    case Bateri = 'btv';
    case Butuanon = 'btw';
    case Batak_Karo = 'btx';
    case Bobot = 'bty';
    case Batak_Alas_Kluet = 'btz';
    case Buriat = 'bua';
    case Bua = 'bub';
    case Bushi = 'buc';
    case Ntcham = 'bud';
    case Beothuk = 'bue';
    case Bushoong = 'buf';
    case Buginese = 'bug';
    case Younuo_Bunu = 'buh';
    case Bongili = 'bui';
    case Basa_Gurmana = 'buj';
    case Bugawac = 'buk';
    case Bulgarian = 'bul';
    case Bulu_Cameroon = 'bum';
    case Sherbro = 'bun';
    case Terei = 'buo';
    case Busoa = 'bup';
    case Brem = 'buq';
    case Bokobaru = 'bus';
    case Bungain = 'but';
    case Budu = 'buu';
    case Bun = 'buv';
    case Bubi = 'buw';
    case Boghom = 'bux';
    case Bullom_So = 'buy';
    case Bukwen = 'buz';
    case Barein = 'bva';
    case Bube = 'bvb';
    case Baelelea = 'bvc';
    case Baeggu = 'bvd';
    case Berau_Malay = 'bve';
    case Boor = 'bvf';
    case Bonkeng = 'bvg';
    case Bure = 'bvh';
    case Belanda_Viri = 'bvi';
    case Baan = 'bvj';
    case Bukat = 'bvk';
    case Bolivian_Sign_Language = 'bvl';
    case Bamunka = 'bvm';
    case Buna = 'bvn';
    case Bolgo = 'bvo';
    case Bumang = 'bvp';
    case Birri = 'bvq';
    case Burarra = 'bvr';
    case Bati_Indonesia = 'bvt';
    case Bukit_Malay = 'bvu';
    case Baniva = 'bvv';
    case Boga = 'bvw';
    case Dibole = 'bvx';
    case Baybayanon = 'bvy';
    case Bauzi = 'bvz';
    case Bwatoo = 'bwa';
    case Namosi_Naitasiri_Serua = 'bwb';
    case Bwile = 'bwc';
    case Bwaidoka = 'bwd';
    case Bwe_Karen = 'bwe';
    case Boselewa = 'bwf';
    case Barwe = 'bwg';
    case Bishuo = 'bwh';
    case Baniwa = 'bwi';
    case Laa_Laa_Bwamu = 'bwj';
    case Bauwaki = 'bwk';
    case Bwela = 'bwl';
    case Biwat = 'bwm';
    case Wunai_Bunu = 'bwn';
    case Boro_Ethiopia = 'bwo';
    case Mandobo_Bawah = 'bwp';
    case Southern_Bobo_Madare = 'bwq';
    case Bura_Pabir = 'bwr';
    case Bomboma = 'bws';
    case Bafaw_Balong = 'bwt';
    case Buli_Ghana = 'bwu';
    case Bwa = 'bww';
    case Bu_Nao_Bunu = 'bwx';
    case Cwi_Bwamu = 'bwy';
    case Bwisi = 'bwz';
    case Tairaha = 'bxa';
    case Belanda_Bor = 'bxb';
    case Molengue = 'bxc';
    case Pela = 'bxd';
    case Birale = 'bxe';
    case Bilur = 'bxf';
    case Bangala = 'bxg';
    case Buhutu = 'bxh';
    case Pirlatapa = 'bxi';
    case Bayungu = 'bxj';
    case Bukusu = 'bxk';
    case Jalkunan = 'bxl';
    case Mongolia_Buriat = 'bxm';
    case Burduna = 'bxn';
    case Barikanchi = 'bxo';
    case Bebil = 'bxp';
    case Beele = 'bxq';
    case Russia_Buriat = 'bxr';
    case Busam = 'bxs';
    case China_Buriat = 'bxu';
    case Berakou = 'bxv';
    case Bankagooma = 'bxw';
    case Binahari = 'bxz';
    case Batak = 'bya';
    case Bikya = 'byb';
    case Ubaghara = 'byc';
    case Benyadu = 'byd';
    case Pouye = 'bye';
    case Bete = 'byf';
    case Baygo = 'byg';
    case Bhujel = 'byh';
    case Buyu = 'byi';
    case Bina_Nigeria = 'byj';
    case Biao = 'byk';
    case Bayono = 'byl';
    case Bidjara = 'bym';
    case Bilin = 'byn';
    case Biyo = 'byo';
    case Bumaji = 'byp';
    case Basay = 'byq';
    case Baruya = 'byr';
    case Burak = 'bys';
    case Berti = 'byt';
    case Medumba = 'byv';
    case Belhariya = 'byw';
    case Qaqet = 'byx';
    case Banaro = 'byz';
    case Bandi = 'bza';
    case Andio = 'bzb';
    case Southern_Betsimisaraka_Malagasy = 'bzc';
    case Bribri = 'bzd';
    case Jenaama_Bozo = 'bze';
    case Boikin = 'bzf';
    case Babuza = 'bzg';
    case Mapos_Buang = 'bzh';
    case Bisu = 'bzi';
    case Belize_Kriol_English = 'bzj';
    case Nicaragua_Creole_English = 'bzk';
    case Boano_Sulawesi = 'bzl';
    case Bolondo = 'bzm';
    case Boano_Maluku = 'bzn';
    case Bozaba = 'bzo';
    case Kemberano = 'bzp';
    case Buli_Indonesia = 'bzq';
    case Biri = 'bzr';
    case Brazilian_Sign_Language = 'bzs';
    case Brithenig = 'bzt';
    case Burmeso = 'bzu';
    case Naami = 'bzv';
    case Basa_Nigeria = 'bzw';
    case Kelengaxo_Bozo = 'bzx';
    case Obanliku = 'bzy';
    case Evant = 'bzz';
    case Chorti = 'caa';
    case Garifuna = 'cab';
    case Chuj = 'cac';
    case Caddo = 'cad';
    case Lehar = 'cae';
    case Southern_Carrier = 'caf';
    case Nivacle = 'cag';
    case Cahuarano = 'cah';
    case Chane = 'caj';
    case Kaqchikel = 'cak';
    case Carolinian = 'cal';
    case Cemuhi = 'cam';
    case Chambri = 'can';
    case Chacobo = 'cao';
    case Chipaya = 'cap';
    case Car_Nicobarese = 'caq';
    case Galibi_Carib = 'car';
    case Tsimane = 'cas';
    case Catalan = 'cat';
    case Cavinena = 'cav';
    case Callawalla = 'caw';
    case Chiquitano = 'cax';
    case Cayuga = 'cay';
    case Canichana = 'caz';
    case Cabiyari = 'cbb';
    case Carapana = 'cbc';
    case Carijona = 'cbd';
    case Chimila = 'cbg';
    case Chachi = 'cbi';
    case Ede_Cabe = 'cbj';
    case Chavacano = 'cbk';
    case Bualkhaw_Chin = 'cbl';
    case Nyahkur = 'cbn';
    case Izora = 'cbo';
    case Tsucuba = 'cbq';
    case Cashibo_Cacataibo = 'cbr';
    case Cashinahua = 'cbs';
    case Chayahuita = 'cbt';
    case Candoshi_Shapra = 'cbu';
    case Cacua = 'cbv';
    case Kinabalian = 'cbw';
    case Carabayo = 'cby';
    case Chamicuro = 'ccc';
    case Cafundo_Creole = 'ccd';
    case Chopi = 'cce';
    case Samba_Daka = 'ccg';
    case Atsam = 'cch';
    case Kasanga = 'ccj';
    case Cutchi_Swahili = 'ccl';
    case Malaccan_Creole_Malay = 'ccm';
    case Comaltepec_Chinantec = 'cco';
    case Chakma = 'ccp';
    case Cacaopera = 'ccr';
    case Choni = 'cda';
    case Chenchu = 'cde';
    case Chiru = 'cdf';
    case Chambeali = 'cdh';
    case Chodri = 'cdi';
    case Churahi = 'cdj';
    case Chepang = 'cdm';
    case Chaudangsi = 'cdn';
    case Min_Dong_Chinese = 'cdo';
    case Cinda_Regi_Tiyal = 'cdr';
    case Chadian_Sign_Language = 'cds';
    case Chadong = 'cdy';
    case Koda = 'cdz';
    case Lower_Chehalis = 'cea';
    case Cebuano = 'ceb';
    case Chamacoco = 'ceg';
    case Eastern_Khumi_Chin = 'cek';
    case Cen = 'cen';
    case Czech = 'ces';
    case Centuum = 'cet';
    case Ekai_Chin = 'cey';
    case Dijim_Bwilim = 'cfa';
    case Cara = 'cfd';
    case Como_Karim = 'cfg';
    case Falam_Chin = 'cfm';
    case Changriwa = 'cga';
    case Kagayanen = 'cgc';
    case Chiga = 'cgg';
    case Chocangacakha = 'cgk';
    case Chamorro = 'cha';
    case Chibcha = 'chb';
    case Catawba = 'chc';
    case Highland_Oaxaca_Chontal = 'chd';
    case Chechen = 'che';
    case Tabasco_Chontal = 'chf';
    case Chagatai = 'chg';
    case Chinook = 'chh';
    case Ojitlan_Chinantec = 'chj';
    case Chuukese = 'chk';
    case Cahuilla = 'chl';
    case Mari_Russia = 'chm';
    case Chinook_jargon = 'chn';
    case Choctaw = 'cho';
    case Chipewyan = 'chp';
    case Quiotepec_Chinantec = 'chq';
    case Cherokee = 'chr';
    case Cholon = 'cht';
    case Church_Slavic = 'chu';
    case Chuvash = 'chv';
    case Chuwabu = 'chw';
    case Chantyal = 'chx';
    case Cheyenne = 'chy';
    case Ozumacin_Chinantec = 'chz';
    case Cia_Cia = 'cia';
    case Ci_Gbe = 'cib';
    case Chickasaw = 'cic';
    case Chimariko = 'cid';
    case Cineni = 'cie';
    case Chinali = 'cih';
    case Chitkuli_Kinnauri = 'cik';
    case Cimbrian = 'cim';
    case Cinta_Larga = 'cin';
    case Chiapanec = 'cip';
    case Tiri = 'cir';
    case Chippewa = 'ciw';
    case Chaima = 'ciy';
    case Western_Cham = 'cja';
    case Chru = 'cje';
    case Upper_Chehalis = 'cjh';
    case Chamalal = 'cji';
    case Chokwe = 'cjk';
    case Eastern_Cham = 'cjm';
    case Chenapian = 'cjn';
    case Asheninka_Pajonal = 'cjo';
    case Cabecar = 'cjp';
    case Shor = 'cjs';
    case Chuave = 'cjv';
    case Jinyu_Chinese = 'cjy';
    case Central_Kurdish = 'ckb';
    case Chak = 'ckh';
    case Cibak = 'ckl';
    case Chakavian = 'ckm';
    case Kaang_Chin = 'ckn';
    case Anufo = 'cko';
    case Kajakse = 'ckq';
    case Kairak = 'ckr';
    case Tayo = 'cks';
    case Chukot = 'ckt';
    case Koasati = 'cku';
    case Kavalan = 'ckv';
    case Caka = 'ckx';
    case Cakfem_Mushere = 'cky';
    case Cakchiquel_Quiche_Mixed_Language = 'ckz';
    case Ron = 'cla';
    case Chilcotin = 'clc';
    case Chaldean_Neo_Aramaic = 'cld';
    case Lealao_Chinantec = 'cle';
    case Chilisso = 'clh';
    case Chakali = 'cli';
    case Laitu_Chin = 'clj';
    case Idu_Mishmi = 'clk';
    case Chala = 'cll';
    case Clallam = 'clm';
    case Lowland_Oaxaca_Chontal = 'clo';
    case Classical_Sanskrit = 'cls';
    case Lautu_Chin = 'clt';
    case Caluyanun = 'clu';
    case Chulym = 'clw';
    case Eastern_Highland_Chatino = 'cly';
    case Maa = 'cma';
    case Cerma = 'cme';
    case Classical_Mongolian = 'cmg';
    case Embera_Chami = 'cmi';
    case Campalagian = 'cml';
    case Michigamea = 'cmm';
    case Mandarin_Chinese = 'cmn';
    case Central_Mnong = 'cmo';
    case Mro_Khimi_Chin = 'cmr';
    case Messapic = 'cms';
    case Camtho = 'cmt';
    case Changthang = 'cna';
    case Chinbon_Chin = 'cnb';
    case Coong = 'cnc';
    case Northern_Qiang = 'cng';
    case Hakha_Chin = 'cnh';
    case Ashaninka = 'cni';
    case Khumi_Chin = 'cnk';
    case Lalana_Chinantec = 'cnl';
    case Con = 'cno';
    case Northern_Ping_Chinese = 'cnp';
    case Chung = 'cnq';
    case Montenegrin = 'cnr';
    case Central_Asmat = 'cns';
    case Tepetotutla_Chinantec = 'cnt';
    case Chenoua = 'cnu';
    case Ngawn_Chin = 'cnw';
    case Middle_Cornish = 'cnx';
    case Cocos_Islands_Malay = 'coa';
    case Chicomuceltec = 'cob';
    case Cocopa = 'coc';
    case Cocama_Cocamilla = 'cod';
    case Koreguaje = 'coe';
    case Colorado = 'cof';
    case Chong = 'cog';
    case Chonyi_Dzihana_Kauma = 'coh';
    case Cochimi = 'coj';
    case Santa_Teresa_Cora = 'cok';
    case Columbia_Wenatchi = 'col';
    case Comanche = 'com';
    case Cofan = 'con';
    case Comox = 'coo';
    case Coptic = 'cop';
    case Coquille = 'coq';
    case Cornish = 'cor';
    case Corsican = 'cos';
    case Caquinte = 'cot';
    case Wamey = 'cou';
    case Cao_Miao = 'cov';
    case Cowlitz = 'cow';
    case Nanti = 'cox';
    case Chochotec = 'coz';
    case Palantla_Chinantec = 'cpa';
    case Ucayali_Yurua_Asheninka = 'cpb';
    case Ajyininka_Apurucayali = 'cpc';
    case Cappadocian_Greek = 'cpg';
    case Chinese_Pidgin_English = 'cpi';
    case Cherepon = 'cpn';
    case Kpeego = 'cpo';
    case Capiznon = 'cps';
    case Pichis_Asheninka = 'cpu';
    case Pu_Xian_Chinese = 'cpx';
    case South_Ucayali_Asheninka = 'cpy';
    case Chuanqiandian_Cluster_Miao = 'cqd';
    case Chara = 'cra';
    case Island_Carib = 'crb';
    case Lonwolwol = 'crc';
    case Coeur_d_Alene = 'crd';
    case Cree = 'cre';
    case Caramanta = 'crf';
    case Michif = 'crg';
    case Crimean_Tatar = 'crh';
    case Saotomense = 'cri';
    case Southern_East_Cree = 'crj';
    case Plains_Cree = 'crk';
    case Northern_East_Cree = 'crl';
    case Moose_Cree = 'crm';
    case El_Nayar_Cora = 'crn';
    case Crow = 'cro';
    case Iyo_wujwa_Chorote = 'crq';
    case Carolina_Algonquian = 'crr';
    case Seselwa_Creole_French = 'crs';
    case Iyojwa_ja_Chorote = 'crt';
    case Chaura = 'crv';
    case Chrau = 'crw';
    case Carrier = 'crx';
    case Cori = 'cry';
    case Cruzeno = 'crz';
    case Chiltepec_Chinantec = 'csa';
    case Kashubian = 'csb';
    case Catalan_Sign_Language = 'csc';
    case Chiangmai_Sign_Language = 'csd';
    case Czech_Sign_Language = 'cse';
    case Cuba_Sign_Language = 'csf';
    case Chilean_Sign_Language = 'csg';
    case Asho_Chin = 'csh';
    case Coast_Miwok = 'csi';
    case Songlai_Chin = 'csj';
    case Jola_Kasa = 'csk';
    case Chinese_Sign_Language = 'csl';
    case Central_Sierra_Miwok = 'csm';
    case Colombian_Sign_Language = 'csn';
    case Sochiapam_Chinantec = 'cso';
    case Southern_Ping_Chinese = 'csp';
    case Croatia_Sign_Language = 'csq';
    case Costa_Rican_Sign_Language = 'csr';
    case Southern_Ohlone = 'css';
    case Northern_Ohlone = 'cst';
    case Sumtu_Chin = 'csv';
    case Swampy_Cree = 'csw';
    case Cambodian_Sign_Language = 'csx';
    case Siyin_Chin = 'csy';
    case Coos = 'csz';
    case Tataltepec_Chatino = 'cta';
    case Chetco = 'ctc';
    case Tedim_Chin = 'ctd';
    case Tepinapa_Chinantec = 'cte';
    case Chittagonian = 'ctg';
    case Thaiphum_Chin = 'cth';
    case Tlacoatzintepec_Chinantec = 'ctl';
    case Chitimacha = 'ctm';
    case Chhintange = 'ctn';
    case Embera_Catio = 'cto';
    case Western_Highland_Chatino = 'ctp';
    case Northern_Catanduanes_Bikol = 'cts';
    case Wayanad_Chetti = 'ctt';
    case Chol = 'ctu';
    case Moundadan_Chetty = 'cty';
    case Zacatepec_Chatino = 'ctz';
    case Cua = 'cua';
    case Cubeo = 'cub';
    case Usila_Chinantec = 'cuc';
    case Chuka = 'cuh';
    case Cuiba = 'cui';
    case Mashco_Piro = 'cuj';
    case San_Blas_Kuna = 'cuk';
    case Culina = 'cul';
    case Cumanagoto = 'cuo';
    case Cupeno = 'cup';
    case Cun = 'cuq';
    case Chhulung = 'cur';
    case Teutila_Cuicatec = 'cut';
    case Tai_Ya = 'cuu';
    case Cuvok = 'cuv';
    case Chukwa = 'cuw';
    case Tepeuxila_Cuicatec = 'cux';
    case Cuitlatec = 'cuy';
    case Chug = 'cvg';
    case Valle_Nacional_Chinantec = 'cvn';
    case Kabwa = 'cwa';
    case Maindo = 'cwb';
    case Woods_Cree = 'cwd';
    case Kwere = 'cwe';
    case Chewong = 'cwg';
    case Kuwaataay = 'cwt';
    case Cha_ari = 'cxh';
    case Nopala_Chatino = 'cya';
    case Cayubaba = 'cyb';
    case Welsh = 'cym';
    case Cuyonon = 'cyo';
    case Huizhou_Chinese = 'czh';
    case Knaanic = 'czk';
    case Zenzontepec_Chatino = 'czn';
    case Min_Zhong_Chinese = 'czo';
    case Zotung_Chin = 'czt';
    case Dangaleat = 'daa';
    case Dambi = 'dac';
    case Marik = 'dad';
    case Duupa = 'dae';
    case Dagbani = 'dag';
    case Gwahatike = 'dah';
    case Day = 'dai';
    case Dar_Fur_Daju = 'daj';
    case Dakota = 'dak';
    case Dahalo = 'dal';
    case Damakawa = 'dam';
    case Danish = 'dan';
    case Daai_Chin = 'dao';
    case Dandami_Maria = 'daq';
    case Dargwa = 'dar';
    case Daho_Doo = 'das';
    case Dar_Sila_Daju = 'dau';
    case Taita = 'dav';
    case Davawenyo = 'daw';
    case Dayi = 'dax';
    case Dao = 'daz';
    case Bangime = 'dba';
    case Deno = 'dbb';
    case Dadiya = 'dbd';
    case Dabe = 'dbe';
    case Edopi = 'dbf';
    case Dogul_Dom_Dogon = 'dbg';
    case Doka = 'dbi';
    case Ida_an = 'dbj';
    case Dyirbal = 'dbl';
    case Duguri = 'dbm';
    case Duriankere = 'dbn';
    case Dulbu = 'dbo';
    case Duwai = 'dbp';
    case Daba = 'dbq';
    case Dabarre = 'dbr';
    case Ben_Tey_Dogon = 'dbt';
    case Bondum_Dom_Dogon = 'dbu';
    case Dungu = 'dbv';
    case Bankan_Tey_Dogon = 'dbw';
    case Dibiyaso = 'dby';
    case Deccan = 'dcc';
    case Negerhollands = 'dcr';
    case Dadi_Dadi = 'dda';
    case Dongotono = 'ddd';
    case Doondo = 'dde';
    case Fataluku = 'ddg';
    case West_Goodenough = 'ddi';
    case Jaru = 'ddj';
    case Dendi_Benin = 'ddn';
    case Dido = 'ddo';
    case Dhudhuroa = 'ddr';
    case Donno_So_Dogon = 'dds';
    case Dawera_Daweloor = 'ddw';
    case Dagik = 'dec';
    case Dedua = 'ded';
    case Dewoin = 'dee';
    case Dezfuli = 'def';
    case Degema = 'deg';
    case Dehwari = 'deh';
    case Demisa = 'dei';
    case Delaware = 'del';
    case Dem = 'dem';
    case Slave_Athapascan = 'den';
    case Pidgin_Delaware = 'dep';
    case Dendi_Central_African_Republic = 'deq';
    case Deori = 'der';
    case Desano = 'des';
    case German = 'deu';
    case Domung = 'dev';
    case Dengese = 'dez';
    case Southern_Dagaare = 'dga';
    case Bunoge_Dogon = 'dgb';
    case Casiguran_Dumagat_Agta = 'dgc';
    case Dagaari_Dioula = 'dgd';
    case Degenan = 'dge';
    case Doga = 'dgg';
    case Dghwede = 'dgh';
    case Northern_Dagara = 'dgi';
    case Dagba = 'dgk';
    case Andaandi = 'dgl';
    case Dagoman = 'dgn';
    case Dogri_individual_language = 'dgo';
    case Dogrib = 'dgr';
    case Dogoso = 'dgs';
    case Ndra_ngith = 'dgt';
    case Daungwurrung = 'dgw';
    case Doghoro = 'dgx';
    case Daga = 'dgz';
    case Dhundari = 'dhd';
    case Dhangu_Djangu = 'dhg';
    case Dhimal = 'dhi';
    case Dhalandji = 'dhl';
    case Zemba = 'dhm';
    case Dhanki = 'dhn';
    case Dhodia = 'dho';
    case Dhargari = 'dhr';
    case Dhaiso = 'dhs';
    case Dhurga = 'dhu';
    case Dehu = 'dhv';
    case Dhanwar_Nepal = 'dhw';
    case Dhungaloo = 'dhx';
    case Dia = 'dia';
    case South_Central_Dinka = 'dib';
    case Lakota_Dida = 'dic';
    case Didinga = 'did';
    case Dieri = 'dif';
    case Digo = 'dig';
    case Kumiai = 'dih';
    case Dimbong = 'dii';
    case Dai = 'dij';
    case Southwestern_Dinka = 'dik';
    case Dilling = 'dil';
    case Dime = 'dim';
    case Dinka = 'din';
    case Dibo = 'dio';
    case Northeastern_Dinka = 'dip';
    case Dimli_individual_language = 'diq';
    case Dirim = 'dir';
    case Dimasa = 'dis';
    case Diriku = 'diu';
    case Dhivehi = 'div';
    case Northwestern_Dinka = 'diw';
    case Dixon_Reef = 'dix';
    case Diuwe = 'diy';
    case Ding = 'diz';
    case Djadjawurrung = 'dja';
    case Djinba = 'djb';
    case Dar_Daju_Daju = 'djc';
    case Djamindjung = 'djd';
    case Zarma = 'dje';
    case Djangun = 'djf';
    case Djinang = 'dji';
    case Djeebbana = 'djj';
    case Eastern_Maroon_Creole = 'djk';
    case Jamsay_Dogon = 'djm';
    case Jawoyn = 'djn';
    case Jangkang = 'djo';
    case Djambarrpuyngu = 'djr';
    case Kapriman = 'dju';
    case Djawi = 'djw';
    case Dakpakha = 'dka';
    case Kadung = 'dkg';
    case Dakka = 'dkk';
    case Kuijau = 'dkr';
    case Southeastern_Dinka = 'dks';
    case Mazagway = 'dkx';
    case Dolgan = 'dlg';
    case Dahalik = 'dlk';
    case Dalmatian = 'dlm';
    case Darlong = 'dln';
    case Duma = 'dma';
    case Mombo_Dogon = 'dmb';
    case Gavak = 'dmc';
    case Madhi_Madhi = 'dmd';
    case Dugwor = 'dme';
    case Medefaidrin = 'dmf';
    case Upper_Kinabatangan = 'dmg';
    case Domaaki = 'dmk';
    case Dameli = 'dml';
    case Dama = 'dmm';
    case Kemedzung = 'dmo';
    case East_Damar = 'dmr';
    case Dampelas = 'dms';
    case Dubu = 'dmu';
    case Dumpas = 'dmv';
    case Mudburra = 'dmw';
    case Dema = 'dmx';
    case Demta = 'dmy';
    case Upper_Grand_Valley_Dani = 'dna';
    case Daonda = 'dnd';
    case Ndendeule = 'dne';
    case Dungan = 'dng';
    case Lower_Grand_Valley_Dani = 'dni';
    case Dan = 'dnj';
    case Dengka = 'dnk';
    case Dzuungoo = 'dnn';
    case Ndrulo = 'dno';
    case Danaru = 'dnr';
    case Mid_Grand_Valley_Dani = 'dnt';
    case Danau = 'dnu';
    case Danu = 'dnv';
    case Western_Dani = 'dnw';
    case Deni = 'dny';
    case Dom = 'doa';
    case Dobu = 'dob';
    case Northern_Dong = 'doc';
    case Doe = 'doe';
    case Domu = 'dof';
    case Dong = 'doh';
    case Dogri_macrolanguage = 'doi';
    case Dondo = 'dok';
    case Doso = 'dol';
    case Toura_Papua_New_Guinea = 'don';
    case Dongo = 'doo';
    case Lukpa = 'dop';
    case Dominican_Sign_Language = 'doq';
    case Dori_o = 'dor';
    case Dogose = 'dos';
    case Dass = 'dot';
    case Dombe = 'dov';
    case Doyayo = 'dow';
    case Bussa = 'dox';
    case Dompo = 'doy';
    case Dorze = 'doz';
    case Papar = 'dpp';
    case Dair = 'drb';
    case Minderico = 'drc';
    case Darmiya = 'drd';
    case Dolpo = 'dre';
    case Rungus = 'drg';
    case C_Lela = 'dri';
    case Paakantyi = 'drl';
    case West_Damar = 'drn';
    case Daro_Matu_Melanau = 'dro';
    case Dura = 'drq';
    case Gedeo = 'drs';
    case Drents = 'drt';
    case Rukai = 'dru';
    case Darai = 'dry';
    case Lower_Sorbian = 'dsb';
    case Dutch_Sign_Language = 'dse';
    case Daasanach = 'dsh';
    case Disa = 'dsi';
    case Dokshi = 'dsk';
    case Danish_Sign_Language = 'dsl';
    case Dusner = 'dsn';
    case Desiya = 'dso';
    case Tadaksahak = 'dsq';
    case Mardin_Sign_Language = 'dsz';
    case Daur = 'dta';
    case Labuk_Kinabatangan_Kadazan = 'dtb';
    case Ditidaht = 'dtd';
    case Adithinngithigh = 'dth';
    case Ana_Tinga_Dogon = 'dti';
    case Tene_Kan_Dogon = 'dtk';
    case Tomo_Kan_Dogon = 'dtm';
    case Daats_iin = 'dtn';
    case Tommo_So_Dogon = 'dto';
    case Kadazan_Dusun = 'dtp';
    case Lotud = 'dtr';
    case Toro_So_Dogon = 'dts';
    case Toro_Tegu_Dogon = 'dtt';
    case Tebul_Ure_Dogon = 'dtu';
    case Dotyali = 'dty';
    case Duala = 'dua';
    case Dubli = 'dub';
    case Duna = 'duc';
    case Umiray_Dumaget_Agta = 'due';
    case Dumbea = 'duf';
    case Duruma = 'dug';
    case Dungra_Bhil = 'duh';
    case Dumun = 'dui';
    case Uyajitaya = 'duk';
    case Alabat_Island_Agta = 'dul';
    case Middle_Dutch_ca_1050_1350 = 'dum';
    case Dusun_Deyah = 'dun';
    case Dupaninan_Agta = 'duo';
    case Duano = 'dup';
    case Dusun_Malang = 'duq';
    case Dii = 'dur';
    case Dumi = 'dus';
    case Drung = 'duu';
    case Duvle = 'duv';
    case Dusun_Witu = 'duw';
    case Duungooma = 'dux';
    case Dicamay_Agta = 'duy';
    case Duli_Gey = 'duz';
    case Duau = 'dva';
    case Diri = 'dwa';
    case Dawik_Kui = 'dwk';
    case Dawro = 'dwr';
    case Dutton_World_Speedwords = 'dws';
    case Dhuwal = 'dwu';
    case Dawawa = 'dww';
    case Dhuwaya = 'dwy';
    case Dewas_Rai = 'dwz';
    case Dyan = 'dya';
    case Dyaberdyaber = 'dyb';
    case Dyugun = 'dyd';
    case Villa_Viciosa_Agta = 'dyg';
    case Djimini_Senoufo = 'dyi';
    case Yanda_Dom_Dogon = 'dym';
    case Dyangadi = 'dyn';
    case Jola_Fonyi = 'dyo';
    case Dyarim = 'dyr';
    case Dyula = 'dyu';
    case Djabugay = 'dyy';
    case Tunzu = 'dza';
    case Daza = 'dzd';
    case Djiwarli = 'dze';
    case Dazaga = 'dzg';
    case Dzalakha = 'dzl';
    case Dzando = 'dzn';
    case Dzongkha = 'dzo';
    case Karenggapa = 'eaa';
    case Beginci = 'ebc';
    case Ebughu = 'ebg';
    case Eastern_Bontok = 'ebk';
    case Teke_Ebo = 'ebo';
    case Ebrie = 'ebr';
    case Embu = 'ebu';
    case Eteocretan = 'ecr';
    case Ecuadorian_Sign_Language = 'ecs';
    case Eteocypriot = 'ecy';
    case E = 'eee';
    case Efai = 'efa';
    case Efe = 'efe';
    case Efik = 'efi';
    case Ega = 'ega';
    case Emilian = 'egl';
    case Benamanga = 'egm';
    case Eggon = 'ego';
    case Egyptian_Ancient = 'egy';
    case Miyakubo_Sign_Language = 'ehs';
    case Ehueun = 'ehu';
    case Eipomek = 'eip';
    case Eitiep = 'eit';
    case Askopan = 'eiv';
    case Ejamat = 'eja';
    case Ekajuk = 'eka';
    case Ekit = 'eke';
    case Ekari = 'ekg';
    case Eki = 'eki';
    case Standard_Estonian = 'ekk';
    case Kol_Bangladesh = 'ekl';
    case Elip = 'ekm';
    case Koti = 'eko';
    case Ekpeye = 'ekp';
    case Yace = 'ekr';
    case Eastern_Kayah = 'eky';
    case Elepi = 'ele';
    case El_Hugeirat = 'elh';
    case Nding = 'eli';
    case Elkei = 'elk';
    case Modern_Greek_1453 = 'ell';
    case Eleme = 'elm';
    case El_Molo = 'elo';
    case Elu = 'elu';
    case Elamite = 'elx';
    case Emai_Iuleha_Ora = 'ema';
    case Embaloh = 'emb';
    case Emerillon = 'eme';
    case Eastern_Meohang = 'emg';
    case Mussau_Emira = 'emi';
    case Eastern_Maninkakan = 'emk';
    case Mamulique = 'emm';
    case Eman = 'emn';
    case Northern_Embera = 'emp';
    case Eastern_Minyag = 'emq';
    case Pacific_Gulf_Yupik = 'ems';
    case Eastern_Muria = 'emu';
    case Emplawas = 'emw';
    case Erromintxela = 'emx';
    case Epigraphic_Mayan = 'emy';
    case Mbessa = 'emz';
    case Apali = 'ena';
    case Markweeta = 'enb';
    case En = 'enc';
    case Ende = 'end';
    case Forest_Enets = 'enf';
    case English = 'eng';
    case Tundra_Enets = 'enh';
    case Enlhet = 'enl';
    case Middle_English_1100_1500 = 'enm';
    case Engenni = 'enn';
    case Enggano = 'eno';
    case Enga = 'enq';
    case Emumu = 'enr';
    case Enu = 'enu';
    case Enwan_Edo_State = 'env';
    case Enwan_Akwa_Ibom_State = 'enw';
    case Enxet = 'enx';
    case Beti_Cote_d_Ivoire = 'eot';
    case Epie = 'epi';
    case Esperanto = 'epo';
    case Eravallan = 'era';
    case Sie = 'erg';
    case Eruwa = 'erh';
    case Ogea = 'eri';
    case South_Efate = 'erk';
    case Horpa = 'ero';
    case Erre = 'err';
    case Ersu = 'ers';
    case Eritai = 'ert';
    case Erokwanas = 'erw';
    case Ese_Ejja = 'ese';
    case Aheri_Gondi = 'esg';
    case Eshtehardi = 'esh';
    case North_Alaskan_Inupiatun = 'esi';
    case Northwest_Alaska_Inupiatun = 'esk';
    case Egypt_Sign_Language = 'esl';
    case Esuma = 'esm';
    case Salvadoran_Sign_Language = 'esn';
    case Estonian_Sign_Language = 'eso';
    case Esselen = 'esq';
    case Central_Siberian_Yupik = 'ess';
    case Estonian = 'est';
    case Central_Yupik = 'esu';
    case Eskayan = 'esy';
    case Etebi = 'etb';
    case Etchemin = 'etc';
    case Ethiopian_Sign_Language = 'eth';
    case Eton_Vanuatu = 'etn';
    case Eton_Cameroon = 'eto';
    case Edolo = 'etr';
    case Yekhee = 'ets';
    case Etruscan = 'ett';
    case Ejagham = 'etu';
    case Eten = 'etx';
    case Semimi = 'etz';
    case Eudeve = 'eud';
    case Basque = 'eus';
    case Even = 'eve';
    case Uvbie = 'evh';
    case Evenki = 'evn';
    case Ewe = 'ewe';
    case Ewondo = 'ewo';
    case Extremaduran = 'ext';
    case Eyak = 'eya';
    case Keiyo = 'eyo';
    case Ezaa = 'eza';
    case Uzekwe = 'eze';
    case Fasu = 'faa';
    case Fa_d_Ambu = 'fab';
    case Wagi = 'fad';
    case Fagani = 'faf';
    case Finongan = 'fag';
    case Baissa_Fali = 'fah';
    case Faiwol = 'fai';
    case Faita = 'faj';
    case Fang_Cameroon = 'fak';
    case South_Fali = 'fal';
    case Fam = 'fam';
    case Fang_Equatorial_Guinea = 'fan';
    case Faroese = 'fao';
    case Paloor = 'fap';
    case Fataleka = 'far';
    case Persian = 'fas';
    case Fanti = 'fat';
    case Fayu = 'fau';
    case Fala = 'fax';
    case Southwestern_Fars = 'fay';
    case Northwestern_Fars = 'faz';
    case West_Albay_Bikol = 'fbl';
    case Quebec_Sign_Language = 'fcs';
    case Feroge = 'fer';
    case Foia_Foia = 'ffi';
    case Maasina_Fulfulde = 'ffm';
    case Fongoro = 'fgr';
    case Nobiin = 'fia';
    case Fyer = 'fie';
    case Faifi = 'fif';
    case Fijian = 'fij';
    case Filipino = 'fil';
    case Finnish = 'fin';
    case Fipa = 'fip';
    case Firan = 'fir';
    case Tornedalen_Finnish = 'fit';
    case Fiwaga = 'fiw';
    case Kirya_Konzel = 'fkk';
    case Kven_Finnish = 'fkv';
    case Kalispel_Pend_d_Oreille = 'fla';
    case Foau = 'flh';
    case Fali = 'fli';
    case North_Fali = 'fll';
    case Flinders_Island = 'fln';
    case Fuliiru = 'flr';
    case Flaaitaal = 'fly';
    case Fe_fe = 'fmp';
    case Far_Western_Muria = 'fmu';
    case Fanbak = 'fnb';
    case Fanagalo = 'fng';
    case Fania = 'fni';
    case Foodo = 'fod';
    case Foi = 'foi';
    case Foma = 'fom';
    case Fon = 'fon';
    case Fore = 'for';
    case Siraya = 'fos';
    case Fernando_Po_Creole_English = 'fpe';
    case Fas = 'fqs';
    case French = 'fra';
    case Cajun_French = 'frc';
    case Fordata = 'frd';
    case Frankish = 'frk';
    case Middle_French_ca_1400_1600 = 'frm';
    case Old_French_842_ca_1400 = 'fro';
    case Arpitan = 'frp';
    case Forak = 'frq';
    case Northern_Frisian = 'frr';
    case Eastern_Frisian = 'frs';
    case Fortsenal = 'frt';
    case Western_Frisian = 'fry';
    case Finnish_Sign_Language = 'fse';
    case French_Sign_Language = 'fsl';
    case Finland_Swedish_Sign_Language = 'fss';
    case Adamawa_Fulfulde = 'fub';
    case Pulaar = 'fuc';
    case East_Futuna = 'fud';
    case Borgu_Fulfulde = 'fue';
    case Pular = 'fuf';
    case Western_Niger_Fulfulde = 'fuh';
    case Bagirmi_Fulfulde = 'fui';
    case Ko = 'fuj';
    case Fulah = 'ful';
    case Fum = 'fum';
    case Fulnio = 'fun';
    case Central_Eastern_Niger_Fulfulde = 'fuq';
    case Friulian = 'fur';
    case Futuna_Aniwa = 'fut';
    case Furu = 'fuu';
    case Nigerian_Fulfulde = 'fuv';
    case Fuyug = 'fuy';
    case Fur = 'fvr';
    case Fwai = 'fwa';
    case Fwe = 'fwe';
    case Ga = 'gaa';
    case Gabri = 'gab';
    case Mixed_Great_Andamanese = 'gac';
    case Gaddang = 'gad';
    case Guarequena = 'gae';
    case Gende = 'gaf';
    case Gagauz = 'gag';
    case Alekano = 'gah';
    case Borei = 'gai';
    case Gadsup = 'gaj';
    case Gamkonora = 'gak';
    case Galolen = 'gal';
    case Kandawo = 'gam';
    case Gan_Chinese = 'gan';
    case Gants = 'gao';
    case Gal = 'gap';
    case Gata = 'gaq';
    case Galeya = 'gar';
    case Adiwasi_Garasia = 'gas';
    case Kenati = 'gat';
    case Mudhili_Gadaba = 'gau';
    case Nobonob = 'gaw';
    case Borana_Arsi_Guji_Oromo = 'gax';
    case Gayo = 'gay';
    case West_Central_Oromo = 'gaz';
    case Gbaya_Central_African_Republic = 'gba';
    case Kaytetye = 'gbb';
    case Karajarri = 'gbd';
    case Niksek = 'gbe';
    case Gaikundi = 'gbf';
    case Gbanziri = 'gbg';
    case Defi_Gbe = 'gbh';
    case Galela = 'gbi';
    case Bodo_Gadaba = 'gbj';
    case Gaddi = 'gbk';
    case Gamit = 'gbl';
    case Garhwali = 'gbm';
    case Mo_da = 'gbn';
    case Northern_Grebo = 'gbo';
    case Gbaya_Bossangoa = 'gbp';
    case Gbaya_Bozoum = 'gbq';
    case Gbagyi = 'gbr';
    case Gbesi_Gbe = 'gbs';
    case Gagadu = 'gbu';
    case Gbanu = 'gbv';
    case Gabi_Gabi = 'gbw';
    case Eastern_Xwla_Gbe = 'gbx';
    case Gbari = 'gby';
    case Zoroastrian_Dari = 'gbz';
    case Mali = 'gcc';
    case Ganggalida = 'gcd';
    case Galice = 'gce';
    case Guadeloupean_Creole_French = 'gcf';
    case Grenadian_Creole_English = 'gcl';
    case Gaina = 'gcn';
    case Guianese_Creole_French = 'gcr';
    case Colonia_Tovar_German = 'gct';
    case Gade_Lohar = 'gda';
    case Pottangi_Ollar_Gadaba = 'gdb';
    case Gugu_Badhun = 'gdc';
    case Gedaged = 'gdd';
    case Gude = 'gde';
    case Guduf_Gava = 'gdf';
    case Ga_dang = 'gdg';
    case Gadjerawang = 'gdh';
    case Gundi = 'gdi';
    case Gurdjar = 'gdj';
    case Gadang = 'gdk';
    case Dirasha = 'gdl';
    case Laal = 'gdm';
    case Umanakaina = 'gdn';
    case Ghodoberi = 'gdo';
    case Mehri = 'gdq';
    case Wipi = 'gdr';
    case Ghandruk_Sign_Language = 'gds';
    case Kungardutyi = 'gdt';
    case Gudu = 'gdu';
    case Godwari = 'gdx';
    case Geruma = 'gea';
    case Kire = 'geb';
    case Gboloo_Grebo = 'gec';
    case Gade = 'ged';
    case Gerai = 'gef';
    case Gengle = 'geg';
    case Hutterite_German = 'geh';
    case Gebe = 'gei';
    case Gen = 'gej';
    case Ywom = 'gek';
    case ut_Ma_in = 'gel';
    case Geme = 'geq';
    case Geser_Gorom = 'ges';
    case Eviya = 'gev';
    case Gera = 'gew';
    case Garre = 'gex';
    case Enya = 'gey';
    case Geez = 'gez';
    case Patpatar = 'gfk';
    case Gafat = 'gft';
    case Gao = 'gga';
    case Gbii = 'ggb';
    case Gugadj = 'ggd';
    case Gurr_goni = 'gge';
    case Gurgula = 'ggg';
    case Kungarakany = 'ggk';
    case Ganglau = 'ggl';
    case Gitua = 'ggt';
    case Gagu = 'ggu';
    case Gogodala = 'ggw';
    case Ghadames = 'gha';
    case Hiberno_Scottish_Gaelic = 'ghc';
    case Southern_Ghale = 'ghe';
    case Northern_Ghale = 'ghh';
    case Geko_Karen = 'ghk';
    case Ghulfan = 'ghl';
    case Ghanongga = 'ghn';
    case Ghomara = 'gho';
    case Ghera = 'ghr';
    case Guhu_Samane = 'ghs';
    case Kuke = 'ght';
    case Kija = 'gia';
    case Gibanawa = 'gib';
    case Gail = 'gic';
    case Gidar = 'gid';
    case Gabogbo = 'gie';
    case Goaria = 'gig';
    case Githabul = 'gih';
    case Girirra = 'gii';
    case Gilbertese = 'gil';
    case Gimi_Eastern_Highlands = 'gim';
    case Hinukh = 'gin';
    case Gimi_West_New_Britain = 'gip';
    case Green_Gelao = 'giq';
    case Red_Gelao = 'gir';
    case North_Giziga = 'gis';
    case Gitxsan = 'git';
    case Mulao = 'giu';
    case White_Gelao = 'giw';
    case Gilima = 'gix';
    case Giyug = 'giy';
    case South_Giziga = 'giz';
    case Kachi_Koli = 'gjk';
    case Gunditjmara = 'gjm';
    case Gonja = 'gjn';
    case Gurindji_Kriol = 'gjr';
    case Gujari = 'gju';
    case Guya = 'gka';
    case Magi_Madang_Province = 'gkd';
    case Ndai = 'gke';
    case Gokana = 'gkn';
    case Kok_Nar = 'gko';
    case Guinea_Kpelle = 'gkp';
    case Ungkue = 'gku';
    case Scottish_Gaelic = 'gla';
    case Belning = 'glb';
    case Bon_Gula = 'glc';
    case Nanai = 'gld';
    case Irish = 'gle';
    case Galician = 'glg';
    case Northwest_Pashai = 'glh';
    case Gula_Iro = 'glj';
    case Gilaki = 'glk';
    case Garlali = 'gll';
    case Galambu = 'glo';
    case Glaro_Twabo = 'glr';
    case Gula_Chad = 'glu';
    case Manx = 'glv';
    case Glavda = 'glw';
    case Gule = 'gly';
    case Gambera = 'gma';
    case Gula_alaa = 'gmb';
    case Maghdi = 'gmd';
    case Magiyi = 'gmg';
    case Middle_High_German_ca_1050_1500 = 'gmh';
    case Middle_Low_German = 'gml';
    case Gbaya_Mbodomo = 'gmm';
    case Gimnime = 'gmn';
    case Mirning = 'gmr';
    case Gumalu = 'gmu';
    case Gamo = 'gmv';
    case Magoma = 'gmx';
    case Mycenaean_Greek = 'gmy';
    case Mgbolizhia = 'gmz';
    case Kaansa = 'gna';
    case Gangte = 'gnb';
    case Guanche = 'gnc';
    case Zulgo_Gemzek = 'gnd';
    case Ganang = 'gne';
    case Ngangam = 'gng';
    case Lere = 'gnh';
    case Gooniyandi = 'gni';
    case Ngen = 'gnj';
    case Gana = 'gnk';
    case Gangulu = 'gnl';
    case Ginuman = 'gnm';
    case Gumatj = 'gnn';
    case Northern_Gondi = 'gno';
    case Gana_2 = 'gnq';
    case Gureng_Gureng = 'gnr';
    case Guntai = 'gnt';
    case Gnau = 'gnu';
    case Western_Bolivian_Guarani = 'gnw';
    case Ganzi = 'gnz';
    case Guro = 'goa';
    case Playero = 'gob';
    case Gorakor = 'goc';
    case Godie = 'god';
    case Gongduk = 'goe';
    case Gofa = 'gof';
    case Gogo = 'gog';
    case Old_High_German_ca_750_1050 = 'goh';
    case Gobasi = 'goi';
    case Gowlan = 'goj';
    case Gowli = 'gok';
    case Gola = 'gol';
    case Goan_Konkani = 'gom';
    case Gondi = 'gon';
    case Gone_Dau = 'goo';
    case Yeretuar = 'gop';
    case Gorap = 'goq';
    case Gorontalo = 'gor';
    case Gronings = 'gos';
    case Gothic = 'got';
    case Gavar = 'gou';
    case Goo = 'gov';
    case Gorowa = 'gow';
    case Gobu = 'gox';
    case Goundo = 'goy';
    case Gozarkhani = 'goz';
    case Gupa_Abawa = 'gpa';
    case Ghanaian_Pidgin_English = 'gpe';
    case Taiap = 'gpn';
    case Ga_anda = 'gqa';
    case Guiqiong = 'gqi';
    case Guana_Brazil = 'gqn';
    case Gor = 'gqr';
    case Qau = 'gqu';
    case Rajput_Garasia = 'gra';
    case Grebo = 'grb';
    case Ancient_Greek_to_1453 = 'grc';
    case Guruntum_Mbaaru = 'grd';
    case Madi = 'grg';
    case Gbiri_Niragu = 'grh';
    case Ghari = 'gri';
    case Southern_Grebo = 'grj';
    case Kota_Marudu_Talantang = 'grm';
    case Guarani = 'grn';
    case Groma = 'gro';
    case Gorovu = 'grq';
    case Taznatit = 'grr';
    case Gresi = 'grs';
    case Garo = 'grt';
    case Kistane = 'gru';
    case Central_Grebo = 'grv';
    case Gweda = 'grw';
    case Guriaso = 'grx';
    case Barclayville_Grebo = 'gry';
    case Guramalum = 'grz';
    case Ghanaian_Sign_Language = 'gse';
    case German_Sign_Language = 'gsg';
    case Gusilay = 'gsl';
    case Guatemalan_Sign_Language = 'gsm';
    case Nema = 'gsn';
    case Southwest_Gbaya = 'gso';
    case Wasembo = 'gsp';
    case Greek_Sign_Language = 'gss';
    case Swiss_German = 'gsw';
    case Guato = 'gta';
    case Aghu_Tharnggala = 'gtu';
    case Shiki = 'gua';
    case Guajajara = 'gub';
    case Wayuu = 'guc';
    case Yocoboue_Dida = 'gud';
    case Gurindji = 'gue';
    case Gupapuyngu = 'guf';
    case Paraguayan_Guarani = 'gug';
    case Guahibo = 'guh';
    case Eastern_Bolivian_Guarani = 'gui';
    case Gujarati = 'guj';
    case Gumuz = 'guk';
    case Sea_Island_Creole_English = 'gul';
    case Guambiano = 'gum';
    case Mbya_Guarani = 'gun';
    case Guayabero = 'guo';
    case Gunwinggu = 'gup';
    case Ache = 'guq';
    case Farefare = 'gur';
    case Guinean_Sign_Language = 'gus';
    case Maleku_Jaika = 'gut';
    case Yanomamo = 'guu';
    case Gun = 'guw';
    case Gourmanchema = 'gux';
    case Gusii = 'guz';
    case Guana_Paraguay = 'gva';
    case Guanano = 'gvc';
    case Duwet = 'gve';
    case Golin = 'gvf';
    case Guaja = 'gvj';
    case Gulay = 'gvl';
    case Gurmana = 'gvm';
    case Kuku_Yalanji = 'gvn';
    case Gaviao_Do_Jiparana = 'gvo';
    case Para_Gaviao = 'gvp';
    case Gurung = 'gvr';
    case Gumawana = 'gvs';
    case Guyani = 'gvy';
    case Mbato = 'gwa';
    case Gwa = 'gwb';
    case Gawri = 'gwc';
    case Gawwada = 'gwd';
    case Gweno = 'gwe';
    case Gowro = 'gwf';
    case Moo = 'gwg';
    case Gwich_in = 'gwi';
    case Gwi = 'gwj';
    case Awngthim = 'gwm';
    case Gwandara = 'gwn';
    case Gwere = 'gwr';
    case Gawar_Bati = 'gwt';
    case Guwamu = 'gwu';
    case Kwini = 'gww';
    case Gua = 'gwx';
    case We_Southern = 'gxx';
    case Northwest_Gbaya = 'gya';
    case Garus = 'gyb';
    case Kayardild = 'gyd';
    case Gyem = 'gye';
    case Gungabula = 'gyf';
    case Gbayi = 'gyg';
    case Gyele = 'gyi';
    case Gayil = 'gyl';
    case Ngabere = 'gym';
    case Guyanese_Creole_English = 'gyn';
    case Gyalsumdo = 'gyo';
    case Guarayu = 'gyr';
    case Gunya = 'gyy';
    case Geji = 'gyz';
    case Ganza = 'gza';
    case Gazi = 'gzi';
    case Gane = 'gzn';
    case Han = 'haa';
    case Hanoi_Sign_Language = 'hab';
    case Gurani = 'hac';
    case Hatam = 'had';
    case Eastern_Oromo = 'hae';
    case Haiphong_Sign_Language = 'haf';
    case Hanga = 'hag';
    case Hahon = 'hah';
    case Haida = 'hai';
    case Hajong = 'haj';
    case Hakka_Chinese = 'hak';
    case Halang = 'hal';
    case Hewa = 'ham';
    case Hangaza = 'han';
    case Hako = 'hao';
    case Hupla = 'hap';
    case Ha = 'haq';
    case Harari = 'har';
    case Haisla = 'has';
    case Haitian = 'hat';
    case Hausa = 'hau';
    case Havu = 'hav';
    case Hawaiian = 'haw';
    case Southern_Haida = 'hax';
    case Haya = 'hay';
    case Hazaragi = 'haz';
    case Hamba = 'hba';
    case Huba = 'hbb';
    case Heiban = 'hbn';
    case Ancient_Hebrew = 'hbo';
    case Serbo_Croatian = 'hbs';
    case Habu = 'hbu';
    case Andaman_Creole_Hindi = 'hca';
    case Huichol = 'hch';
    case Northern_Haida = 'hdn';
    case Honduras_Sign_Language = 'hds';
    case Hadiyya = 'hdy';
    case Northern_Qiandong_Miao = 'hea';
    case Hebrew = 'heb';
    case Herde = 'hed';
    case Helong = 'heg';
    case Hehe = 'heh';
    case Heiltsuk = 'hei';
    case Hemba = 'hem';
    case Herero = 'her';
    case Hai_om = 'hgm';
    case Haigwai = 'hgw';
    case Hoia_Hoia = 'hhi';
    case Kerak = 'hhr';
    case Hoyahoya = 'hhy';
    case Lamang = 'hia';
    case Hibito = 'hib';
    case Hidatsa = 'hid';
    case Fiji_Hindi = 'hif';
    case Kamwe = 'hig';
    case Pamosu = 'hih';
    case Hinduri = 'hii';
    case Hijuk = 'hij';
    case Seit_Kaitetu = 'hik';
    case Hiligaynon = 'hil';
    case Hindi = 'hin';
    case Tsoa = 'hio';
    case Himarima = 'hir';
    case Hittite = 'hit';
    case Hiw = 'hiw';
    case Hixkaryana = 'hix';
    case Haji = 'hji';
    case Kahe = 'hka';
    case Hunde = 'hke';
    case Khah = 'hkh';
    case Hunjara_Kaina_Ke = 'hkk';
    case Mel_Khaonh = 'hkn';
    case Hong_Kong_Sign_Language = 'hks';
    case Halia = 'hla';
    case Halbi = 'hlb';
    case Halang_Doan = 'hld';
    case Hlersu = 'hle';
    case Matu_Chin = 'hlt';
    case Hieroglyphic_Luwian = 'hlu';
    case Southern_Mashan_Hmong = 'hma';
    case Humburi_Senni_Songhay = 'hmb';
    case Central_Huishui_Hmong = 'hmc';
    case Large_Flowery_Miao = 'hmd';
    case Eastern_Huishui_Hmong = 'hme';
    case Hmong_Don = 'hmf';
    case Southwestern_Guiyang_Hmong = 'hmg';
    case Southwestern_Huishui_Hmong = 'hmh';
    case Northern_Huishui_Hmong = 'hmi';
    case Ge = 'hmj';
    case Maek = 'hmk';
    case Luopohe_Hmong = 'hml';
    case Central_Mashan_Hmong = 'hmm';
    case Hmong = 'hmn';
    case Hiri_Motu = 'hmo';
    case Northern_Mashan_Hmong = 'hmp';
    case Eastern_Qiandong_Miao = 'hmq';
    case Hmar = 'hmr';
    case Southern_Qiandong_Miao = 'hms';
    case Hamtai = 'hmt';
    case Hamap = 'hmu';
    case Hmong_Do = 'hmv';
    case Western_Mashan_Hmong = 'hmw';
    case Southern_Guiyang_Hmong = 'hmy';
    case Hmong_Shua = 'hmz';
    case Mina_Cameroon = 'hna';
    case Southern_Hindko = 'hnd';
    case Chhattisgarhi = 'hne';
    case Hungu = 'hng';
    case Ani = 'hnh';
    case Hani = 'hni';
    case Hmong_Njua = 'hnj';
    case Hainanese = 'hnm';
    case Hanunoo = 'hnn';
    case Northern_Hindko = 'hno';
    case Caribbean_Hindustani = 'hns';
    case Hung = 'hnu';
    case Hoava = 'hoa';
    case Mari_Madang_Province = 'hob';
    case Ho = 'hoc';
    case Holma = 'hod';
    case Horom = 'hoe';
    case Hobyot = 'hoh';
    case Holikachuk = 'hoi';
    case Hadothi = 'hoj';
    case Holu = 'hol';
    case Homa = 'hom';
    case Holoholo = 'hoo';
    case Hopi = 'hop';
    case Horo = 'hor';
    case Ho_Chi_Minh_City_Sign_Language = 'hos';
    case Hote = 'hot';
    case Hovongan = 'hov';
    case Honi = 'how';
    case Holiya = 'hoy';
    case Hozo = 'hoz';
    case Hpon = 'hpo';
    case Hawai_i_Sign_Language_HSL = 'hps';
    case Hrangkhol = 'hra';
    case Niwer_Mil = 'hrc';
    case Hre = 'hre';
    case Haruku = 'hrk';
    case Horned_Miao = 'hrm';
    case Haroi = 'hro';
    case Nhirrpi = 'hrp';
    case Hertevin = 'hrt';
    case Hruso = 'hru';
    case Croatian = 'hrv';
    case Warwar_Feni = 'hrw';
    case Hunsrik = 'hrx';
    case Harzani = 'hrz';
    case Upper_Sorbian = 'hsb';
    case Hungarian_Sign_Language = 'hsh';
    case Hausa_Sign_Language = 'hsl';
    case Xiang_Chinese = 'hsn';
    case Harsusi = 'hss';
    case Hoti = 'hti';
    case Minica_Huitoto = 'hto';
    case Hadza = 'hts';
    case Hitu = 'htu';
    case Middle_Hittite = 'htx';
    case Huambisa = 'hub';
    case Hua = 'huc';
    case Huaulu = 'hud';
    case San_Francisco_Del_Mar_Huave = 'hue';
    case Humene = 'huf';
    case Huachipaeri = 'hug';
    case Huilliche = 'huh';
    case Huli = 'hui';
    case Northern_Guiyang_Hmong = 'huj';
    case Hulung = 'huk';
    case Hula = 'hul';
    case Hungana = 'hum';
    case Hungarian = 'hun';
    case Hu = 'huo';
    case Hupa = 'hup';
    case Tsat = 'huq';
    case Halkomelem = 'hur';
    case Huastec = 'hus';
    case Humla = 'hut';
    case Murui_Huitoto = 'huu';
    case San_Mateo_Del_Mar_Huave = 'huv';
    case Hukumina = 'huw';
    case Nupode_Huitoto = 'hux';
    case Hulaula = 'huy';
    case Hunzib = 'huz';
    case Haitian_Vodoun_Culture_Language = 'hvc';
    case San_Dionisio_Del_Mar_Huave = 'hve';
    case Haveke = 'hvk';
    case Sabu = 'hvn';
    case Santa_Maria_Del_Mar_Huave = 'hvv';
    case Wane = 'hwa';
    case Hawai_i_Creole_English = 'hwc';
    case Hwana = 'hwo';
    case Hya = 'hya';
    case Armenian = 'hye';
    case Western_Armenian = 'hyw';
    case Iaai = 'iai';
    case Iatmul = 'ian';
    case Purari = 'iar';
    case Iban = 'iba';
    case Ibibio = 'ibb';
    case Iwaidja = 'ibd';
    case Akpes = 'ibe';
    case Ibanag = 'ibg';
    case Bih = 'ibh';
    case Ibaloi = 'ibl';
    case Agoi = 'ibm';
    case Ibino = 'ibn';
    case Igbo = 'ibo';
    case Ibuoro = 'ibr';
    case Ibu = 'ibu';
    case Ibani = 'iby';
    case Ede_Ica = 'ica';
    case Etkywan = 'ich';
    case Icelandic_Sign_Language = 'icl';
    case Islander_Creole_English = 'icr';
    case Idakho_Isukha_Tiriki = 'ida';
    case Indo_Portuguese = 'idb';
    case Idon = 'idc';
    case Ede_Idaca = 'idd';
    case Idere = 'ide';
    case Idi = 'idi';
    case Ido = 'ido';
    case Indri = 'idr';
    case Idesa = 'ids';
    case Idate = 'idt';
    case Idoma = 'idu';
    case Amganad_Ifugao = 'ifa';
    case Batad_Ifugao = 'ifb';
    case Ife = 'ife';
    case Ifo = 'iff';
    case Tuwali_Ifugao = 'ifk';
    case Teke_Fuumu = 'ifm';
    case Mayoyao_Ifugao = 'ifu';
    case Keley_I_Kallahan = 'ify';
    case Ebira = 'igb';
    case Igede = 'ige';
    case Igana = 'igg';
    case Igala = 'igl';
    case Kanggape = 'igm';
    case Ignaciano = 'ign';
    case Isebe = 'igo';
    case Interglossa = 'igs';
    case Igwe = 'igw';
    case Iha_Based_Pidgin = 'ihb';
    case Ihievbe = 'ihi';
    case Iha = 'ihp';
    case Bidhawal = 'ihw';
    case Sichuan_Yi = 'iii';
    case Thiin = 'iin';
    case Izon = 'ijc';
    case Biseni = 'ije';
    case Ede_Ije = 'ijj';
    case Kalabari = 'ijn';
    case Southeast_Ijo = 'ijs';
    case Eastern_Canadian_Inuktitut = 'ike';
    case Ikhin_Arokho = 'ikh';
    case Iko = 'iki';
    case Ika = 'ikk';
    case Ikulu = 'ikl';
    case Olulumo_Ikom = 'iko';
    case Ikpeshi = 'ikp';
    case Ikaranggal = 'ikr';
    case Inuit_Sign_Language = 'iks';
    case Inuinnaqtun = 'ikt';
    case Inuktitut = 'iku';
    case Iku_Gora_Ankwa = 'ikv';
    case Ikwere = 'ikw';
    case Ik = 'ikx';
    case Ikizu = 'ikz';
    case Ile_Ape = 'ila';
    case Ila = 'ilb';
    case Interlingue = 'ile';
    case Garig_Ilgar = 'ilg';
    case Ili_Turki = 'ili';
    case Ilongot = 'ilk';
    case Iranun_Malaysia = 'ilm';
    case Iloko = 'ilo';
    case Iranun_Philippines = 'ilp';
    case International_Sign = 'ils';
    case Ili_uun = 'ilu';
    case Ilue = 'ilv';
    case Mala_Malasar = 'ima';
    case Anamgura = 'imi';
    case Miluk = 'iml';
    case Imonda = 'imn';
    case Imbongu = 'imo';
    case Imroing = 'imr';
    case Marsian = 'ims';
    case Imotong = 'imt';
    case Milyan = 'imy';
    case Interlingua_International_Auxiliary_Language_Association = 'ina';
    case Inga = 'inb';
    case Indonesian = 'ind';
    case Degexit_an = 'ing';
    case Ingush = 'inh';
    case Jungle_Inga = 'inj';
    case Indonesian_Sign_Language = 'inl';
    case Minaean = 'inm';
    case Isinai = 'inn';
    case Inoke_Yate = 'ino';
    case Inapari = 'inp';
    case Indian_Sign_Language = 'ins';
    case Intha = 'int';
    case Ineseno = 'inz';
    case Inor = 'ior';
    case Tuma_Irumu = 'iou';
    case Iowa_Oto = 'iow';
    case Ipili = 'ipi';
    case Inupiaq = 'ipk';
    case Ipiko = 'ipo';
    case Iquito = 'iqu';
    case Ikwo = 'iqw';
    case Iresim = 'ire';
    case Irarutu = 'irh';
    case Rigwe = 'iri';
    case Iraqw = 'irk';
    case Irantxe = 'irn';
    case Ir = 'irr';
    case Irula = 'iru';
    case Kamberau = 'irx';
    case Iraya = 'iry';
    case Isabi = 'isa';
    case Isconahua = 'isc';
    case Isnag = 'isd';
    case Italian_Sign_Language = 'ise';
    case Irish_Sign_Language = 'isg';
    case Esan = 'ish';
    case Nkem_Nkum = 'isi';
    case Ishkashimi = 'isk';
    case Icelandic = 'isl';
    case Masimasi = 'ism';
    case Isanzu = 'isn';
    case Isoko = 'iso';
    case Israeli_Sign_Language = 'isr';
    case Istriot = 'ist';
    case Isu_Menchum_Division = 'isu';
    case Interslavic = 'isv';
    case Italian = 'ita';
    case Binongan_Itneg = 'itb';
    case Southern_Tidung = 'itd';
    case Itene = 'ite';
    case Inlaod_Itneg = 'iti';
    case Judeo_Italian = 'itk';
    case Itelmen = 'itl';
    case Itu_Mbon_Uzo = 'itm';
    case Itonama = 'ito';
    case Iteri = 'itr';
    case Isekiri = 'its';
    case Maeng_Itneg = 'itt';
    case Itawit = 'itv';
    case Ito = 'itw';
    case Itik = 'itx';
    case Moyadan_Itneg = 'ity';
    case Itza = 'itz';
    case Iu_Mien = 'ium';
    case Ibatan = 'ivb';
    case Ivatan = 'ivv';
    case I_Wak = 'iwk';
    case Iwam = 'iwm';
    case Iwur = 'iwo';
    case Sepik_Iwam = 'iws';
    case Ixcatec = 'ixc';
    case Ixil = 'ixl';
    case Iyayu = 'iya';
    case Mesaka = 'iyo';
    case Yaka_Congo = 'iyx';
    case Ingrian = 'izh';
    case Kizamani = 'izm';
    case Izere = 'izr';
    case Izii = 'izz';
    case Jamamadi = 'jaa';
    case Hyam = 'jab';
    case Popti = 'jac';
    case Jahanka = 'jad';
    case Yabem = 'jae';
    case Jara = 'jaf';
    case Jah_Hut = 'jah';
    case Zazao = 'jaj';
    case Jakun = 'jak';
    case Yalahatan = 'jal';
    case Jamaican_Creole_English = 'jam';
    case Jandai = 'jan';
    case Yanyuwa = 'jao';
    case Yaqay = 'jaq';
    case New_Caledonian_Javanese = 'jas';
    case Jakati = 'jat';
    case Yaur = 'jau';
    case Javanese = 'jav';
    case Jambi_Malay = 'jax';
    case Yan_nhangu = 'jay';
    case Jawe = 'jaz';
    case Judeo_Berber = 'jbe';
    case Badjiri = 'jbi';
    case Arandai = 'jbj';
    case Barikewa = 'jbk';
    case Bijim = 'jbm';
    case Nafusi = 'jbn';
    case Lojban = 'jbo';
    case Jofotek_Bromnya = 'jbr';
    case Jabuti = 'jbt';
    case Jukun_Takum = 'jbu';
    case Yawijibaya = 'jbw';
    case Jamaican_Country_Sign_Language = 'jcs';
    case Krymchak = 'jct';
    case Jad = 'jda';
    case Jadgali = 'jdg';
    case Judeo_Tat = 'jdt';
    case Jebero = 'jeb';
    case Jerung = 'jee';
    case Jeh = 'jeh';
    case Yei = 'jei';
    case Jeri_Kuo = 'jek';
    case Yelmek = 'jel';
    case Dza = 'jen';
    case Jere = 'jer';
    case Manem = 'jet';
    case Jonkor_Bourmataguil = 'jeu';
    case Ngbee = 'jgb';
    case Judeo_Georgian = 'jge';
    case Gwak = 'jgk';
    case Ngomba = 'jgo';
    case Jehai = 'jhi';
    case Jhankot_Sign_Language = 'jhs';
    case Jina = 'jia';
    case Jibu = 'jib';
    case Tol = 'jic';
    case Bu_Kaduna_State = 'jid';
    case Jilbe = 'jie';
    case Jingulu = 'jig';
    case sTodsde = 'jih';
    case Jiiddu = 'jii';
    case Jilim = 'jil';
    case Jimi_Cameroon = 'jim';
    case Jiamao = 'jio';
    case Guanyinqiao = 'jiq';
    case Jita = 'jit';
    case Youle_Jinuo = 'jiu';
    case Shuar = 'jiv';
    case Buyuan_Jinuo = 'jiy';
    case Jejueo = 'jje';
    case Bankal = 'jjr';
    case Kaera = 'jka';
    case Mobwa_Karen = 'jkm';
    case Kubo = 'jko';
    case Paku_Karen = 'jkp';
    case Koro_India = 'jkr';
    case Amami_Koniya_Sign_Language = 'jks';
    case Labir = 'jku';
    case Ngile = 'jle';
    case Jamaican_Sign_Language = 'jls';
    case Dima = 'jma';
    case Zumbun = 'jmb';
    case Machame = 'jmc';
    case Yamdena = 'jmd';
    case Jimi_Nigeria = 'jmi';
    case Jumli = 'jml';
    case Makuri_Naga = 'jmn';
    case Kamara = 'jmr';
    case Mashi_Nigeria = 'jms';
    case Mouwase = 'jmw';
    case Western_Juxtlahuaca_Mixtec = 'jmx';
    case Jangshung = 'jna';
    case Jandavra = 'jnd';
    case Yangman = 'jng';
    case Janji = 'jni';
    case Yemsa = 'jnj';
    case Rawat = 'jnl';
    case Jaunsari = 'jns';
    case Joba = 'job';
    case Wojenaka = 'jod';
    case Jogi = 'jog';
    case Jora = 'jor';
    case Jordanian_Sign_Language = 'jos';
    case Jowulu = 'jow';
    case Jewish_Palestinian_Aramaic = 'jpa';
    case Japanese = 'jpn';
    case Judeo_Persian = 'jpr';
    case Jaqaru = 'jqr';
    case Jarai = 'jra';
    case Judeo_Arabic = 'jrb';
    case Jiru = 'jrr';
    case Jakattoe = 'jrt';
    case Japreria = 'jru';
    case Japanese_Sign_Language = 'jsl';
    case Juma = 'jua';
    case Wannu = 'jub';
    case Jurchen = 'juc';
    case Worodougou = 'jud';
    case Hone = 'juh';
    case Ngadjuri = 'jui';
    case Wapan = 'juk';
    case Jirel = 'jul';
    case Jumjum = 'jum';
    case Juang = 'jun';
    case Jiba = 'juo';
    case Hupde = 'jup';
    case Juruna = 'jur';
    case Jumla_Sign_Language = 'jus';
    case Jutish = 'jut';
    case Ju = 'juu';
    case Wapha = 'juw';
    case Juray = 'juy';
    case Javindo = 'jvd';
    case Caribbean_Javanese = 'jvn';
    case Jwira_Pepesa = 'jwi';
    case Jiarong = 'jya';
    case Judeo_Yemeni_Arabic = 'jye';
    case Jaya = 'jyy';
    case Kara_Kalpak = 'kaa';
    case Kabyle = 'kab';
    case Kachin = 'kac';
    case Adara = 'kad';
    case Ketangalan = 'kae';
    case Katso = 'kaf';
    case Kajaman = 'kag';
    case Kara_Central_African_Republic = 'kah';
    case Karekare = 'kai';
    case Jju = 'kaj';
    case Kalanguya = 'kak';
    case Kalaallisut = 'kal';
    case Kamba_Kenya = 'kam';
    case Kannada = 'kan';
    case Xaasongaxango = 'kao';
    case Bezhta = 'kap';
    case Capanahua = 'kaq';
    case Kashmiri = 'kas';
    case Georgian = 'kat';
    case Kanuri = 'kau';
    case Katukina = 'kav';
    case Kawi = 'kaw';
    case Kao = 'kax';
    case Kamayura = 'kay';
    case Kazakh = 'kaz';
    case Kalarko = 'kba';
    case Kaxuiana = 'kbb';
    case Kadiweu = 'kbc';
    case Kabardian = 'kbd';
    case Kanju = 'kbe';
    case Khamba = 'kbg';
    case Camsa = 'kbh';
    case Kaptiau = 'kbi';
    case Kari = 'kbj';
    case Grass_Koiari = 'kbk';
    case Kanembu = 'kbl';
    case Iwal = 'kbm';
    case Kare_Central_African_Republic = 'kbn';
    case Keliko = 'kbo';
    case Kabiye = 'kbp';
    case Kamano = 'kbq';
    case Kafa = 'kbr';
    case Kande = 'kbs';
    case Abadi = 'kbt';
    case Kabutra = 'kbu';
    case Dera_Indonesia = 'kbv';
    case Kaiep = 'kbw';
    case Ap_Ma = 'kbx';
    case Manga_Kanuri = 'kby';
    case Duhwa = 'kbz';
    case Khanty = 'kca';
    case Kawacha = 'kcb';
    case Lubila = 'kcc';
    case Ngkalmpw_Kanum = 'kcd';
    case Kaivi = 'kce';
    case Ukaan = 'kcf';
    case Tyap = 'kcg';
    case Vono = 'kch';
    case Kamantan = 'kci';
    case Kobiana = 'kcj';
    case Kalanga = 'kck';
    case Kela_Papua_New_Guinea = 'kcl';
    case Gula_Central_African_Republic = 'kcm';
    case Nubi = 'kcn';
    case Kinalakna = 'kco';
    case Kanga = 'kcp';
    case Kamo = 'kcq';
    case Katla = 'kcr';
    case Koenoem = 'kcs';
    case Kaian = 'kct';
    case Kami_Tanzania = 'kcu';
    case Kete = 'kcv';
    case Kabwari = 'kcw';
    case Kachama_Ganjule = 'kcx';
    case Korandje = 'kcy';
    case Konongo = 'kcz';
    case Worimi = 'kda';
    case Kutu = 'kdc';
    case Yankunytjatjara = 'kdd';
    case Makonde = 'kde';
    case Mamusi = 'kdf';
    case Seba = 'kdg';
    case Tem = 'kdh';
    case Kumam = 'kdi';
    case Karamojong = 'kdj';
    case Numee = 'kdk';
    case Tsikimba = 'kdl';
    case Kagoma = 'kdm';
    case Kunda = 'kdn';
    case Kaningdon_Nindem = 'kdp';
    case Koch = 'kdq';
    case Karaim = 'kdr';
    case Kuy = 'kdt';
    case Kadaru = 'kdu';
    case Koneraw = 'kdw';
    case Kam = 'kdx';
    case Keder = 'kdy';
    case Kwaja = 'kdz';
    case Kabuverdianu = 'kea';
    case Kele = 'keb';
    case Keiga = 'kec';
    case Kerewe = 'ked';
    case Eastern_Keres = 'kee';
    case Kpessi = 'kef';
    case Tese = 'keg';
    case Keak = 'keh';
    case Kei = 'kei';
    case Kadar = 'kej';
    case Kekchi = 'kek';
    case Kela_Democratic_Republic_of_Congo = 'kel';
    case Kemak = 'kem';
    case Kenyang = 'ken';
    case Kakwa = 'keo';
    case Kaikadi = 'kep';
    case Kamar = 'keq';
    case Kera = 'ker';
    case Kugbo = 'kes';
    case Ket = 'ket';
    case Akebu = 'keu';
    case Kanikkaran = 'kev';
    case West_Kewa = 'kew';
    case Kukna = 'kex';
    case Kupia = 'key';
    case Kukele = 'kez';
    case Kodava = 'kfa';
    case Northwestern_Kolami = 'kfb';
    case Konda_Dora = 'kfc';
    case Korra_Koraga = 'kfd';
    case Kota_India = 'kfe';
    case Koya = 'kff';
    case Kudiya = 'kfg';
    case Kurichiya = 'kfh';
    case Kannada_Kurumba = 'kfi';
    case Kemiehua = 'kfj';
    case Kinnauri = 'kfk';
    case Kung = 'kfl';
    case Khunsari = 'kfm';
    case Kuk = 'kfn';
    case Koro_Cote_d_Ivoire = 'kfo';
    case Korwa = 'kfp';
    case Korku = 'kfq';
    case Kachhi = 'kfr';
    case Bilaspuri = 'kfs';
    case Kanjari = 'kft';
    case Katkari = 'kfu';
    case Kurmukar = 'kfv';
    case Kharam_Naga = 'kfw';
    case Kullu_Pahari = 'kfx';
    case Kumaoni = 'kfy';
    case Koromfe = 'kfz';
    case Koyaga = 'kga';
    case Kawe = 'kgb';
    case Komering = 'kge';
    case Kube = 'kgf';
    case Kusunda = 'kgg';
    case Selangor_Sign_Language = 'kgi';
    case Gamale_Kham = 'kgj';
    case Kaiwa = 'kgk';
    case Kunggari = 'kgl';
    case Karingani = 'kgn';
    case Krongo = 'kgo';
    case Kaingang = 'kgp';
    case Kamoro = 'kgq';
    case Abun = 'kgr';
    case Kumbainggar = 'kgs';
    case Somyev = 'kgt';
    case Kobol = 'kgu';
    case Karas = 'kgv';
    case Karon_Dori = 'kgw';
    case Kamaru = 'kgx';
    case Kyerung = 'kgy';
    case Khasi = 'kha';
    case Lu = 'khb';
    case Tukang_Besi_North = 'khc';
    case Badi_Kanum = 'khd';
    case Korowai = 'khe';
    case Khuen = 'khf';
    case Khams_Tibetan = 'khg';
    case Kehu = 'khh';
    case Kuturmi = 'khj';
    case Halh_Mongolian = 'khk';
    case Lusi = 'khl';
    case Khmer = 'khm';
    case Khandesi = 'khn';
    case Khotanese = 'kho';
    case Kapori = 'khp';
    case Koyra_Chiini_Songhay = 'khq';
    case Kharia = 'khr';
    case Kasua = 'khs';
    case Khamti = 'kht';
    case Nkhumbi = 'khu';
    case Khvarshi = 'khv';
    case Khowar = 'khw';
    case Kanu = 'khx';
    case Kele_Democratic_Republic_of_Congo = 'khy';
    case Keapara = 'khz';
    case Kim = 'kia';
    case Koalib = 'kib';
    case Kickapoo = 'kic';
    case Koshin = 'kid';
    case Kibet = 'kie';
    case Eastern_Parbate_Kham = 'kif';
    case Kimaama = 'kig';
    case Kilmeri = 'kih';
    case Kitsai = 'kii';
    case Kilivila = 'kij';
    case Kikuyu = 'kik';
    case Kariya = 'kil';
    case Karagas = 'kim';
    case Kinyarwanda = 'kin';
    case Kiowa = 'kio';
    case Sheshi_Kham = 'kip';
    case Kosadle = 'kiq';
    case Kirghiz = 'kir';
    case Kis = 'kis';
    case Agob = 'kit';
    case Kirmanjki_individual_language = 'kiu';
    case Kimbu = 'kiv';
    case Northeast_Kiwai = 'kiw';
    case Khiamniungan_Naga = 'kix';
    case Kirikiri = 'kiy';
    case Kisi = 'kiz';
    case Mlap = 'kja';
    case Q_anjob_al = 'kjb';
    case Coastal_Konjo = 'kjc';
    case Southern_Kiwai = 'kjd';
    case Kisar = 'kje';
    case Khmu = 'kjg';
    case Khakas = 'kjh';
    case Zabana = 'kji';
    case Khinalugh = 'kjj';
    case Highland_Konjo = 'kjk';
    case Western_Parbate_Kham = 'kjl';
    case Khang = 'kjm';
    case Kunjen = 'kjn';
    case Harijan_Kinnauri = 'kjo';
    case Pwo_Eastern_Karen = 'kjp';
    case Western_Keres = 'kjq';
    case Kurudu = 'kjr';
    case East_Kewa = 'kjs';
    case Phrae_Pwo_Karen = 'kjt';
    case Kashaya = 'kju';
    case Kaikavian_Literary_Language = 'kjv';
    case Ramopa = 'kjx';
    case Erave = 'kjy';
    case Bumthangkha = 'kjz';
    case Kakanda = 'kka';
    case Kwerisa = 'kkb';
    case Odoodee = 'kkc';
    case Kinuku = 'kkd';
    case Kakabe = 'kke';
    case Kalaktang_Monpa = 'kkf';
    case Mabaka_Valley_Kalinga = 'kkg';
    case Khun = 'kkh';
    case Kagulu = 'kki';
    case Kako = 'kkj';
    case Kokota = 'kkk';
    case Kosarek_Yale = 'kkl';
    case Kiong = 'kkm';
    case Kon_Keu = 'kkn';
    case Karko = 'kko';
    case Gugubera = 'kkp';
    case Kaeku = 'kkq';
    case Kir_Balar = 'kkr';
    case Giiwo = 'kks';
    case Koi = 'kkt';
    case Tumi = 'kku';
    case Kangean = 'kkv';
    case Teke_Kukuya = 'kkw';
    case Kohin = 'kkx';
    case Guugu_Yimidhirr = 'kky';
    case Kaska = 'kkz';
    case Klamath_Modoc = 'kla';
    case Kiliwa = 'klb';
    case Kolbila = 'klc';
    case Gamilaraay = 'kld';
    case Kulung_Nepal = 'kle';
    case Kendeje = 'klf';
    case Tagakaulo = 'klg';
    case Weliki = 'klh';
    case Kalumpang = 'kli';
    case Khalaj = 'klj';
    case Kono_Nigeria = 'klk';
    case Kagan_Kalagan = 'kll';
    case Migum = 'klm';
    case Kalenjin = 'kln';
    case Kapya = 'klo';
    case Kamasa = 'klp';
    case Rumu = 'klq';
    case Khaling = 'klr';
    case Kalasha = 'kls';
    case Nukna = 'klt';
    case Klao = 'klu';
    case Maskelynes = 'klv';
    case Tado = 'klw';
    case Koluwawa = 'klx';
    case Kalao = 'kly';
    case Kabola = 'klz';
    case Konni = 'kma';
    case Kimbundu = 'kmb';
    case Southern_Dong = 'kmc';
    case Majukayang_Kalinga = 'kmd';
    case Bakole = 'kme';
    case Kare_Papua_New_Guinea = 'kmf';
    case Kate = 'kmg';
    case Kalam = 'kmh';
    case Kami_Nigeria = 'kmi';
    case Kumarbhag_Paharia = 'kmj';
    case Limos_Kalinga = 'kmk';
    case Tanudan_Kalinga = 'kml';
    case Kom_India = 'kmm';
    case Awtuw = 'kmn';
    case Kwoma = 'kmo';
    case Gimme = 'kmp';
    case Kwama = 'kmq';
    case Northern_Kurdish = 'kmr';
    case Kamasau = 'kms';
    case Kemtuik = 'kmt';
    case Kanite = 'kmu';
    case Karipuna_Creole_French = 'kmv';
    case Komo_Democratic_Republic_of_Congo = 'kmw';
    case Waboda = 'kmx';
    case Koma = 'kmy';
    case Khorasani_Turkish = 'kmz';
    case Dera_Nigeria = 'kna';
    case Lubuagan_Kalinga = 'knb';
    case Central_Kanuri = 'knc';
    case Konda = 'knd';
    case Kankanaey = 'kne';
    case Mankanya = 'knf';
    case Koongo = 'kng';
    case Kanufi = 'kni';
    case Western_Kanjobal = 'knj';
    case Kuranko = 'knk';
    case Keninjal = 'knl';
    case Kanamari = 'knm';
    case Konkani_individual_language = 'knn';
    case Kono_Sierra_Leone = 'kno';
    case Kwanja = 'knp';
    case Kintaq = 'knq';
    case Kaningra = 'knr';
    case Kensiu = 'kns';
    case Panoan_Katukina = 'knt';
    case Kono_Guinea = 'knu';
    case Tabo = 'knv';
    case Kung_Ekoka = 'knw';
    case Kendayan = 'knx';
    case Kanyok = 'kny';
    case Kalamse = 'knz';
    case Konomala = 'koa';
    case Kpati = 'koc';
    case Kodi = 'kod';
    case Kacipo_Bale_Suri = 'koe';
    case Kubi = 'kof';
    case Cogui = 'kog';
    case Koyo = 'koh';
    case Komi_Permyak = 'koi';
    case Konkani_macrolanguage = 'kok';
    case Kol_Papua_New_Guinea = 'kol';
    case Komi = 'kom';
    case Kongo = 'kon';
    case Konzo = 'koo';
    case Waube = 'kop';
    case Kota_Gabon = 'koq';
    case Korean = 'kor';
    case Kosraean = 'kos';
    case Lagwan = 'kot';
    case Koke = 'kou';
    case Kudu_Camo = 'kov';
    case Kugama = 'kow';
    case Koyukon = 'koy';
    case Korak = 'koz';
    case Kutto = 'kpa';
    case Mullu_Kurumba = 'kpb';
    case Curripaco = 'kpc';
    case Koba = 'kpd';
    case Kpelle = 'kpe';
    case Komba = 'kpf';
    case Kapingamarangi = 'kpg';
    case Kplang = 'kph';
    case Kofei = 'kpi';
    case Karaja = 'kpj';
    case Kpan = 'kpk';
    case Kpala = 'kpl';
    case Koho = 'kpm';
    case Kepkiriwat = 'kpn';
    case Ikposo = 'kpo';
    case Korupun_Sela = 'kpq';
    case Korafe_Yegha = 'kpr';
    case Tehit = 'kps';
    case Karata = 'kpt';
    case Kafoa = 'kpu';
    case Komi_Zyrian = 'kpv';
    case Kobon = 'kpw';
    case Mountain_Koiali = 'kpx';
    case Koryak = 'kpy';
    case Kupsabiny = 'kpz';
    case Mum = 'kqa';
    case Kovai = 'kqb';
    case Doromu_Koki = 'kqc';
    case Koy_Sanjaq_Surat = 'kqd';
    case Kalagan = 'kqe';
    case Kakabai = 'kqf';
    case Khe = 'kqg';
    case Kisankasa = 'kqh';
    case Koitabu = 'kqi';
    case Koromira = 'kqj';
    case Kotafon_Gbe = 'kqk';
    case Kyenele = 'kql';
    case Khisa = 'kqm';
    case Kaonde = 'kqn';
    case Eastern_Krahn = 'kqo';
    case Kimre = 'kqp';
    case Krenak = 'kqq';
    case Kimaragang = 'kqr';
    case Northern_Kissi = 'kqs';
    case Klias_River_Kadazan = 'kqt';
    case Seroa = 'kqu';
    case Okolod = 'kqv';
    case Kandas = 'kqw';
    case Mser = 'kqx';
    case Koorete = 'kqy';
    case Korana = 'kqz';
    case Kumhali = 'kra';
    case Karkin = 'krb';
    case Karachay_Balkar = 'krc';
    case Kairui_Midiki = 'krd';
    case Panara = 'kre';
    case Koro_Vanuatu = 'krf';
    case Kurama = 'krh';
    case Krio = 'kri';
    case Kinaray_A = 'krj';
    case Kerek = 'krk';
    case Karelian = 'krl';
    case Sapo = 'krn';
    case Durop = 'krp';
    case Krung = 'krr';
    case Gbaya_Sudan = 'krs';
    case Tumari_Kanuri = 'krt';
    case Kurukh = 'kru';
    case Kavet = 'krv';
    case Western_Krahn = 'krw';
    case Karon = 'krx';
    case Kryts = 'kry';
    case Sota_Kanum = 'krz';
    case Shambala = 'ksb';
    case Southern_Kalinga = 'ksc';
    case Kuanua = 'ksd';
    case Kuni = 'kse';
    case Bafia = 'ksf';
    case Kusaghe = 'ksg';
    case Kolsch = 'ksh';
    case Krisa = 'ksi';
    case Uare = 'ksj';
    case Kansa = 'ksk';
    case Kumalu = 'ksl';
    case Kumba = 'ksm';
    case Kasiguranin = 'ksn';
    case Kofa = 'kso';
    case Kaba = 'ksp';
    case Kwaami = 'ksq';
    case Borong = 'ksr';
    case Southern_Kisi = 'kss';
    case Winye = 'kst';
    case Khamyang = 'ksu';
    case Kusu = 'ksv';
    case S_gaw_Karen = 'ksw';
    case Kedang = 'ksx';
    case Kharia_Thar = 'ksy';
    case Kodaku = 'ksz';
    case Katua = 'kta';
    case Kambaata = 'ktb';
    case Kholok = 'ktc';
    case Kokata = 'ktd';
    case Nubri = 'kte';
    case Kwami = 'ktf';
    case Kalkutung = 'ktg';
    case Karanga = 'kth';
    case North_Muyu = 'kti';
    case Plapo_Krumen = 'ktj';
    case Kaniet = 'ktk';
    case Koroshi = 'ktl';
    case Kurti = 'ktm';
    case Karitiana = 'ktn';
    case Kuot = 'kto';
    case Kaduo = 'ktp';
    case Katabaga = 'ktq';
    case South_Muyu = 'kts';
    case Ketum = 'ktt';
    case Kituba_Democratic_Republic_of_Congo = 'ktu';
    case Eastern_Katu = 'ktv';
    case Kato = 'ktw';
    case Kaxarari = 'ktx';
    case Kango_Bas_Uele_District = 'kty';
    case Ju_hoan = 'ktz';
    case Kuanyama = 'kua';
    case Kutep = 'kub';
    case Kwinsu = 'kuc';
    case Auhelawa = 'kud';
    case Kuman_Papua_New_Guinea = 'kue';
    case Western_Katu = 'kuf';
    case Kupa = 'kug';
    case Kushi = 'kuh';
    case Kuikuro_Kalapalo = 'kui';
    case Kuria = 'kuj';
    case Kepo = 'kuk';
    case Kulere = 'kul';
    case Kumyk = 'kum';
    case Kunama = 'kun';
    case Kumukio = 'kuo';
    case Kunimaipa = 'kup';
    case Karipuna = 'kuq';
    case Kurdish = 'kur';
    case Kusaal = 'kus';
    case Kutenai = 'kut';
    case Upper_Kuskokwim = 'kuu';
    case Kur = 'kuv';
    case Kpagua = 'kuw';
    case Kukatja = 'kux';
    case Kuuku_Ya_u = 'kuy';
    case Kunza = 'kuz';
    case Bagvalal = 'kva';
    case Kubu = 'kvb';
    case Kove = 'kvc';
    case Kui_Indonesia = 'kvd';
    case Kalabakan = 'kve';
    case Kabalai = 'kvf';
    case Kuni_Boazi = 'kvg';
    case Komodo = 'kvh';
    case Kwang = 'kvi';
    case Psikye = 'kvj';
    case Korean_Sign_Language = 'kvk';
    case Kayaw = 'kvl';
    case Kendem = 'kvm';
    case Border_Kuna = 'kvn';
    case Dobel = 'kvo';
    case Kompane = 'kvp';
    case Geba_Karen = 'kvq';
    case Kerinci = 'kvr';
    case Lahta_Karen = 'kvt';
    case Yinbaw_Karen = 'kvu';
    case Kola = 'kvv';
    case Wersing = 'kvw';
    case Parkari_Koli = 'kvx';
    case Yintale_Karen = 'kvy';
    case Tsakwambo = 'kvz';
    case Daw = 'kwa';
    case Kwa_2 = 'kwb';
    case Likwala = 'kwc';
    case Kwaio = 'kwd';
    case Kwerba = 'kwe';
    case Kwara_ae = 'kwf';
    case Sara_Kaba_Deme = 'kwg';
    case Kowiai = 'kwh';
    case Awa_Cuaiquer = 'kwi';
    case Kwanga = 'kwj';
    case Kwakiutl = 'kwk';
    case Kofyar = 'kwl';
    case Kwambi = 'kwm';
    case Kwangali = 'kwn';
    case Kwomtari = 'kwo';
    case Kodia = 'kwp';
    case Kwer = 'kwr';
    case Kwese = 'kws';
    case Kwesten = 'kwt';
    case Kwakum = 'kwu';
    case Sara_Kaba_Naa = 'kwv';
    case Kwinti = 'kww';
    case Khirwar = 'kwx';
    case San_Salvador_Kongo = 'kwy';
    case Kwadi = 'kwz';
    case Kairiru = 'kxa';
    case Krobu = 'kxb';
    case Konso = 'kxc';
    case Brunei = 'kxd';
    case Manumanaw_Karen = 'kxf';
    case Karo_Ethiopia = 'kxh';
    case Keningau_Murut = 'kxi';
    case Kulfa = 'kxj';
    case Zayein_Karen = 'kxk';
    case Northern_Khmer = 'kxm';
    case Kanowit_Tanjong_Melanau = 'kxn';
    case Kanoe = 'kxo';
    case Wadiyara_Koli = 'kxp';
    case Smarky_Kanum = 'kxq';
    case Koro_Papua_New_Guinea = 'kxr';
    case Kangjia = 'kxs';
    case Koiwat = 'kxt';
    case Kuvi = 'kxv';
    case Konai = 'kxw';
    case Likuba = 'kxx';
    case Kayong = 'kxy';
    case Kerewo = 'kxz';
    case Kwaya = 'kya';
    case Butbut_Kalinga = 'kyb';
    case Kyaka = 'kyc';
    case Karey = 'kyd';
    case Krache = 'kye';
    case Kouya = 'kyf';
    case Keyagana = 'kyg';
    case Karok = 'kyh';
    case Kiput = 'kyi';
    case Karao = 'kyj';
    case Kamayo = 'kyk';
    case Kalapuya = 'kyl';
    case Kpatili = 'kym';
    case Northern_Binukidnon = 'kyn';
    case Kelon = 'kyo';
    case Kang = 'kyp';
    case Kenga = 'kyq';
    case Kuruaya = 'kyr';
    case Baram_Kayan = 'kys';
    case Kayagar = 'kyt';
    case Western_Kayah = 'kyu';
    case Kayort = 'kyv';
    case Kudmali = 'kyw';
    case Rapoisi = 'kyx';
    case Kambaira = 'kyy';
    case Kayabi = 'kyz';
    case Western_Karaboro = 'kza';
    case Kaibobo = 'kzb';
    case Bondoukou_Kulango = 'kzc';
    case Kadai = 'kzd';
    case Kosena = 'kze';
    case Da_a_Kaili = 'kzf';
    case Kikai = 'kzg';
    case Kelabit = 'kzi';
    case Kazukuru = 'kzk';
    case Kayeli = 'kzl';
    case Kais = 'kzm';
    case Kokola = 'kzn';
    case Kaningi = 'kzo';
    case Kaidipang = 'kzp';
    case Kaike = 'kzq';
    case Karang = 'kzr';
    case Sugut_Dusun = 'kzs';
    case Kayupulau = 'kzu';
    case Komyandaret = 'kzv';
    case Kariri_Xoco = 'kzw';
    case Kamarian = 'kzx';
    case Kango_Tshopo_District = 'kzy';
    case Kalabra = 'kzz';
    case Southern_Subanen = 'laa';
    case Linear_A = 'lab';
    case Lacandon = 'lac';
    case Ladino = 'lad';
    case Pattani = 'lae';
    case Lafofa = 'laf';
    case Rangi = 'lag';
    case Lahnda = 'lah';
    case Lambya = 'lai';
    case Lango_Uganda = 'laj';
    case Lalia = 'lal';
    case Lamba = 'lam';
    case Laru = 'lan';
    case Lao = 'lao';
    case Laka_Chad = 'lap';
    case Qabiao = 'laq';
    case Larteh = 'lar';
    case Lama_Togo = 'las';
    case Latin = 'lat';
    case Laba = 'lau';
    case Latvian = 'lav';
    case Lauje = 'law';
    case Tiwa = 'lax';
    case Lama_Bai = 'lay';
    case Aribwatsa = 'laz';
    case Label = 'lbb';
    case Lakkia = 'lbc';
    case Lak = 'lbe';
    case Tinani = 'lbf';
    case Laopang = 'lbg';
    case La_bi = 'lbi';
    case Ladakhi = 'lbj';
    case Central_Bontok = 'lbk';
    case Libon_Bikol = 'lbl';
    case Lodhi = 'lbm';
    case Rmeet = 'lbn';
    case Laven = 'lbo';
    case Wampar = 'lbq';
    case Lohorung = 'lbr';
    case Libyan_Sign_Language = 'lbs';
    case Lachi = 'lbt';
    case Labu = 'lbu';
    case Lavatbura_Lamusong = 'lbv';
    case Tolaki = 'lbw';
    case Lawangan = 'lbx';
    case Lamalama = 'lby';
    case Lardil = 'lbz';
    case Legenyem = 'lcc';
    case Lola = 'lcd';
    case Loncong = 'lce';
    case Lubu = 'lcf';
    case Luchazi = 'lch';
    case Lisela = 'lcl';
    case Tungag = 'lcm';
    case Western_Lawa = 'lcp';
    case Luhu = 'lcq';
    case Lisabata_Nuniali = 'lcs';
    case Kla_Dan = 'lda';
    case Du_ya = 'ldb';
    case Luri = 'ldd';
    case Lenyima = 'ldg';
    case Lamja_Dengsa_Tola = 'ldh';
    case Laari = 'ldi';
    case Lemoro = 'ldj';
    case Leelau = 'ldk';
    case Kaan = 'ldl';
    case Landoma = 'ldm';
    case Laadan = 'ldn';
    case Loo = 'ldo';
    case Tso = 'ldp';
    case Lufu = 'ldq';
    case Lega_Shabunda = 'lea';
    case Lala_Bisa = 'leb';
    case Leco = 'lec';
    case Lendu = 'led';
    case Lyele = 'lee';
    case Lelemi = 'lef';
    case Lenje = 'leh';
    case Lemio = 'lei';
    case Lengola = 'lej';
    case Leipon = 'lek';
    case Lele_Democratic_Republic_of_Congo = 'lel';
    case Nomaande = 'lem';
    case Lenca = 'len';
    case Leti_Cameroon = 'leo';
    case Lepcha = 'lep';
    case Lembena = 'leq';
    case Lenkau = 'ler';
    case Lese = 'les';
    case Lesing_Gelimi = 'let';
    case Kara_Papua_New_Guinea = 'leu';
    case Lamma = 'lev';
    case Ledo_Kaili = 'lew';
    case Luang = 'lex';
    case Lemolang = 'ley';
    case Lezghian = 'lez';
    case Lefa = 'lfa';
    case Lingua_Franca_Nova = 'lfn';
    case Lungga = 'lga';
    case Laghu = 'lgb';
    case Lugbara = 'lgg';
    case Laghuu = 'lgh';
    case Lengilu = 'lgi';
    case Lingarak = 'lgk';
    case Wala = 'lgl';
    case Lega_Mwenga = 'lgm';
    case T_apo = 'lgn';
    case Lango_South_Sudan = 'lgo';
    case Logba = 'lgq';
    case Lengo = 'lgr';
    case Guinea_Bissau_Sign_Language = 'lgs';
    case Pahi = 'lgt';
    case Longgu = 'lgu';
    case Ligenza = 'lgz';
    case Laha_Viet_Nam = 'lha';
    case Laha_Indonesia = 'lhh';
    case Lahu_Shi = 'lhi';
    case Lahul_Lohar = 'lhl';
    case Lhomi = 'lhm';
    case Lahanan = 'lhn';
    case Lhokpu = 'lhp';
    case Mlahso = 'lhs';
    case Lo_Toga = 'lht';
    case Lahu = 'lhu';
    case West_Central_Limba = 'lia';
    case Likum = 'lib';
    case Hlai = 'lic';
    case Nyindrou = 'lid';
    case Likila = 'lie';
    case Limbu = 'lif';
    case Ligbi = 'lig';
    case Lihir = 'lih';
    case Ligurian = 'lij';
    case Lika = 'lik';
    case Lillooet = 'lil';
    case Limburgan = 'lim';
    case Lingala = 'lin';
    case Liki = 'lio';
    case Sekpele = 'lip';
    case Libido = 'liq';
    case Liberian_English = 'lir';
    case Lisu = 'lis';
    case Lithuanian = 'lit';
    case Logorik = 'liu';
    case Liv = 'liv';
    case Col = 'liw';
    case Liabuku = 'lix';
    case Banda_Bambari = 'liy';
    case Libinza = 'liz';
    case Golpa = 'lja';
    case Rampi = 'lje';
    case Laiyolo = 'lji';
    case Li_o = 'ljl';
    case Lampung_Api = 'ljp';
    case Yirandali = 'ljw';
    case Yuru = 'ljx';
    case Lakalei = 'lka';
    case Kabras = 'lkb';
    case Kucong = 'lkc';
    case Lakonde = 'lkd';
    case Kenyi = 'lke';
    case Lakha = 'lkh';
    case Laki = 'lki';
    case Remun = 'lkj';
    case Laeko_Libuat = 'lkl';
    case Kalaamaya = 'lkm';
    case Lakon = 'lkn';
    case Khayo = 'lko';
    case Pari = 'lkr';
    case Kisa = 'lks';
    case Lakota = 'lkt';
    case Kungkari = 'lku';
    case Lokoya = 'lky';
    case Lala_Roba = 'lla';
    case Lolo = 'llb';
    case Lele_Guinea = 'llc';
    case Ladin = 'lld';
    case Lele_Papua_New_Guinea = 'lle';
    case Hermit = 'llf';
    case Lole = 'llg';
    case Lamu = 'llh';
    case Teke_Laali = 'lli';
    case Ladji_Ladji = 'llj';
    case Lelak = 'llk';
    case Lilau = 'lll';
    case Lasalimu = 'llm';
    case Lele_Chad = 'lln';
    case North_Efate = 'llp';
    case Lolak = 'llq';
    case Lithuanian_Sign_Language = 'lls';
    case Lau = 'llu';
    case Lauan = 'llx';
    case East_Limba = 'lma';
    case Merei = 'lmb';
    case Limilngan = 'lmc';
    case Lumun = 'lmd';
    case Peve = 'lme';
    case South_Lembata = 'lmf';
    case Lamogai = 'lmg';
    case Lambichhong = 'lmh';
    case Lombi = 'lmi';
    case West_Lembata = 'lmj';
    case Lamkang = 'lmk';
    case Hano = 'lml';
    case Lambadi = 'lmn';
    case Lombard = 'lmo';
    case Limbum = 'lmp';
    case Lamatuka = 'lmq';
    case Lamalera = 'lmr';
    case Lamenu = 'lmu';
    case Lomaiviti = 'lmv';
    case Lake_Miwok = 'lmw';
    case Laimbue = 'lmx';
    case Lamboya = 'lmy';
    case Langbashe = 'lna';
    case Mbalanhu = 'lnb';
    case Lundayeh = 'lnd';
    case Langobardic = 'lng';
    case Lanoh = 'lnh';
    case Daantanai = 'lni';
    case Leningitij = 'lnj';
    case South_Central_Banda = 'lnl';
    case Langam = 'lnm';
    case Lorediakarkar = 'lnn';
    case Lamnso = 'lns';
    case Longuda = 'lnu';
    case Lanima = 'lnw';
    case Lonzo = 'lnz';
    case Loloda = 'loa';
    case Lobi = 'lob';
    case Inonhan = 'loc';
    case Saluan = 'loe';
    case Logol = 'lof';
    case Logo = 'log';
    case Laarim = 'loh';
    case Loma_Cote_d_Ivoire = 'loi';
    case Lou = 'loj';
    case Loko = 'lok';
    case Mongo = 'lol';
    case Loma_Liberia = 'lom';
    case Malawi_Lomwe = 'lon';
    case Lombo = 'loo';
    case Lopa = 'lop';
    case Lobala = 'loq';
    case Teen = 'lor';
    case Loniu = 'los';
    case Otuho = 'lot';
    case Louisiana_Creole = 'lou';
    case Lopi = 'lov';
    case Tampias_Lobu = 'low';
    case Loun = 'lox';
    case Loke = 'loy';
    case Lozi = 'loz';
    case Lelepa = 'lpa';
    case Lepki = 'lpe';
    case Long_Phuri_Naga = 'lpn';
    case Lipo = 'lpo';
    case Lopit = 'lpx';
    case Logir = 'lqr';
    case Rara_Bakati = 'lra';
    case Northern_Luri = 'lrc';
    case Laurentian = 'lre';
    case Laragia = 'lrg';
    case Marachi = 'lri';
    case Loarki = 'lrk';
    case Lari = 'lrl';
    case Marama = 'lrm';
    case Lorang = 'lrn';
    case Laro = 'lro';
    case Southern_Yamphu = 'lrr';
    case Larantuka_Malay = 'lrt';
    case Larevat = 'lrv';
    case Lemerig = 'lrz';
    case Lasgerdi = 'lsa';
    case Burundian_Sign_Language = 'lsb';
    case Albarradas_Sign_Language = 'lsc';
    case Lishana_Deni = 'lsd';
    case Lusengo = 'lse';
    case Lish = 'lsh';
    case Lashi = 'lsi';
    case Latvian_Sign_Language = 'lsl';
    case Saamia = 'lsm';
    case Tibetan_Sign_Language = 'lsn';
    case Laos_Sign_Language = 'lso';
    case Panamanian_Sign_Language = 'lsp';
    case Aruop = 'lsr';
    case Lasi = 'lss';
    case Trinidad_and_Tobago_Sign_Language = 'lst';
    case Sivia_Sign_Language = 'lsv';
    case Seychelles_Sign_Language = 'lsw';
    case Mauritian_Sign_Language = 'lsy';
    case Late_Middle_Chinese = 'ltc';
    case Latgalian = 'ltg';
    case Thur = 'lth';
    case Leti_Indonesia = 'lti';
    case Latunde = 'ltn';
    case Tsotso = 'lto';
    case Tachoni = 'lts';
    case Latu = 'ltu';
    case Luxembourgish = 'ltz';
    case Luba_Lulua = 'lua';
    case Luba_Katanga = 'lub';
    case Aringa = 'luc';
    case Ludian = 'lud';
    case Luvale = 'lue';
    case Laua = 'luf';
    case Ganda = 'lug';
    case Leizhou_Chinese = 'luh';
    case Luiseno = 'lui';
    case Luna = 'luj';
    case Lunanakha = 'luk';
    case Olu_bo = 'lul';
    case Luimbi = 'lum';
    case Lunda = 'lun';
    case Luo_Kenya_and_Tanzania = 'luo';
    case Lumbu = 'lup';
    case Lucumi = 'luq';
    case Laura = 'lur';
    case Lushai = 'lus';
    case Lushootseed = 'lut';
    case Lumba_Yakkha = 'luu';
    case Luwati = 'luv';
    case Luo_Cameroon = 'luw';
    case Luyia = 'luy';
    case Southern_Luri = 'luz';
    case Maku_a = 'lva';
    case Lavi = 'lvi';
    case Lavukaleve = 'lvk';
    case Lwel = 'lvl';
    case Standard_Latvian = 'lvs';
    case Levuka = 'lvu';
    case Lwalu = 'lwa';
    case Lewo_Eleng = 'lwe';
    case Wanga = 'lwg';
    case White_Lachi = 'lwh';
    case Eastern_Lawa = 'lwl';
    case Laomian = 'lwm';
    case Luwo = 'lwo';
    case Malawian_Sign_Language = 'lws';
    case Lewotobi = 'lwt';
    case Lawu = 'lwu';
    case Lewo = 'lww';
    case Lakurumau = 'lxm';
    case Layakha = 'lya';
    case Lyngngam = 'lyg';
    case Luyana = 'lyn';
    case Literary_Chinese = 'lzh';
    case Litzlitz = 'lzl';
    case Leinong_Naga = 'lzn';
    case Laz = 'lzz';
    case San_Jeronimo_Tecoatl_Mazatec = 'maa';
    case Yutanduchi_Mixtec = 'mab';
    case Madurese = 'mad';
    case Bo_Rukul = 'mae';
    case Mafa = 'maf';
    case Magahi = 'mag';
    case Marshallese = 'mah';
    case Maithili = 'mai';
    case Jalapa_De_Diaz_Mazatec = 'maj';
    case Makasar = 'mak';
    case Malayalam = 'mal';
    case Mam = 'mam';
    case Mandingo = 'man';
    case Chiquihuitlan_Mazatec = 'maq';
    case Marathi = 'mar';
    case Masai = 'mas';
    case San_Francisco_Matlatzinca = 'mat';
    case Huautla_Mazatec = 'mau';
    case Satere_Mawe = 'mav';
    case Mampruli = 'maw';
    case North_Moluccan_Malay = 'max';
    case Central_Mazahua = 'maz';
    case Higaonon = 'mba';
    case Western_Bukidnon_Manobo = 'mbb';
    case Macushi = 'mbc';
    case Dibabawon_Manobo = 'mbd';
    case Molale = 'mbe';
    case Baba_Malay = 'mbf';
    case Mangseng = 'mbh';
    case Ilianen_Manobo = 'mbi';
    case Nadeb = 'mbj';
    case Malol = 'mbk';
    case Maxakali = 'mbl';
    case Ombamba = 'mbm';
    case Macaguan = 'mbn';
    case Mbo_Cameroon = 'mbo';
    case Malayo = 'mbp';
    case Maisin = 'mbq';
    case Nukak_Maku = 'mbr';
    case Sarangani_Manobo = 'mbs';
    case Matigsalug_Manobo = 'mbt';
    case Mbula_Bwazza = 'mbu';
    case Mbulungish = 'mbv';
    case Maring = 'mbw';
    case Mari_East_Sepik_Province = 'mbx';
    case Memoni = 'mby';
    case Amoltepec_Mixtec = 'mbz';
    case Maca = 'mca';
    case Machiguenga = 'mcb';
    case Bitur = 'mcc';
    case Sharanahua = 'mcd';
    case Itundujia_Mixtec = 'mce';
    case Matses = 'mcf';
    case Mapoyo = 'mcg';
    case Maquiritari = 'mch';
    case Mese = 'mci';
    case Mvanip = 'mcj';
    case Mbunda = 'mck';
    case Macaguaje = 'mcl';
    case Malaccan_Creole_Portuguese = 'mcm';
    case Masana = 'mcn';
    case Coatlan_Mixe = 'mco';
    case Makaa = 'mcp';
    case Ese = 'mcq';
    case Menya = 'mcr';
    case Mambai = 'mcs';
    case Mengisa = 'mct';
    case Cameroon_Mambila = 'mcu';
    case Minanibai = 'mcv';
    case Mawa_Chad = 'mcw';
    case Mpiemo = 'mcx';
    case South_Watut = 'mcy';
    case Mawan = 'mcz';
    case Mada_Nigeria = 'mda';
    case Morigi = 'mdb';
    case Male_Papua_New_Guinea = 'mdc';
    case Mbum = 'mdd';
    case Maba_Chad = 'mde';
    case Moksha = 'mdf';
    case Massalat = 'mdg';
    case Maguindanaon = 'mdh';
    case Mamvu = 'mdi';
    case Mangbetu = 'mdj';
    case Mangbutu = 'mdk';
    case Maltese_Sign_Language = 'mdl';
    case Mayogo = 'mdm';
    case Mbati = 'mdn';
    case Mbala = 'mdp';
    case Mbole = 'mdq';
    case Mandar = 'mdr';
    case Maria_Papua_New_Guinea = 'mds';
    case Mbere = 'mdt';
    case Mboko = 'mdu';
    case Santa_Lucia_Monteverde_Mixtec = 'mdv';
    case Mbosi = 'mdw';
    case Dizin = 'mdx';
    case Male_Ethiopia = 'mdy';
    case Surui_Do_Para = 'mdz';
    case Menka = 'mea';
    case Ikobi = 'meb';
    case Marra = 'mec';
    case Melpa = 'med';
    case Mengen = 'mee';
    case Megam = 'mef';
    case Southwestern_Tlaxiaco_Mixtec = 'meh';
    case Midob = 'mei';
    case Meyah = 'mej';
    case Mekeo = 'mek';
    case Central_Melanau = 'mel';
    case Mangala = 'mem';
    case Mende_Sierra_Leone = 'men';
    case Kedah_Malay = 'meo';
    case Miriwoong = 'mep';
    case Merey = 'meq';
    case Meru = 'mer';
    case Masmaje = 'mes';
    case Mato = 'met';
    case Motu = 'meu';
    case Mano = 'mev';
    case Maaka = 'mew';
    case Hassaniyya = 'mey';
    case Menominee = 'mez';
    case Pattani_Malay = 'mfa';
    case Bangka = 'mfb';
    case Mba = 'mfc';
    case Mendankwe_Nkwen = 'mfd';
    case Morisyen = 'mfe';
    case Naki = 'mff';
    case Mogofin = 'mfg';
    case Matal = 'mfh';
    case Wandala = 'mfi';
    case Mefele = 'mfj';
    case North_Mofu = 'mfk';
    case Putai = 'mfl';
    case Marghi_South = 'mfm';
    case Cross_River_Mbembe = 'mfn';
    case Mbe = 'mfo';
    case Makassar_Malay = 'mfp';
    case Moba = 'mfq';
    case Marrithiyel = 'mfr';
    case Mexican_Sign_Language = 'mfs';
    case Mokerang = 'mft';
    case Mbwela = 'mfu';
    case Mandjak = 'mfv';
    case Mulaha = 'mfw';
    case Melo = 'mfx';
    case Mayo = 'mfy';
    case Mabaan = 'mfz';
    case Middle_Irish_900_1200 = 'mga';
    case Mararit = 'mgb';
    case Morokodo = 'mgc';
    case Moru = 'mgd';
    case Mango = 'mge';
    case Maklew = 'mgf';
    case Mpumpong = 'mgg';
    case Makhuwa_Meetto = 'mgh';
    case Lijili = 'mgi';
    case Abureni = 'mgj';
    case Mawes = 'mgk';
    case Maleu_Kilenge = 'mgl';
    case Mambae = 'mgm';
    case Mbangi = 'mgn';
    case Meta = 'mgo';
    case Eastern_Magar = 'mgp';
    case Malila = 'mgq';
    case Mambwe_Lungu = 'mgr';
    case Manda_Tanzania = 'mgs';
    case Mongol = 'mgt';
    case Mailu = 'mgu';
    case Matengo = 'mgv';
    case Matumbi = 'mgw';
    case Mbunga = 'mgy';
    case Mbugwe = 'mgz';
    case Manda_India = 'mha';
    case Mahongwe = 'mhb';
    case Mocho = 'mhc';
    case Mbugu = 'mhd';
    case Besisi = 'mhe';
    case Mamaa = 'mhf';
    case Margu = 'mhg';
    case Ma_di = 'mhi';
    case Mogholi = 'mhj';
    case Mungaka = 'mhk';
    case Mauwake = 'mhl';
    case Makhuwa_Moniga = 'mhm';
    case Mocheno = 'mhn';
    case Mashi_Zambia = 'mho';
    case Balinese_Malay = 'mhp';
    case Mandan = 'mhq';
    case Eastern_Mari = 'mhr';
    case Buru_Indonesia = 'mhs';
    case Mandahuaca = 'mht';
    case Digaro_Mishmi = 'mhu';
    case Mbukushu = 'mhw';
    case Maru = 'mhx';
    case Ma_anyan = 'mhy';
    case Mor_Mor_Islands = 'mhz';
    case Miami = 'mia';
    case Atatlahuca_Mixtec = 'mib';
    case Mi_kmaq = 'mic';
    case Mandaic = 'mid';
    case Ocotepec_Mixtec = 'mie';
    case Mofu_Gudur = 'mif';
    case San_Miguel_El_Grande_Mixtec = 'mig';
    case Chayuco_Mixtec = 'mih';
    case Chigmecatitlan_Mixtec = 'mii';
    case Abar = 'mij';
    case Mikasuki = 'mik';
    case Penoles_Mixtec = 'mil';
    case Alacatlatzala_Mixtec = 'mim';
    case Minangkabau = 'min';
    case Pinotepa_Nacional_Mixtec = 'mio';
    case Apasco_Apoala_Mixtec = 'mip';
    case Miskito = 'miq';
    case Isthmus_Mixe = 'mir';
    case Uncoded_languages = 'mis';
    case Southern_Puebla_Mixtec = 'mit';
    case Cacaloxtepec_Mixtec = 'miu';
    case Akoye = 'miw';
    case Mixtepec_Mixtec = 'mix';
    case Ayutla_Mixtec = 'miy';
    case Coatzospan_Mixtec = 'miz';
    case Makalero = 'mjb';
    case San_Juan_Colorado_Mixtec = 'mjc';
    case Northwest_Maidu = 'mjd';
    case Muskum = 'mje';
    case Tu = 'mjg';
    case Mwera_Nyasa = 'mjh';
    case Kim_Mun = 'mji';
    case Mawak = 'mjj';
    case Matukar = 'mjk';
    case Mandeali = 'mjl';
    case Medebur = 'mjm';
    case Ma_Papua_New_Guinea = 'mjn';
    case Malankuravan = 'mjo';
    case Malapandaram = 'mjp';
    case Malaryan = 'mjq';
    case Malavedan = 'mjr';
    case Miship = 'mjs';
    case Sauria_Paharia = 'mjt';
    case Manna_Dora = 'mju';
    case Mannan = 'mjv';
    case Karbi = 'mjw';
    case Mahali = 'mjx';
    case Mahican = 'mjy';
    case Majhi = 'mjz';
    case Mbre = 'mka';
    case Mal_Paharia = 'mkb';
    case Siliput = 'mkc';
    case Macedonian = 'mkd';
    case Mawchi = 'mke';
    case Miya = 'mkf';
    case Mak_China = 'mkg';
    case Dhatki = 'mki';
    case Mokilese = 'mkj';
    case Byep = 'mkk';
    case Mokole = 'mkl';
    case Moklen = 'mkm';
    case Kupang_Malay = 'mkn';
    case Mingang_Doso = 'mko';
    case Moikodi = 'mkp';
    case Bay_Miwok = 'mkq';
    case Malas = 'mkr';
    case Silacayoapan_Mixtec = 'mks';
    case Vamale = 'mkt';
    case Konyanka_Maninka = 'mku';
    case Mafea = 'mkv';
    case Kituba_Congo = 'mkw';
    case Kinamiging_Manobo = 'mkx';
    case East_Makian = 'mky';
    case Makasae = 'mkz';
    case Malo = 'mla';
    case Mbule = 'mlb';
    case Cao_Lan = 'mlc';
    case Manambu = 'mle';
    case Mal = 'mlf';
    case Malagasy = 'mlg';
    case Mape = 'mlh';
    case Malimpung = 'mli';
    case Miltu = 'mlj';
    case Ilwana = 'mlk';
    case Malua_Bay = 'mll';
    case Mulam = 'mlm';
    case Malango = 'mln';
    case Mlomp = 'mlo';
    case Bargam = 'mlp';
    case Western_Maninkakan = 'mlq';
    case Vame = 'mlr';
    case Masalit = 'mls';
    case Maltese = 'mlt';
    case To_abaita = 'mlu';
    case Motlav = 'mlv';
    case Moloko = 'mlw';
    case Malfaxal = 'mlx';
    case Malaynon = 'mlz';
    case Mama = 'mma';
    case Momina = 'mmb';
    case Michoacan_Mazahua = 'mmc';
    case Maonan = 'mmd';
    case Mae = 'mme';
    case Mundat = 'mmf';
    case North_Ambrym = 'mmg';
    case Mehinaku = 'mmh';
    case Musar = 'mmi';
    case Majhwar = 'mmj';
    case Mukha_Dora = 'mmk';
    case Man_Met = 'mml';
    case Maii = 'mmm';
    case Mamanwa = 'mmn';
    case Mangga_Buang = 'mmo';
    case Siawi = 'mmp';
    case Musak = 'mmq';
    case Western_Xiangxi_Miao = 'mmr';
    case Malalamai = 'mmt';
    case Mmaala = 'mmu';
    case Miriti = 'mmv';
    case Emae = 'mmw';
    case Madak = 'mmx';
    case Migaama = 'mmy';
    case Mabaale = 'mmz';
    case Mbula = 'mna';
    case Muna = 'mnb';
    case Manchu = 'mnc';
    case Monde = 'mnd';
    case Naba = 'mne';
    case Mundani = 'mnf';
    case Eastern_Mnong = 'mng';
    case Mono_Democratic_Republic_of_Congo = 'mnh';
    case Manipuri = 'mni';
    case Munji = 'mnj';
    case Mandinka = 'mnk';
    case Tiale = 'mnl';
    case Mapena = 'mnm';
    case Southern_Mnong = 'mnn';
    case Min_Bei_Chinese = 'mnp';
    case Minriq = 'mnq';
    case Mono_USA = 'mnr';
    case Mansi = 'mns';
    case Mer = 'mnu';
    case Rennell_Bellona = 'mnv';
    case Mon = 'mnw';
    case Manikion = 'mnx';
    case Manyawa = 'mny';
    case Moni = 'mnz';
    case Mwan = 'moa';
    case Mocovi = 'moc';
    case Mobilian = 'mod';
    case Innu = 'moe';
    case Mongondow = 'mog';
    case Mohawk = 'moh';
    case Mboi = 'moi';
    case Monzombo = 'moj';
    case Morori = 'mok';
    case Mangue = 'mom';
    case Mongolian = 'mon';
    case Monom = 'moo';
    case Mopan_Maya = 'mop';
    case Mor_Bomberai_Peninsula = 'moq';
    case Moro = 'mor';
    case Mossi = 'mos';
    case Bari_2 = 'mot';
    case Mogum = 'mou';
    case Mohave = 'mov';
    case Moi_Congo = 'mow';
    case Molima = 'mox';
    case Shekkacho = 'moy';
    case Mukulu = 'moz';
    case Mpoto = 'mpa';
    case Malak_Malak = 'mpb';
    case Mangarrayi = 'mpc';
    case Machinere = 'mpd';
    case Majang = 'mpe';
    case Marba = 'mpg';
    case Maung = 'mph';
    case Mpade = 'mpi';
    case Martu_Wangka = 'mpj';
    case Mbara_Chad = 'mpk';
    case Middle_Watut = 'mpl';
    case Yosondua_Mixtec = 'mpm';
    case Mindiri = 'mpn';
    case Miu = 'mpo';
    case Migabac = 'mpp';
    case Matis = 'mpq';
    case Vangunu = 'mpr';
    case Dadibi = 'mps';
    case Mian = 'mpt';
    case Makurap = 'mpu';
    case Mungkip = 'mpv';
    case Mapidian = 'mpw';
    case Misima_Panaeati = 'mpx';
    case Mapia = 'mpy';
    case Mpi = 'mpz';
    case Maba_Indonesia = 'mqa';
    case Mbuko = 'mqb';
    case Mangole = 'mqc';
    case Matepi = 'mqe';
    case Momuna = 'mqf';
    case Kota_Bangun_Kutai_Malay = 'mqg';
    case Tlazoyaltepec_Mixtec = 'mqh';
    case Mariri = 'mqi';
    case Mamasa = 'mqj';
    case Rajah_Kabunsuwan_Manobo = 'mqk';
    case Mbelime = 'mql';
    case South_Marquesan = 'mqm';
    case Moronene = 'mqn';
    case Modole = 'mqo';
    case Manipa = 'mqp';
    case Minokok = 'mqq';
    case Mander = 'mqr';
    case West_Makian = 'mqs';
    case Mok = 'mqt';
    case Mandari = 'mqu';
    case Mosimo = 'mqv';
    case Murupi = 'mqw';
    case Mamuju = 'mqx';
    case Manggarai = 'mqy';
    case Pano = 'mqz';
    case Mlabri = 'mra';
    case Marino = 'mrb';
    case Maricopa = 'mrc';
    case Western_Magar = 'mrd';
    case Martha_s_Vineyard_Sign_Language = 'mre';
    case Elseng = 'mrf';
    case Mising = 'mrg';
    case Mara_Chin = 'mrh';
    case Maori = 'mri';
    case Western_Mari = 'mrj';
    case Hmwaveke = 'mrk';
    case Mortlockese = 'mrl';
    case Merlav = 'mrm';
    case Cheke_Holo = 'mrn';
    case Mru = 'mro';
    case Morouas = 'mrp';
    case North_Marquesan = 'mrq';
    case Maria_India = 'mrr';
    case Maragus = 'mrs';
    case Marghi_Central = 'mrt';
    case Mono_Cameroon = 'mru';
    case Mangareva = 'mrv';
    case Maranao = 'mrw';
    case Maremgi = 'mrx';
    case Mandaya = 'mry';
    case Marind = 'mrz';
    case Malay_macrolanguage = 'msa';
    case Masbatenyo = 'msb';
    case Sankaran_Maninka = 'msc';
    case Yucatec_Maya_Sign_Language = 'msd';
    case Musey = 'mse';
    case Mekwei = 'msf';
    case Moraid = 'msg';
    case Masikoro_Malagasy = 'msh';
    case Sabah_Malay = 'msi';
    case Ma_Democratic_Republic_of_Congo = 'msj';
    case Mansaka = 'msk';
    case Molof = 'msl';
    case Agusan_Manobo = 'msm';
    case Vures = 'msn';
    case Mombum = 'mso';
    case Maritsaua = 'msp';
    case Caac = 'msq';
    case Mongolian_Sign_Language = 'msr';
    case West_Masela = 'mss';
    case Musom = 'msu';
    case Maslam = 'msv';
    case Mansoanka = 'msw';
    case Moresada = 'msx';
    case Aruamu = 'msy';
    case Momare = 'msz';
    case Cotabato_Manobo = 'mta';
    case Anyin_Morofo = 'mtb';
    case Munit = 'mtc';
    case Mualang = 'mtd';
    case Mono_Solomon_Islands = 'mte';
    case Murik_Papua_New_Guinea = 'mtf';
    case Una = 'mtg';
    case Munggui = 'mth';
    case Maiwa_Papua_New_Guinea = 'mti';
    case Moskona = 'mtj';
    case Mbe_2 = 'mtk';
    case Montol = 'mtl';
    case Mator = 'mtm';
    case Matagalpa = 'mtn';
    case Totontepec_Mixe = 'mto';
    case Wichi_Lhamtes_Nocten = 'mtp';
    case Muong = 'mtq';
    case Mewari = 'mtr';
    case Yora = 'mts';
    case Mota = 'mtt';
    case Tututepec_Mixtec = 'mtu';
    case Asaro_o = 'mtv';
    case Southern_Binukidnon = 'mtw';
    case Tidaa_Mixtec = 'mtx';
    case Nabi = 'mty';
    case Mundang = 'mua';
    case Mubi = 'mub';
    case Ajumbu = 'muc';
    case Mednyj_Aleut = 'mud';
    case Media_Lengua = 'mue';
    case Musgu = 'mug';
    case Mundu = 'muh';
    case Musi = 'mui';
    case Mabire = 'muj';
    case Mugom = 'muk';
    case Multiple_languages = 'mul';
    case Maiwala = 'mum';
    case Nyong = 'muo';
    case Malvi = 'mup';
    case Eastern_Xiangxi_Miao = 'muq';
    case Murle = 'mur';
    case Creek = 'mus';
    case Western_Muria = 'mut';
    case Yaaku = 'muu';
    case Muthuvan = 'muv';
    case Bo_Ung = 'mux';
    case Muyang = 'muy';
    case Mursi = 'muz';
    case Manam = 'mva';
    case Mattole = 'mvb';
    case Mamboru = 'mvd';
    case Marwari_Pakistan = 'mve';
    case Peripheral_Mongolian = 'mvf';
    case Yucuane_Mixtec = 'mvg';
    case Mulgi = 'mvh';
    case Miyako = 'mvi';
    case Mekmek = 'mvk';
    case Mbara_Australia = 'mvl';
    case Minaveha = 'mvn';
    case Marovo = 'mvo';
    case Duri = 'mvp';
    case Moere = 'mvq';
    case Marau = 'mvr';
    case Massep = 'mvs';
    case Mpotovoro = 'mvt';
    case Marfa = 'mvu';
    case Tagal_Murut = 'mvv';
    case Machinga = 'mvw';
    case Meoswar = 'mvx';
    case Indus_Kohistani = 'mvy';
    case Mesqan = 'mvz';
    case Mwatebu = 'mwa';
    case Juwal = 'mwb';
    case Are = 'mwc';
    case Mwera_Chimwera = 'mwe';
    case Murrinh_Patha = 'mwf';
    case Aiklep = 'mwg';
    case Mouk_Aria = 'mwh';
    case Labo = 'mwi';
    case Kita_Maninkakan = 'mwk';
    case Mirandese = 'mwl';
    case Sar = 'mwm';
    case Nyamwanga = 'mwn';
    case Central_Maewo = 'mwo';
    case Kala_Lagaw_Ya = 'mwp';
    case Mun_Chin = 'mwq';
    case Marwari = 'mwr';
    case Mwimbi_Muthambi = 'mws';
    case Moken = 'mwt';
    case Mittu = 'mwu';
    case Mentawai = 'mwv';
    case Hmong_Daw = 'mww';
    case Moingi = 'mwz';
    case Northwest_Oaxaca_Mixtec = 'mxa';
    case Tezoatlan_Mixtec = 'mxb';
    case Manyika = 'mxc';
    case Modang = 'mxd';
    case Mele_Fila = 'mxe';
    case Malgbe = 'mxf';
    case Mbangala = 'mxg';
    case Mvuba = 'mxh';
    case Mozarabic = 'mxi';
    case Miju_Mishmi = 'mxj';
    case Monumbo = 'mxk';
    case Maxi_Gbe = 'mxl';
    case Meramera = 'mxm';
    case Moi_Indonesia = 'mxn';
    case Mbowe = 'mxo';
    case Tlahuitoltepec_Mixe = 'mxp';
    case Juquila_Mixe = 'mxq';
    case Murik_Malaysia = 'mxr';
    case Huitepec_Mixtec = 'mxs';
    case Jamiltepec_Mixtec = 'mxt';
    case Mada_Cameroon = 'mxu';
    case Metlatonoc_Mixtec = 'mxv';
    case Namo = 'mxw';
    case Mahou = 'mxx';
    case Southeastern_Nochixtlan_Mixtec = 'mxy';
    case Central_Masela = 'mxz';
    case Burmese = 'mya';
    case Mbay = 'myb';
    case Mayeka = 'myc';
    case Myene = 'mye';
    case Bambassi = 'myf';
    case Manta = 'myg';
    case Makah = 'myh';
    case Mangayat = 'myj';
    case Mamara_Senoufo = 'myk';
    case Moma = 'myl';
    case Me_en = 'mym';
    case Anfillo = 'myo';
    case Piraha = 'myp';
    case Muniche = 'myr';
    case Mesmes = 'mys';
    case Munduruku = 'myu';
    case Erzya = 'myv';
    case Muyuw = 'myw';
    case Masaaba = 'myx';
    case Macuna = 'myy';
    case Classical_Mandaic = 'myz';
    case Santa_Maria_Zacatepec_Mixtec = 'mza';
    case Tumzabt = 'mzb';
    case Madagascar_Sign_Language = 'mzc';
    case Malimba = 'mzd';
    case Morawa = 'mze';
    case Monastic_Sign_Language = 'mzg';
    case Wichi_Lhamtes_Guisnay = 'mzh';
    case Ixcatlan_Mazatec = 'mzi';
    case Manya = 'mzj';
    case Nigeria_Mambila = 'mzk';
    case Mazatlan_Mixe = 'mzl';
    case Mumuye = 'mzm';
    case Mazanderani = 'mzn';
    case Matipuhy = 'mzo';
    case Movima = 'mzp';
    case Mori_Atas = 'mzq';
    case Marubo = 'mzr';
    case Macanese = 'mzs';
    case Mintil = 'mzt';
    case Inapang = 'mzu';
    case Manza = 'mzv';
    case Deg = 'mzw';
    case Mawayana = 'mzx';
    case Mozambican_Sign_Language = 'mzy';
    case Maiadomu = 'mzz';
    case Namla = 'naa';
    case Southern_Nambikuara = 'nab';
    case Narak = 'nac';
    case Naka_ela = 'nae';
    case Nabak = 'naf';
    case Naga_Pidgin = 'nag';
    case Nalu = 'naj';
    case Nakanai = 'nak';
    case Nalik = 'nal';
    case Ngan_gityemerri = 'nam';
    case Min_Nan_Chinese = 'nan';
    case Naaba = 'nao';
    case Neapolitan = 'nap';
    case Khoekhoe = 'naq';
    case Iguta = 'nar';
    case Naasioi = 'nas';
    case Cahungwarya = 'nat';
    case Nauru = 'nau';
    case Navajo = 'nav';
    case Nawuri = 'naw';
    case Nakwi = 'nax';
    case Ngarrindjeri = 'nay';
    case Coatepec_Nahuatl = 'naz';
    case Nyemba = 'nba';
    case Ndoe = 'nbb';
    case Chang_Naga = 'nbc';
    case Ngbinda = 'nbd';
    case Konyak_Naga = 'nbe';
    case Nagarchal = 'nbg';
    case Ngamo = 'nbh';
    case Mao_Naga = 'nbi';
    case Ngarinyman = 'nbj';
    case Nake = 'nbk';
    case South_Ndebele = 'nbl';
    case Ngbaka_Ma_bo = 'nbm';
    case Kuri = 'nbn';
    case Nkukoli = 'nbo';
    case Nnam = 'nbp';
    case Nggem = 'nbq';
    case Numana = 'nbr';
    case Namibian_Sign_Language = 'nbs';
    case Na = 'nbt';
    case Rongmei_Naga = 'nbu';
    case Ngamambo = 'nbv';
    case Southern_Ngbandi = 'nbw';
    case Ningera = 'nby';
    case Iyo = 'nca';
    case Central_Nicobarese = 'ncb';
    case Ponam = 'ncc';
    case Nachering = 'ncd';
    case Yale = 'nce';
    case Notsi = 'ncf';
    case Nisga_a = 'ncg';
    case Central_Huasteca_Nahuatl = 'nch';
    case Classical_Nahuatl = 'nci';
    case Northern_Puebla_Nahuatl = 'ncj';
    case Na_kara = 'nck';
    case Michoacan_Nahuatl = 'ncl';
    case Nambo = 'ncm';
    case Nauna = 'ncn';
    case Sibe = 'nco';
    case Northern_Katang = 'ncq';
    case Ncane = 'ncr';
    case Nicaraguan_Sign_Language = 'ncs';
    case Chothe_Naga = 'nct';
    case Chumburung = 'ncu';
    case Central_Puebla_Nahuatl = 'ncx';
    case Natchez = 'ncz';
    case Ndasa = 'nda';
    case Kenswei_Nsei = 'ndb';
    case Ndau = 'ndc';
    case Nde_Nsele_Nta = 'ndd';
    case North_Ndebele = 'nde';
    case Nadruvian = 'ndf';
    case Ndengereko = 'ndg';
    case Ndali = 'ndh';
    case Samba_Leko = 'ndi';
    case Ndamba = 'ndj';
    case Ndaka = 'ndk';
    case Ndolo = 'ndl';
    case Ndam = 'ndm';
    case Ngundi = 'ndn';
    case Ndonga = 'ndo';
    case Ndo = 'ndp';
    case Ndombe = 'ndq';
    case Ndoola = 'ndr';
    case Low_German = 'nds';
    case Ndunga = 'ndt';
    case Dugun = 'ndu';
    case Ndut = 'ndv';
    case Ndobo = 'ndw';
    case Nduga = 'ndx';
    case Lutos = 'ndy';
    case Ndogo = 'ndz';
    case Eastern_Ngad_a = 'nea';
    case Toura_Cote_d_Ivoire = 'neb';
    case Nedebang = 'nec';
    case Nde_Gbite = 'ned';
    case Nelemwa_Nixumwak = 'nee';
    case Nefamese = 'nef';
    case Negidal = 'neg';
    case Nyenkha = 'neh';
    case Neo_Hittite = 'nei';
    case Neko = 'nej';
    case Neku = 'nek';
    case Nemi = 'nem';
    case Nengone = 'nen';
    case Na_Meo = 'neo';
    case Nepali_macrolanguage = 'nep';
    case North_Central_Mixe = 'neq';
    case Yahadian = 'ner';
    case Bhoti_Kinnauri = 'nes';
    case Nete = 'net';
    case Neo = 'neu';
    case Nyaheun = 'nev';
    case Newari = 'new';
    case Neme = 'nex';
    case Neyo = 'ney';
    case Nez_Perce = 'nez';
    case Dhao = 'nfa';
    case Ahwai = 'nfd';
    case Ayiwo = 'nfl';
    case Nafaanra = 'nfr';
    case Mfumte = 'nfu';
    case Ngbaka = 'nga';
    case Northern_Ngbandi = 'ngb';
    case Ngombe_Democratic_Republic_of_Congo = 'ngc';
    case Ngando_Central_African_Republic = 'ngd';
    case Ngemba = 'nge';
    case Ngbaka_Manza = 'ngg';
    case N_ng = 'ngh';
    case Ngizim = 'ngi';
    case Ngie = 'ngj';
    case Dalabon = 'ngk';
    case Lomwe = 'ngl';
    case Ngatik_Men_s_Creole = 'ngm';
    case Ngwo = 'ngn';
    case Ngulu = 'ngp';
    case Ngurimi = 'ngq';
    case Engdewu = 'ngr';
    case Gvoko = 'ngs';
    case Kriang = 'ngt';
    case Guerrero_Nahuatl = 'ngu';
    case Nagumi = 'ngv';
    case Ngwaba = 'ngw';
    case Nggwahyi = 'ngx';
    case Tibea = 'ngy';
    case Ngungwel = 'ngz';
    case Nhanda = 'nha';
    case Beng = 'nhb';
    case Tabasco_Nahuatl = 'nhc';
    case Chiripa = 'nhd';
    case Eastern_Huasteca_Nahuatl = 'nhe';
    case Nhuwala = 'nhf';
    case Tetelcingo_Nahuatl = 'nhg';
    case Nahari = 'nhh';
    case Zacatlan_Ahuacatlan_Tepetzintla_Nahuatl = 'nhi';
    case Isthmus_Cosoleacaque_Nahuatl = 'nhk';
    case Morelos_Nahuatl = 'nhm';
    case Central_Nahuatl = 'nhn';
    case Takuu = 'nho';
    case Isthmus_Pajapan_Nahuatl = 'nhp';
    case Huaxcaleca_Nahuatl = 'nhq';
    case Naro = 'nhr';
    case Ometepec_Nahuatl = 'nht';
    case Noone = 'nhu';
    case Temascaltepec_Nahuatl = 'nhv';
    case Western_Huasteca_Nahuatl = 'nhw';
    case Isthmus_Mecayapan_Nahuatl = 'nhx';
    case Northern_Oaxaca_Nahuatl = 'nhy';
    case Santa_Maria_La_Alta_Nahuatl = 'nhz';
    case Nias = 'nia';
    case Nakame = 'nib';
    case Ngandi = 'nid';
    case Niellim = 'nie';
    case Nek = 'nif';
    case Ngalakgan = 'nig';
    case Nyiha_Tanzania = 'nih';
    case Nii = 'nii';
    case Ngaju = 'nij';
    case Southern_Nicobarese = 'nik';
    case Nila = 'nil';
    case Nilamba = 'nim';
    case Ninzo = 'nin';
    case Nganasan = 'nio';
    case Nandi = 'niq';
    case Nimboran = 'nir';
    case Nimi = 'nis';
    case Southeastern_Kolami = 'nit';
    case Niuean = 'niu';
    case Gilyak = 'niv';
    case Nimo = 'niw';
    case Hema = 'nix';
    case Ngiti = 'niy';
    case Ningil = 'niz';
    case Nzanyi = 'nja';
    case Nocte_Naga = 'njb';
    case Ndonde_Hamba = 'njd';
    case Lotha_Naga = 'njh';
    case Gudanji = 'nji';
    case Njen = 'njj';
    case Njalgulgule = 'njl';
    case Angami_Naga = 'njm';
    case Liangmai_Naga = 'njn';
    case Ao_Naga = 'njo';
    case Njerep = 'njr';
    case Nisa = 'njs';
    case Ndyuka_Trio_Pidgin = 'njt';
    case Ngadjunmaya = 'nju';
    case Kunyi = 'njx';
    case Njyem = 'njy';
    case Nyishi = 'njz';
    case Nkoya = 'nka';
    case Khoibu_Naga = 'nkb';
    case Nkongho = 'nkc';
    case Koireng = 'nkd';
    case Duke = 'nke';
    case Inpui_Naga = 'nkf';
    case Nekgini = 'nkg';
    case Khezha_Naga = 'nkh';
    case Thangal_Naga = 'nki';
    case Nakai = 'nkj';
    case Nokuku = 'nkk';
    case Namat = 'nkm';
    case Nkangala = 'nkn';
    case Nkonya = 'nko';
    case Niuatoputapu = 'nkp';
    case Nkami = 'nkq';
    case Nukuoro = 'nkr';
    case North_Asmat = 'nks';
    case Nyika_Tanzania = 'nkt';
    case Bouna_Kulango = 'nku';
    case Nyika_Malawi_and_Zambia = 'nkv';
    case Nkutu = 'nkw';
    case Nkoroo = 'nkx';
    case Nkari = 'nkz';
    case Ngombale = 'nla';
    case Nalca = 'nlc';
    case Dutch = 'nld';
    case East_Nyala = 'nle';
    case Gela = 'nlg';
    case Grangali = 'nli';
    case Nyali = 'nlj';
    case Ninia_Yali = 'nlk';
    case Nihali = 'nll';
    case Mankiyali = 'nlm';
    case Ngul = 'nlo';
    case Lao_Naga = 'nlq';
    case Nchumbulu = 'nlu';
    case Orizaba_Nahuatl = 'nlv';
    case Walangama = 'nlw';
    case Nahali = 'nlx';
    case Nyamal = 'nly';
    case Nalogo = 'nlz';
    case Maram_Naga = 'nma';
    case Big_Nambas = 'nmb';
    case Ngam = 'nmc';
    case Ndumu = 'nmd';
    case Mzieme_Naga = 'nme';
    case Tangkhul_Naga_India = 'nmf';
    case Kwasio = 'nmg';
    case Monsang_Naga = 'nmh';
    case Nyam = 'nmi';
    case Ngombe_Central_African_Republic = 'nmj';
    case Namakura = 'nmk';
    case Ndemli = 'nml';
    case Manangba = 'nmm';
    case Xoo = 'nmn';
    case Moyon_Naga = 'nmo';
    case Nimanbur = 'nmp';
    case Nambya = 'nmq';
    case Nimbari = 'nmr';
    case Letemboi = 'nms';
    case Namonuito = 'nmt';
    case Northeast_Maidu = 'nmu';
    case Ngamini = 'nmv';
    case Nimoa = 'nmw';
    case Nama_Papua_New_Guinea = 'nmx';
    case Namuyi = 'nmy';
    case Nawdm = 'nmz';
    case Nyangumarta = 'nna';
    case Nande = 'nnb';
    case Nancere = 'nnc';
    case West_Ambae = 'nnd';
    case Ngandyera = 'nne';
    case Ngaing = 'nnf';
    case Maring_Naga = 'nng';
    case Ngiemboon = 'nnh';
    case North_Nuaulu = 'nni';
    case Nyangatom = 'nnj';
    case Nankina = 'nnk';
    case Northern_Rengma_Naga = 'nnl';
    case Namia = 'nnm';
    case Ngete = 'nnn';
    case Norwegian_Nynorsk = 'nno';
    case Wancho_Naga = 'nnp';
    case Ngindo = 'nnq';
    case Narungga = 'nnr';
    case Nanticoke = 'nnt';
    case Dwang = 'nnu';
    case Nugunu_Australia = 'nnv';
    case Southern_Nuni = 'nnw';
    case Nyangga = 'nny';
    case Nda_nda = 'nnz';
    case Woun_Meu = 'noa';
    case Norwegian_Bokmal = 'nob';
    case Nuk = 'noc';
    case Northern_Thai = 'nod';
    case Nimadi = 'noe';
    case Nomane = 'nof';
    case Nogai = 'nog';
    case Nomu = 'noh';
    case Noiri = 'noi';
    case Nonuya = 'noj';
    case Nooksack = 'nok';
    case Nomlaki = 'nol';
    case Old_Norse = 'non';
    case Numanggang = 'nop';
    case Ngongo = 'noq';
    case Norwegian = 'nor';
    case Eastern_Nisu = 'nos';
    case Nomatsiguenga = 'not';
    case Ewage_Notu = 'nou';
    case Novial = 'nov';
    case Nyambo = 'now';
    case Noy = 'noy';
    case Nayi = 'noz';
    case Nar_Phu = 'npa';
    case Nupbikha = 'npb';
    case Ponyo_Gongwang_Naga = 'npg';
    case Phom_Naga = 'nph';
    case Nepali_individual_language = 'npi';
    case Southeastern_Puebla_Nahuatl = 'npl';
    case Mondropolon = 'npn';
    case Pochuri_Naga = 'npo';
    case Nipsan = 'nps';
    case Puimei_Naga = 'npu';
    case Noipx = 'npx';
    case Napu = 'npy';
    case Southern_Nago = 'nqg';
    case Kura_Ede_Nago = 'nqk';
    case Ngendelengo = 'nql';
    case Ndom = 'nqm';
    case Nen = 'nqn';
    case N_Ko = 'nqo';
    case Kyan_Karyaw_Naga = 'nqq';
    case Nteng = 'nqt';
    case Akyaung_Ari_Naga = 'nqy';
    case Ngom = 'nra';
    case Nara = 'nrb';
    case Noric = 'nrc';
    case Southern_Rengma_Naga = 'nre';
    case Jerriais = 'nrf';
    case Narango = 'nrg';
    case Chokri_Naga = 'nri';
    case Ngarla = 'nrk';
    case Ngarluma = 'nrl';
    case Narom = 'nrm';
    case Norn = 'nrn';
    case North_Picene = 'nrp';
    case Norra = 'nrr';
    case Northern_Kalapuya = 'nrt';
    case Narua = 'nru';
    case Ngurmbur = 'nrx';
    case Lala = 'nrz';
    case Sangtam_Naga = 'nsa';
    case Lower_Nossob = 'nsb';
    case Nshi = 'nsc';
    case Southern_Nisu = 'nsd';
    case Nsenga = 'nse';
    case Northwestern_Nisu = 'nsf';
    case Ngasa = 'nsg';
    case Ngoshie = 'nsh';
    case Nigerian_Sign_Language = 'nsi';
    case Naskapi = 'nsk';
    case Norwegian_Sign_Language = 'nsl';
    case Sumi_Naga = 'nsm';
    case Nehan = 'nsn';
    case Pedi = 'nso';
    case Nepalese_Sign_Language = 'nsp';
    case Northern_Sierra_Miwok = 'nsq';
    case Maritime_Sign_Language = 'nsr';
    case Nali = 'nss';
    case Tase_Naga = 'nst';
    case Sierra_Negra_Nahuatl = 'nsu';
    case Southwestern_Nisu = 'nsv';
    case Navut = 'nsw';
    case Nsongo = 'nsx';
    case Nasal = 'nsy';
    case Nisenan = 'nsz';
    case Northern_Tidung = 'ntd';
    case Ngantangarra = 'ntg';
    case Natioro = 'nti';
    case Ngaanyatjarra = 'ntj';
    case Ikoma_Nata_Isenye = 'ntk';
    case Nateni = 'ntm';
    case Ntomba = 'nto';
    case Northern_Tepehuan = 'ntp';
    case Delo = 'ntr';
    case Natugu = 'ntu';
    case Nottoway = 'ntw';
    case Tangkhul_Naga_Myanmar = 'ntx';
    case Mantsi = 'nty';
    case Natanzi = 'ntz';
    case Yuanga = 'nua';
    case Nukuini = 'nuc';
    case Ngala = 'nud';
    case Ngundu = 'nue';
    case Nusu = 'nuf';
    case Nungali = 'nug';
    case Ndunda = 'nuh';
    case Ngumbi = 'nui';
    case Nyole = 'nuj';
    case Nuu_chah_nulth = 'nuk';
    case Nusa_Laut = 'nul';
    case Niuafo_ou = 'num';
    case Anong = 'nun';
    case Nguon = 'nuo';
    case Nupe_Nupe_Tako = 'nup';
    case Nukumanu = 'nuq';
    case Nukuria = 'nur';
    case Nuer = 'nus';
    case Nung_Viet_Nam = 'nut';
    case Ngbundu = 'nuu';
    case Northern_Nuni = 'nuv';
    case Nguluwan = 'nuw';
    case Mehek = 'nux';
    case Nunggubuyu = 'nuy';
    case Tlamacazapa_Nahuatl = 'nuz';
    case Nasarian = 'nvh';
    case Namiae = 'nvm';
    case Nyokon = 'nvo';
    case Nawathinehena = 'nwa';
    case Nyabwa = 'nwb';
    case Classical_Newari = 'nwc';
    case Ngwe = 'nwe';
    case Ngayawung = 'nwg';
    case Southwest_Tanna = 'nwi';
    case Nyamusa_Molo = 'nwm';
    case Nauo = 'nwo';
    case Nawaru = 'nwr';
    case Ndwewe = 'nww';
    case Middle_Newar = 'nwx';
    case Nottoway_Meherrin = 'nwy';
    case Nauete = 'nxa';
    case Ngando_Democratic_Republic_of_Congo = 'nxd';
    case Nage = 'nxe';
    case Ngad_a = 'nxg';
    case Nindi = 'nxi';
    case Koki_Naga = 'nxk';
    case South_Nuaulu = 'nxl';
    case Numidian = 'nxm';
    case Ngawun = 'nxn';
    case Ndambomo = 'nxo';
    case Naxi = 'nxq';
    case Ninggerum = 'nxr';
    case Nafri = 'nxx';
    case Nyanja = 'nya';
    case Nyangbo = 'nyb';
    case Nyanga_li = 'nyc';
    case Nyore = 'nyd';
    case Nyengo = 'nye';
    case Giryama = 'nyf';
    case Nyindu = 'nyg';
    case Nyikina = 'nyh';
    case Ama_Sudan = 'nyi';
    case Nyanga = 'nyj';
    case Nyaneka = 'nyk';
    case Nyeu = 'nyl';
    case Nyamwezi = 'nym';
    case Nyankole = 'nyn';
    case Nyoro = 'nyo';
    case Nyang_i = 'nyp';
    case Nayini = 'nyq';
    case Nyiha_Malawi = 'nyr';
    case Nyungar = 'nys';
    case Nyawaygi = 'nyt';
    case Nyungwe = 'nyu';
    case Nyulnyul = 'nyv';
    case Nyaw = 'nyw';
    case Nganyaywana = 'nyx';
    case Nyakyusa_Ngonde = 'nyy';
    case Tigon_Mbembe = 'nza';
    case Njebi = 'nzb';
    case Nzadi = 'nzd';
    case Nzima = 'nzi';
    case Nzakara = 'nzk';
    case Zeme_Naga = 'nzm';
    case Dir_Nyamzak_Mbarimi = 'nzr';
    case New_Zealand_Sign_Language = 'nzs';
    case Teke_Nzikou = 'nzu';
    case Nzakambay = 'nzy';
    case Nanga_Dama_Dogon = 'nzz';
    case Orok = 'oaa';
    case Oroch = 'oac';
    case Noakhali = 'oak';
    case Old_Aramaic_up_to_700_BCE = 'oar';
    case Old_Avar = 'oav';
    case Obispeno = 'obi';
    case Southern_Bontok = 'obk';
    case Oblo = 'obl';
    case Moabite = 'obm';
    case Obo_Manobo = 'obo';
    case Old_Burmese = 'obr';
    case Old_Breton = 'obt';
    case Obulom = 'obu';
    case Ocaina = 'oca';
    case Old_Chinese = 'och';
    case Occitan_post_1500 = 'oci';
    case Old_Cham = 'ocm';
    case Old_Cornish = 'oco';
    case Atzingo_Matlatzinca = 'ocu';
    case Odut = 'oda';
    case Od = 'odk';
    case Old_Dutch = 'odt';
    case Odual = 'odu';
    case Ofo = 'ofo';
    case Old_Frisian = 'ofs';
    case Efutop = 'ofu';
    case Ogbia = 'ogb';
    case Ogbah = 'ogc';
    case Old_Georgian = 'oge';
    case Ogbogolo = 'ogg';
    case Khana = 'ogo';
    case Ogbronuagum = 'ogu';
    case Old_Hittite = 'oht';
    case Old_Hungarian = 'ohu';
    case Oirata = 'oia';
    case Okolie = 'oie';
    case Inebu_One = 'oin';
    case Northwestern_Ojibwa = 'ojb';
    case Central_Ojibwa = 'ojc';
    case Eastern_Ojibwa = 'ojg';
    case Ojibwa = 'oji';
    case Old_Japanese = 'ojp';
    case Severn_Ojibwa = 'ojs';
    case Ontong_Java = 'ojv';
    case Western_Ojibwa = 'ojw';
    case Okanagan = 'oka';
    case Okobo = 'okb';
    case Kobo = 'okc';
    case Okodia = 'okd';
    case Okpe_Southwestern_Edo = 'oke';
    case Koko_Babangk = 'okg';
    case Koresh_e_Rostam = 'okh';
    case Okiek = 'oki';
    case Oko_Juwoi = 'okj';
    case Kwamtim_One = 'okk';
    case Old_Kentish_Sign_Language = 'okl';
    case Middle_Korean_10th_16th_cent = 'okm';
    case Oki_No_Erabu = 'okn';
    case Old_Korean_3rd_9th_cent = 'oko';
    case Kirike = 'okr';
    case Oko_Eni_Osayen = 'oks';
    case Oku = 'oku';
    case Orokaiva = 'okv';
    case Okpe_Northwestern_Edo = 'okx';
    case Old_Khmer = 'okz';
    case Walungge = 'ola';
    case Mochi = 'old';
    case Olekha = 'ole';
    case Olkol = 'olk';
    case Oloma = 'olm';
    case Livvi = 'olo';
    case Olrat = 'olr';
    case Old_Lithuanian = 'olt';
    case Kuvale = 'olu';
    case Omaha_Ponca = 'oma';
    case East_Ambae = 'omb';
    case Mochica = 'omc';
    case Omagua = 'omg';
    case Omi = 'omi';
    case Omok = 'omk';
    case Ombo = 'oml';
    case Minoan = 'omn';
    case Utarmbung = 'omo';
    case Old_Manipuri = 'omp';
    case Old_Marathi = 'omr';
    case Omotik = 'omt';
    case Omurano = 'omu';
    case South_Tairora = 'omw';
    case Old_Mon = 'omx';
    case Old_Malay = 'omy';
    case Ona = 'ona';
    case Lingao = 'onb';
    case Oneida = 'one';
    case Olo = 'ong';
    case Onin = 'oni';
    case Onjob = 'onj';
    case Kabore_One = 'onk';
    case Onobasulu = 'onn';
    case Onondaga = 'ono';
    case Sartang = 'onp';
    case Northern_One = 'onr';
    case Ono = 'ons';
    case Ontenu = 'ont';
    case Unua = 'onu';
    case Old_Nubian = 'onw';
    case Onin_Based_Pidgin = 'onx';
    case Tohono_O_odham = 'ood';
    case Ong = 'oog';
    case Onge = 'oon';
    case Oorlams = 'oor';
    case Old_Ossetic = 'oos';
    case Okpamheri = 'opa';
    case Kopkaka = 'opk';
    case Oksapmin = 'opm';
    case Opao = 'opo';
    case Opata = 'opt';
    case Ofaye = 'opy';
    case Oroha = 'ora';
    case Orma = 'orc';
    case Orejon = 'ore';
    case Oring = 'org';
    case Oroqen = 'orh';
    case Oriya_macrolanguage = 'ori';
    case Oromo = 'orm';
    case Orang_Kanaq = 'orn';
    case Orokolo = 'oro';
    case Oruma = 'orr';
    case Orang_Seletar = 'ors';
    case Adivasi_Oriya = 'ort';
    case Ormuri = 'oru';
    case Old_Russian = 'orv';
    case Oro_Win = 'orw';
    case Oro = 'orx';
    case Odia = 'ory';
    case Ormu = 'orz';
    case Osage = 'osa';
    case Oscan = 'osc';
    case Osing = 'osi';
    case Old_Sundanese = 'osn';
    case Ososo = 'oso';
    case Old_Spanish = 'osp';
    case Ossetian = 'oss';
    case Osatu = 'ost';
    case Southern_One = 'osu';
    case Old_Saxon = 'osx';
    case Ottoman_Turkish_1500_1928 = 'ota';
    case Old_Tibetan = 'otb';
    case Ot_Danum = 'otd';
    case Mezquital_Otomi = 'ote';
    case Oti = 'oti';
    case Old_Turkish = 'otk';
    case Tilapa_Otomi = 'otl';
    case Eastern_Highland_Otomi = 'otm';
    case Tenango_Otomi = 'otn';
    case Queretaro_Otomi = 'otq';
    case Otoro = 'otr';
    case Estado_de_Mexico_Otomi = 'ots';
    case Temoaya_Otomi = 'ott';
    case Otuke = 'otu';
    case Ottawa = 'otw';
    case Texcatepec_Otomi = 'otx';
    case Old_Tamil = 'oty';
    case Ixtenco_Otomi = 'otz';
    case Tagargrent = 'oua';
    case Glio_Oubi = 'oub';
    case Oune = 'oue';
    case Old_Uighur = 'oui';
    case Ouma = 'oum';
    case Elfdalian = 'ovd';
    case Owiniga = 'owi';
    case Old_Welsh = 'owl';
    case Oy = 'oyb';
    case Oyda = 'oyd';
    case Wayampi = 'oym';
    case Oya_oya = 'oyy';
    case Koonzime = 'ozm';
    case Parecis = 'pab';
    case Pacoh = 'pac';
    case Paumari = 'pad';
    case Pagibete = 'pae';
    case Paranawat = 'paf';
    case Pangasinan = 'pag';
    case Tenharim = 'pah';
    case Pe = 'pai';
    case Parakana = 'pak';
    case Pahlavi = 'pal';
    case Pampanga = 'pam';
    case Panjabi = 'pan';
    case Northern_Paiute = 'pao';
    case Papiamento = 'pap';
    case Parya = 'paq';
    case Panamint = 'par';
    case Papasena = 'pas';
    case Palauan = 'pau';
    case Pakaasnovos = 'pav';
    case Pawnee = 'paw';
    case Pankarare = 'pax';
    case Pech = 'pay';
    case Pankararu = 'paz';
    case Paez = 'pbb';
    case Patamona = 'pbc';
    case Mezontla_Popoloca = 'pbe';
    case Coyotepec_Popoloca = 'pbf';
    case Paraujano = 'pbg';
    case E_napa_Woromaipu = 'pbh';
    case Parkwa = 'pbi';
    case Mak_Nigeria = 'pbl';
    case Puebla_Mazatec = 'pbm';
    case Kpasam = 'pbn';
    case Papel = 'pbo';
    case Badyara = 'pbp';
    case Pangwa = 'pbr';
    case Central_Pame = 'pbs';
    case Southern_Pashto = 'pbt';
    case Northern_Pashto = 'pbu';
    case Pnar = 'pbv';
    case Pyu_Papua_New_Guinea = 'pby';
    case Santa_Ines_Ahuatempan_Popoloca = 'pca';
    case Pear = 'pcb';
    case Bouyei = 'pcc';
    case Picard = 'pcd';
    case Ruching_Palaung = 'pce';
    case Paliyan = 'pcf';
    case Paniya = 'pcg';
    case Pardhan = 'pch';
    case Duruwa = 'pci';
    case Parenga = 'pcj';
    case Paite_Chin = 'pck';
    case Pardhi = 'pcl';
    case Nigerian_Pidgin = 'pcm';
    case Piti = 'pcn';
    case Pacahuara = 'pcp';
    case Pyapun = 'pcw';
    case Anam = 'pda';
    case Pennsylvania_German = 'pdc';
    case Pa_Di = 'pdi';
    case Podena = 'pdn';
    case Padoe = 'pdo';
    case Plautdietsch = 'pdt';
    case Kayan = 'pdu';
    case Peranakan_Indonesian = 'pea';
    case Eastern_Pomo = 'peb';
    case Mala_Papua_New_Guinea = 'ped';
    case Taje = 'pee';
    case Northeastern_Pomo = 'pef';
    case Pengo = 'peg';
    case Bonan = 'peh';
    case Chichimeca_Jonaz = 'pei';
    case Northern_Pomo = 'pej';
    case Penchal = 'pek';
    case Pekal = 'pel';
    case Phende = 'pem';
    case Old_Persian_ca_600_400_B_C = 'peo';
    case Kunja = 'pep';
    case Southern_Pomo = 'peq';
    case Iranian_Persian = 'pes';
    case Pemono = 'pev';
    case Petats = 'pex';
    case Petjo = 'pey';
    case Eastern_Penan = 'pez';
    case Paafang = 'pfa';
    case Pere = 'pfe';
    case Pfaelzisch = 'pfl';
    case Sudanese_Creole_Arabic = 'pga';
    case Gandhari = 'pgd';
    case Pangwali = 'pgg';
    case Pagi = 'pgi';
    case Rerep = 'pgk';
    case Primitive_Irish = 'pgl';
    case Paelignian = 'pgn';
    case Pangseng = 'pgs';
    case Pagu = 'pgu';
    case Papua_New_Guinean_Sign_Language = 'pgz';
    case Pa_Hng = 'pha';
    case Phudagi = 'phd';
    case Phuong = 'phg';
    case Phukha = 'phh';
    case Pahari = 'phj';
    case Phake = 'phk';
    case Phalura = 'phl';
    case Phimbi = 'phm';
    case Phoenician = 'phn';
    case Phunoi = 'pho';
    case Phana = 'phq';
    case Pahari_Potwari = 'phr';
    case Phu_Thai = 'pht';
    case Phuan = 'phu';
    case Pahlavani = 'phv';
    case Phangduwali = 'phw';
    case Pima_Bajo = 'pia';
    case Yine = 'pib';
    case Pinji = 'pic';
    case Piaroa = 'pid';
    case Piro = 'pie';
    case Pingelapese = 'pif';
    case Pisabo = 'pig';
    case Pitcairn_Norfolk = 'pih';
    case Pijao = 'pij';
    case Yom = 'pil';
    case Powhatan = 'pim';
    case Piame = 'pin';
    case Piapoco = 'pio';
    case Pero = 'pip';
    case Piratapuyo = 'pir';
    case Pijin = 'pis';
    case Pitta_Pitta = 'pit';
    case Pintupi_Luritja = 'piu';
    case Pileni = 'piv';
    case Pimbwe = 'piw';
    case Piu = 'pix';
    case Piya_Kwonci = 'piy';
    case Pije = 'piz';
    case Pitjantjatjara = 'pjt';
    case Ardhamagadhi_Prakrit = 'pka';
    case Pokomo = 'pkb';
    case Paekche = 'pkc';
    case Pak_Tong = 'pkg';
    case Pankhu = 'pkh';
    case Pakanha = 'pkn';
    case Pokoot = 'pko';
    case Pukapuka = 'pkp';
    case Attapady_Kurumba = 'pkr';
    case Pakistan_Sign_Language = 'pks';
    case Maleng = 'pkt';
    case Paku = 'pku';
    case Miani = 'pla';
    case Polonombauk = 'plb';
    case Central_Palawano = 'plc';
    case Polari = 'pld';
    case Palu_e = 'ple';
    case Pilaga = 'plg';
    case Paulohi = 'plh';
    case Pali = 'pli';
    case Kohistani_Shina = 'plk';
    case Shwe_Palaung = 'pll';
    case Palenquero = 'pln';
    case Oluta_Popoluca = 'plo';
    case Palaic = 'plq';
    case Palaka_Senoufo = 'plr';
    case San_Marcos_Tlacoyalco_Popoloca = 'pls';
    case Plateau_Malagasy = 'plt';
    case Palikur = 'plu';
    case Southwest_Palawano = 'plv';
    case Brooke_s_Point_Palawano = 'plw';
    case Bolyu = 'ply';
    case Paluan = 'plz';
    case Paama = 'pma';
    case Pambia = 'pmb';
    case Pallanganmiddang = 'pmd';
    case Pwaamei = 'pme';
    case Pamona = 'pmf';
    case Maharastri_Prakrit = 'pmh';
    case Northern_Pumi = 'pmi';
    case Southern_Pumi = 'pmj';
    case Lingua_Franca = 'pml';
    case Pomo = 'pmm';
    case Pam = 'pmn';
    case Pom = 'pmo';
    case Northern_Pame = 'pmq';
    case Paynamar = 'pmr';
    case Piemontese = 'pms';
    case Tuamotuan = 'pmt';
    case Plains_Miwok = 'pmw';
    case Poumei_Naga = 'pmx';
    case Papuan_Malay = 'pmy';
    case Southern_Pame = 'pmz';
    case Punan_Bah_Biau = 'pna';
    case Western_Panjabi = 'pnb';
    case Pannei = 'pnc';
    case Mpinda = 'pnd';
    case Western_Penan = 'pne';
    case Pangu = 'png';
    case Penrhyn = 'pnh';
    case Aoheng = 'pni';
    case Pinjarup = 'pnj';
    case Paunaka = 'pnk';
    case Paleni = 'pnl';
    case Punan_Batu_1 = 'pnm';
    case Pinai_Hagahai = 'pnn';
    case Panobo = 'pno';
    case Pancana = 'pnp';
    case Pana_Burkina_Faso = 'pnq';
    case Panim = 'pnr';
    case Ponosakan = 'pns';
    case Pontic = 'pnt';
    case Jiongnai_Bunu = 'pnu';
    case Pinigura = 'pnv';
    case Banyjima = 'pnw';
    case Phong_Kniang = 'pnx';
    case Pinyin = 'pny';
    case Pana_Central_African_Republic = 'pnz';
    case Poqomam = 'poc';
    case San_Juan_Atzingo_Popoloca = 'poe';
    case Poke = 'pof';
    case Potiguara = 'pog';
    case Poqomchi = 'poh';
    case Highland_Popoluca = 'poi';
    case Pokanga = 'pok';
    case Polish = 'pol';
    case Southeastern_Pomo = 'pom';
    case Pohnpeian = 'pon';
    case Central_Pomo = 'poo';
    case Pwapwa = 'pop';
    case Texistepec_Popoluca = 'poq';
    case Portuguese = 'por';
    case Sayula_Popoluca = 'pos';
    case Potawatomi = 'pot';
    case Upper_Guinea_Crioulo = 'pov';
    case San_Felipe_Otlaltepec_Popoloca = 'pow';
    case Polabian = 'pox';
    case Pogolo = 'poy';
    case Papi = 'ppe';
    case Paipai = 'ppi';
    case Uma = 'ppk';
    case Pipil = 'ppl';
    case Papuma = 'ppm';
    case Papapana = 'ppn';
    case Folopa = 'ppo';
    case Pelende = 'ppp';
    case Pei = 'ppq';
    case San_Luis_Temalacayuca_Popoloca = 'pps';
    case Pare = 'ppt';
    case Papora = 'ppu';
    case Pa_a = 'pqa';
    case Malecite_Passamaquoddy = 'pqm';
    case Parachi = 'prc';
    case Parsi_Dari = 'prd';
    case Principense = 'pre';
    case Paranan = 'prf';
    case Prussian = 'prg';
    case Porohanon = 'prh';
    case Paici = 'pri';
    case Parauk = 'prk';
    case Peruvian_Sign_Language = 'prl';
    case Kibiri = 'prm';
    case Prasuni = 'prn';
    case Old_Provencal_to_1500 = 'pro';
    case Asheninka_Perene = 'prq';
    case Puri = 'prr';
    case Dari = 'prs';
    case Phai = 'prt';
    case Puragi = 'pru';
    case Parawen = 'prw';
    case Purik = 'prx';
    case Providencia_Sign_Language = 'prz';
    case Asue_Awyu = 'psa';
    case Iranian_Sign_Language = 'psc';
    case Plains_Indian_Sign_Language = 'psd';
    case Central_Malay = 'pse';
    case Penang_Sign_Language = 'psg';
    case Southwest_Pashai = 'psh';
    case Southeast_Pashai = 'psi';
    case Puerto_Rican_Sign_Language = 'psl';
    case Pauserna = 'psm';
    case Panasuan = 'psn';
    case Polish_Sign_Language = 'pso';
    case Philippine_Sign_Language = 'psp';
    case Pasi = 'psq';
    case Portuguese_Sign_Language = 'psr';
    case Kaulong = 'pss';
    case Central_Pashto = 'pst';
    case Sauraseni_Prakrit = 'psu';
    case Port_Sandwich = 'psw';
    case Piscataway = 'psy';
    case Pai_Tavytera = 'pta';
    case Pataxo_Ha_Ha_Hae = 'pth';
    case Pindiini = 'pti';
    case Patani = 'ptn';
    case Zo_e = 'pto';
    case Patep = 'ptp';
    case Pattapu = 'ptq';
    case Piamatsina = 'ptr';
    case Enrekang = 'ptt';
    case Bambam = 'ptu';
    case Port_Vato = 'ptv';
    case Pentlatch = 'ptw';
    case Pathiya = 'pty';
    case Western_Highland_Purepecha = 'pua';
    case Purum = 'pub';
    case Punan_Merap = 'puc';
    case Punan_Aput = 'pud';
    case Puelche = 'pue';
    case Punan_Merah = 'puf';
    case Phuie = 'pug';
    case Puinave = 'pui';
    case Punan_Tubu = 'puj';
    case Puma = 'pum';
    case Puoc = 'puo';
    case Pulabu = 'pup';
    case Puquina = 'puq';
    case Purubora = 'pur';
    case Pushto = 'pus';
    case Putoh = 'put';
    case Punu = 'puu';
    case Puluwatese = 'puw';
    case Puare = 'pux';
    case Purisimeno = 'puy';
    case Pawaia = 'pwa';
    case Panawa = 'pwb';
    case Gapapaiwa = 'pwg';
    case Patwin = 'pwi';
    case Molbog = 'pwm';
    case Paiwan = 'pwn';
    case Pwo_Western_Karen = 'pwo';
    case Powari = 'pwr';
    case Pwo_Northern_Karen = 'pww';
    case Quetzaltepec_Mixe = 'pxm';
    case Pye_Krumen = 'pye';
    case Fyam = 'pym';
    case Poyanawa = 'pyn';
    case Paraguayan_Sign_Language = 'pys';
    case Puyuma = 'pyu';
    case Pyu_Myanmar = 'pyx';
    case Pyen = 'pyy';
    case Pesse = 'pze';
    case Pazeh = 'pzh';
    case Jejara_Naga = 'pzn';
    case Quapaw = 'qua';
    case Huallaga_Huanuco_Quechua = 'qub';
    case K_iche = 'quc';
    case Calderon_Highland_Quichua = 'qud';
    case Quechua = 'que';
    case Lambayeque_Quechua = 'quf';
    case Chimborazo_Highland_Quichua = 'qug';
    case South_Bolivian_Quechua = 'quh';
    case Quileute = 'qui';
    case Chachapoyas_Quechua = 'quk';
    case North_Bolivian_Quechua = 'qul';
    case Sipacapense = 'qum';
    case Quinault = 'qun';
    case Southern_Pastaza_Quechua = 'qup';
    case Quinqui = 'quq';
    case Yanahuanca_Pasco_Quechua = 'qur';
    case Santiago_del_Estero_Quichua = 'qus';
    case Sacapulteco = 'quv';
    case Tena_Lowland_Quichua = 'quw';
    case Yauyos_Quechua = 'qux';
    case Ayacucho_Quechua = 'quy';
    case Cusco_Quechua = 'quz';
    case Ambo_Pasco_Quechua = 'qva';
    case Cajamarca_Quechua = 'qvc';
    case Eastern_Apurimac_Quechua = 'qve';
    case Huamalies_Dos_de_Mayo_Huanuco_Quechua = 'qvh';
    case Imbabura_Highland_Quichua = 'qvi';
    case Loja_Highland_Quichua = 'qvj';
    case Cajatambo_North_Lima_Quechua = 'qvl';
    case Margos_Yarowilca_Lauricocha_Quechua = 'qvm';
    case North_Junin_Quechua = 'qvn';
    case Napo_Lowland_Quechua = 'qvo';
    case Pacaraos_Quechua = 'qvp';
    case San_Martin_Quechua = 'qvs';
    case Huaylla_Wanca_Quechua = 'qvw';
    case Queyu = 'qvy';
    case Northern_Pastaza_Quichua = 'qvz';
    case Corongo_Ancash_Quechua = 'qwa';
    case Classical_Quechua = 'qwc';
    case Huaylas_Ancash_Quechua = 'qwh';
    case Kuman_Russia = 'qwm';
    case Sihuas_Ancash_Quechua = 'qws';
    case Kwalhioqua_Tlatskanai = 'qwt';
    case Chiquian_Ancash_Quechua = 'qxa';
    case Chincha_Quechua = 'qxc';
    case Panao_Huanuco_Quechua = 'qxh';
    case Salasaca_Highland_Quichua = 'qxl';
    case Northern_Conchucos_Ancash_Quechua = 'qxn';
    case Southern_Conchucos_Ancash_Quechua = 'qxo';
    case Puno_Quechua = 'qxp';
    case Qashqa_i = 'qxq';
    case Canar_Highland_Quichua = 'qxr';
    case Southern_Qiang = 'qxs';
    case Santa_Ana_de_Tusi_Pasco_Quechua = 'qxt';
    case Arequipa_La_Union_Quechua = 'qxu';
    case Jauja_Wanca_Quechua = 'qxw';
    case Quenya = 'qya';
    case Quiripi = 'qyp';
    case Dungmali = 'raa';
    case Camling = 'rab';
    case Rasawa = 'rac';
    case Rade = 'rad';
    case Western_Meohang = 'raf';
    case Logooli = 'rag';
    case Rabha = 'rah';
    case Ramoaaina = 'rai';
    case Rajasthani = 'raj';
    case Tulu_Bohuai = 'rak';
    case Ralte = 'ral';
    case Canela = 'ram';
    case Riantana = 'ran';
    case Rao = 'rao';
    case Rapanui = 'rap';
    case Saam = 'raq';
    case Rarotongan = 'rar';
    case Tegali = 'ras';
    case Razajerdi = 'rat';
    case Raute = 'rau';
    case Sampang = 'rav';
    case Rawang = 'raw';
    case Rang = 'rax';
    case Rapa = 'ray';
    case Rahambuu = 'raz';
    case Rumai_Palaung = 'rbb';
    case Northern_Bontok = 'rbk';
    case Miraya_Bikol = 'rbl';
    case Barababaraba = 'rbp';
    case Reunion_Creole_French = 'rcf';
    case Rudbari = 'rdb';
    case Rerau = 'rea';
    case Rembong = 'reb';
    case Rejang_Kayan = 'ree';
    case Kara_Tanzania = 'reg';
    case Reli = 'rei';
    case Rejang = 'rej';
    case Rendille = 'rel';
    case Remo = 'rem';
    case Rengao = 'ren';
    case Rer_Bare = 'rer';
    case Reshe = 'res';
    case Retta = 'ret';
    case Reyesano = 'rey';
    case Roria = 'rga';
    case Romano_Greek = 'rge';
    case Rangkas = 'rgk';
    case Romagnol = 'rgn';
    case Resigaro = 'rgr';
    case Southern_Roglai = 'rgs';
    case Ringgou = 'rgu';
    case Rohingya = 'rhg';
    case Yahang = 'rhp';
    case Riang_India = 'ria';
    case Bribri_Sign_Language = 'rib';
    case Tarifit = 'rif';
    case Riang_Lang = 'ril';
    case Nyaturu = 'rim';
    case Nungu = 'rin';
    case Ribun = 'rir';
    case Ritharrngu = 'rit';
    case Riung = 'riu';
    case Rajong = 'rjg';
    case Raji = 'rji';
    case Rajbanshi = 'rjs';
    case Kraol = 'rka';
    case Rikbaktsa = 'rkb';
    case Rakahanga_Manihiki = 'rkh';
    case Rakhine = 'rki';
    case Marka = 'rkm';
    case Rangpuri = 'rkt';
    case Arakwal = 'rkw';
    case Rama = 'rma';
    case Rembarrnga = 'rmb';
    case Carpathian_Romani = 'rmc';
    case Traveller_Danish = 'rmd';
    case Angloromani = 'rme';
    case Kalo_Finnish_Romani = 'rmf';
    case Traveller_Norwegian = 'rmg';
    case Murkim = 'rmh';
    case Lomavren = 'rmi';
    case Romkun = 'rmk';
    case Baltic_Romani = 'rml';
    case Roma = 'rmm';
    case Balkan_Romani = 'rmn';
    case Sinte_Romani = 'rmo';
    case Rempi = 'rmp';
    case Calo = 'rmq';
    case Romanian_Sign_Language = 'rms';
    case Domari = 'rmt';
    case Tavringer_Romani = 'rmu';
    case Romanova = 'rmv';
    case Welsh_Romani = 'rmw';
    case Romam = 'rmx';
    case Vlax_Romani = 'rmy';
    case Marma = 'rmz';
    case Brunca_Sign_Language = 'rnb';
    case Ruund = 'rnd';
    case Ronga = 'rng';
    case Ranglong = 'rnl';
    case Roon = 'rnn';
    case Rongpo = 'rnp';
    case Nari_Nari = 'rnr';
    case Rungwa = 'rnw';
    case Tae = 'rob';
    case Cacgia_Roglai = 'roc';
    case Rogo = 'rod';
    case Ronji = 'roe';
    case Rombo = 'rof';
    case Northern_Roglai = 'rog';
    case Romansh = 'roh';
    case Romblomanon = 'rol';
    case Romany = 'rom';
    case Romanian = 'ron';
    case Rotokas = 'roo';
    case Kriol = 'rop';
    case Rongga = 'ror';
    case Runga = 'rou';
    case Dela_Oenale = 'row';
    case Repanbitip = 'rpn';
    case Rapting = 'rpt';
    case Ririo = 'rri';
    case Moriori = 'rrm';
    case Waima = 'rro';
    case Arritinngithigh = 'rrt';
    case Romano_Serbian = 'rsb';
    case Ruthenian = 'rsk';
    case Russian_Sign_Language = 'rsl';
    case Miriwoong_Sign_Language = 'rsm';
    case Rwandan_Sign_Language = 'rsn';
    case Rishiwa = 'rsw';
    case Rungtu_Chin = 'rtc';
    case Ratahan = 'rth';
    case Rotuman = 'rtm';
    case Yurats = 'rts';
    case Rathawi = 'rtw';
    case Gungu = 'rub';
    case Ruuli = 'ruc';
    case Rusyn = 'rue';
    case Luguru = 'ruf';
    case Roviana = 'rug';
    case Ruga = 'ruh';
    case Rufiji = 'rui';
    case Che = 'ruk';
    case Rundi = 'run';
    case Istro_Romanian = 'ruo';
    case Macedo_Romanian = 'rup';
    case Megleno_Romanian = 'ruq';
    case Russian = 'rus';
    case Rutul = 'rut';
    case Lanas_Lobu = 'ruu';
    case Mala_Nigeria = 'ruy';
    case Ruma = 'ruz';
    case Rawo = 'rwa';
    case Rwa = 'rwk';
    case Ruwila = 'rwl';
    case Amba_Uganda = 'rwm';
    case Rawa = 'rwo';
    case Marwari_India = 'rwr';
    case Ngardi = 'rxd';
    case Karuwali = 'rxw';
    case Northern_Amami_Oshima = 'ryn';
    case Yaeyama = 'rys';
    case Central_Okinawan = 'ryu';
    case Razihi = 'rzh';
    case Saba = 'saa';
    case Buglere = 'sab';
    case Meskwaki = 'sac';
    case Sandawe = 'sad';
    case Sabane = 'sae';
    case Safaliba = 'saf';
    case Sango = 'sag';
    case Yakut = 'sah';
    case Sahu = 'saj';
    case Sake = 'sak';
    case Samaritan_Aramaic = 'sam';
    case Sanskrit = 'san';
    case Sause = 'sao';
    case Samburu = 'saq';
    case Saraveca = 'sar';
    case Sasak = 'sas';
    case Santali = 'sat';
    case Saleman = 'sau';
    case Saafi_Saafi = 'sav';
    case Sawi = 'saw';
    case Sa = 'sax';
    case Saya = 'say';
    case Saurashtra = 'saz';
    case Ngambay = 'sba';
    case Simbo = 'sbb';
    case Kele_Papua_New_Guinea = 'sbc';
    case Southern_Samo = 'sbd';
    case Saliba = 'sbe';
    case Chabu = 'sbf';
    case Seget = 'sbg';
    case Sori_Harengan = 'sbh';
    case Seti = 'sbi';
    case Surbakhal = 'sbj';
    case Safwa = 'sbk';
    case Botolan_Sambal = 'sbl';
    case Sagala = 'sbm';
    case Sindhi_Bhil = 'sbn';
    case Sabum = 'sbo';
    case Sangu_Tanzania = 'sbp';
    case Sileibi = 'sbq';
    case Sembakung_Murut = 'sbr';
    case Subiya = 'sbs';
    case Kimki = 'sbt';
    case Stod_Bhoti = 'sbu';
    case Sabine = 'sbv';
    case Simba = 'sbw';
    case Seberuang = 'sbx';
    case Soli = 'sby';
    case Sara_Kaba = 'sbz';
    case Chut = 'scb';
    case Dongxiang = 'sce';
    case San_Miguel_Creole_French = 'scf';
    case Sanggau = 'scg';
    case Sakachep = 'sch';
    case Sri_Lankan_Creole_Malay = 'sci';
    case Sadri = 'sck';
    case Shina = 'scl';
    case Sicilian = 'scn';
    case Scots = 'sco';
    case Hyolmo = 'scp';
    case Sa_och = 'scq';
    case North_Slavey = 'scs';
    case Southern_Katang = 'sct';
    case Shumcho = 'scu';
    case Sheni = 'scv';
    case Sha = 'scw';
    case Sicel = 'scx';
    case Toraja_Sa_dan = 'sda';
    case Shabak = 'sdb';
    case Sassarese_Sardinian = 'sdc';
    case Surubu = 'sde';
    case Sarli = 'sdf';
    case Savi = 'sdg';
    case Southern_Kurdish = 'sdh';
    case Suundi = 'sdj';
    case Sos_Kundi = 'sdk';
    case Saudi_Arabian_Sign_Language = 'sdl';
    case Gallurese_Sardinian = 'sdn';
    case Bukar_Sadung_Bidayuh = 'sdo';
    case Sherdukpen = 'sdp';
    case Semandang = 'sdq';
    case Oraon_Sadri = 'sdr';
    case Sened = 'sds';
    case Shuadit = 'sdt';
    case Sarudu = 'sdu';
    case Sibu_Melanau = 'sdx';
    case Sallands = 'sdz';
    case Semai = 'sea';
    case Shempire_Senoufo = 'seb';
    case Sechelt = 'sec';
    case Sedang = 'sed';
    case Seneca = 'see';
    case Cebaara_Senoufo = 'sef';
    case Segeju = 'seg';
    case Sena = 'seh';
    case Seri = 'sei';
    case Sene = 'sej';
    case Sekani = 'sek';
    case Selkup = 'sel';
    case Nanerige_Senoufo = 'sen';
    case Suarmin = 'seo';
    case Sicite_Senoufo = 'sep';
    case Senara_Senoufo = 'seq';
    case Serrano = 'ser';
    case Koyraboro_Senni_Songhai = 'ses';
    case Sentani = 'set';
    case Serui_Laut = 'seu';
    case Nyarafolo_Senoufo = 'sev';
    case Sewa_Bay = 'sew';
    case Secoya = 'sey';
    case Senthang_Chin = 'sez';
    case Langue_des_signes_de_Belgique_Francophone = 'sfb';
    case Eastern_Subanen = 'sfe';
    case Small_Flowery_Miao = 'sfm';
    case South_African_Sign_Language = 'sfs';
    case Sehwi = 'sfw';
    case Old_Irish_to_900 = 'sga';
    case Mag_antsi_Ayta = 'sgb';
    case Kipsigis = 'sgc';
    case Surigaonon = 'sgd';
    case Segai = 'sge';
    case Swiss_German_Sign_Language = 'sgg';
    case Shughni = 'sgh';
    case Suga = 'sgi';
    case Surgujia = 'sgj';
    case Sangkong = 'sgk';
    case Singa = 'sgm';
    case Singpho = 'sgp';
    case Sangisari = 'sgr';
    case Samogitian = 'sgs';
    case Brokpake = 'sgt';
    case Salas = 'sgu';
    case Sebat_Bet_Gurage = 'sgw';
    case Sierra_Leone_Sign_Language = 'sgx';
    case Sanglechi = 'sgy';
    case Sursurunga = 'sgz';
    case Shall_Zwall = 'sha';
    case Ninam = 'shb';
    case Sonde = 'shc';
    case Kundal_Shahi = 'shd';
    case Sheko = 'she';
    case Shua = 'shg';
    case Shoshoni = 'shh';
    case Tachelhit = 'shi';
    case Shatt = 'shj';
    case Shilluk = 'shk';
    case Shendu = 'shl';
    case Shahrudi = 'shm';
    case Shan = 'shn';
    case Shanga = 'sho';
    case Shipibo_Conibo = 'shp';
    case Sala = 'shq';
    case Shi = 'shr';
    case Shuswap = 'shs';
    case Shasta = 'sht';
    case Chadian_Arabic = 'shu';
    case Shehri = 'shv';
    case Shwai = 'shw';
    case She = 'shx';
    case Tachawit = 'shy';
    case Syenara_Senoufo = 'shz';
    case Akkala_Sami = 'sia';
    case Sebop = 'sib';
    case Sidamo = 'sid';
    case Simaa = 'sie';
    case Siamou = 'sif';
    case Paasaal = 'sig';
    case Zire = 'sih';
    case Shom_Peng = 'sii';
    case Numbami = 'sij';
    case Sikiana = 'sik';
    case Tumulung_Sisaala = 'sil';
    case Mende_Papua_New_Guinea = 'sim';
    case Sinhala = 'sin';
    case Sikkimese = 'sip';
    case Sonia = 'siq';
    case Siri = 'sir';
    case Siuslaw = 'sis';
    case Sinagen = 'siu';
    case Sumariup = 'siv';
    case Siwai = 'siw';
    case Sumau = 'six';
    case Sivandi = 'siy';
    case Siwi = 'siz';
    case Epena = 'sja';
    case Sajau_Basap = 'sjb';
    case Shaojiang_Chinese = 'sjc';
    case Kildin_Sami = 'sjd';
    case Pite_Sami = 'sje';
    case Assangori = 'sjg';
    case Kemi_Sami = 'sjk';
    case Sajalong = 'sjl';
    case Mapun = 'sjm';
    case Sindarin = 'sjn';
    case Xibe = 'sjo';
    case Surjapuri = 'sjp';
    case Siar_Lak = 'sjr';
    case Senhaja_De_Srair = 'sjs';
    case Ter_Sami = 'sjt';
    case Ume_Sami = 'sju';
    case Shawnee = 'sjw';
    case Skagit = 'ska';
    case Saek = 'skb';
    case Ma_Manda = 'skc';
    case Southern_Sierra_Miwok = 'skd';
    case Seke_Vanuatu = 'ske';
    case Sakirabia = 'skf';
    case Sakalava_Malagasy = 'skg';
    case Sikule = 'skh';
    case Sika = 'ski';
    case Seke_Nepal = 'skj';
    case Kutong = 'skm';
    case Kolibugan_Subanon = 'skn';
    case Seko_Tengah = 'sko';
    case Sekapan = 'skp';
    case Sininkere = 'skq';
    case Saraiki = 'skr';
    case Maia = 'sks';
    case Sakata = 'skt';
    case Sakao = 'sku';
    case Skou = 'skv';
    case Skepi_Creole_Dutch = 'skw';
    case Seko_Padang = 'skx';
    case Sikaiana = 'sky';
    case Sekar = 'skz';
    case Saliba_2 = 'slc';
    case Sissala = 'sld';
    case Sholaga = 'sle';
    case Swiss_Italian_Sign_Language = 'slf';
    case Selungai_Murut = 'slg';
    case Southern_Puget_Sound_Salish = 'slh';
    case Lower_Silesian = 'sli';
    case Saluma = 'slj';
    case Slovak = 'slk';
    case Salt_Yui = 'sll';
    case Pangutaran_Sama = 'slm';
    case Salinan = 'sln';
    case Lamaholot = 'slp';
    case Salar = 'slr';
    case Singapore_Sign_Language = 'sls';
    case Sila = 'slt';
    case Selaru = 'slu';
    case Slovenian = 'slv';
    case Sialum = 'slw';
    case Salampasu = 'slx';
    case Selayar = 'sly';
    case Ma_ya = 'slz';
    case Southern_Sami = 'sma';
    case Simbari = 'smb';
    case Som = 'smc';
    case Northern_Sami = 'sme';
    case Auwe = 'smf';
    case Simbali = 'smg';
    case Samei = 'smh';
    case Lule_Sami = 'smj';
    case Bolinao = 'smk';
    case Central_Sama = 'sml';
    case Musasa = 'smm';
    case Inari_Sami = 'smn';
    case Samoan = 'smo';
    case Samaritan = 'smp';
    case Samo = 'smq';
    case Simeulue = 'smr';
    case Skolt_Sami = 'sms';
    case Simte = 'smt';
    case Somray = 'smu';
    case Samvedi = 'smv';
    case Sumbawa = 'smw';
    case Samba = 'smx';
    case Semnani = 'smy';
    case Simeku = 'smz';
    case Shona = 'sna';
    case Sinaugoro = 'snc';
    case Sindhi = 'snd';
    case Bau_Bidayuh = 'sne';
    case Noon = 'snf';
    case Sanga_Democratic_Republic_of_Congo = 'sng';
    case Sensi = 'sni';
    case Riverain_Sango = 'snj';
    case Soninke = 'snk';
    case Sangil = 'snl';
    case Southern_Ma_di = 'snm';
    case Siona = 'snn';
    case Snohomish = 'sno';
    case Siane = 'snp';
    case Sangu_Gabon = 'snq';
    case Sihan = 'snr';
    case South_West_Bay = 'sns';
    case Senggi = 'snu';
    case Sa_ban = 'snv';
    case Selee = 'snw';
    case Sam = 'snx';
    case Saniyo_Hiyewe = 'sny';
    case Kou = 'snz';
    case Thai_Song = 'soa';
    case Sobei = 'sob';
    case So_Democratic_Republic_of_Congo = 'soc';
    case Songoora = 'sod';
    case Songomeno = 'soe';
    case Sogdian = 'sog';
    case Aka = 'soh';
    case Sonha = 'soi';
    case Soi = 'soj';
    case Sokoro = 'sok';
    case Solos = 'sol';
    case Somali = 'som';
    case Songo = 'soo';
    case Songe = 'sop';
    case Kanasi = 'soq';
    case Somrai = 'sor';
    case Seeku = 'sos';
    case Southern_Sotho = 'sot';
    case Southern_Thai = 'sou';
    case Sonsorol = 'sov';
    case Sowanda = 'sow';
    case Swo = 'sox';
    case Miyobe = 'soy';
    case Temi = 'soz';
    case Spanish = 'spa';
    case Sepa_Indonesia = 'spb';
    case Sape = 'spc';
    case Saep = 'spd';
    case Sepa_Papua_New_Guinea = 'spe';
    case Sian = 'spg';
    case Saponi = 'spi';
    case Sengo = 'spk';
    case Selepet = 'spl';
    case Akukem = 'spm';
    case Sanapana = 'spn';
    case Spokane = 'spo';
    case Supyire_Senoufo = 'spp';
    case Loreto_Ucayali_Spanish = 'spq';
    case Saparua = 'spr';
    case Saposa = 'sps';
    case Spiti_Bhoti = 'spt';
    case Sapuan = 'spu';
    case Sambalpuri = 'spv';
    case South_Picene = 'spx';
    case Sabaot = 'spy';
    case Shama_Sambuga = 'sqa';
    case Shau = 'sqh';
    case Albanian = 'sqi';
    case Albanian_Sign_Language = 'sqk';
    case Suma = 'sqm';
    case Susquehannock = 'sqn';
    case Sorkhei = 'sqo';
    case Sou = 'sqq';
    case Siculo_Arabic = 'sqr';
    case Sri_Lankan_Sign_Language = 'sqs';
    case Soqotri = 'sqt';
    case Squamish = 'squ';
    case Kufr_Qassem_Sign_Language_KQSL = 'sqx';
    case Saruga = 'sra';
    case Sora = 'srb';
    case Logudorese_Sardinian = 'src';
    case Sardinian = 'srd';
    case Sara = 'sre';
    case Nafi = 'srf';
    case Sulod = 'srg';
    case Sarikoli = 'srh';
    case Siriano = 'sri';
    case Serudung_Murut = 'srk';
    case Isirawa = 'srl';
    case Saramaccan = 'srm';
    case Sranan_Tongo = 'srn';
    case Campidanese_Sardinian = 'sro';
    case Serbian = 'srp';
    case Siriono = 'srq';
    case Serer = 'srr';
    case Sarsi = 'srs';
    case Sauri = 'srt';
    case Surui = 'sru';
    case Southern_Sorsoganon = 'srv';
    case Serua = 'srw';
    case Sirmauri = 'srx';
    case Sera = 'sry';
    case Shahmirzadi = 'srz';
    case Southern_Sama = 'ssb';
    case Suba_Simbiti = 'ssc';
    case Siroi = 'ssd';
    case Balangingi = 'sse';
    case Thao = 'ssf';
    case Seimat = 'ssg';
    case Shihhi_Arabic = 'ssh';
    case Sansi = 'ssi';
    case Sausi = 'ssj';
    case Sunam = 'ssk';
    case Western_Sisaala = 'ssl';
    case Semnam = 'ssm';
    case Waata = 'ssn';
    case Sissano = 'sso';
    case Spanish_Sign_Language = 'ssp';
    case So_a = 'ssq';
    case Swiss_French_Sign_Language = 'ssr';
    case So = 'sss';
    case Sinasina = 'sst';
    case Susuami = 'ssu';
    case Shark_Bay = 'ssv';
    case Swati = 'ssw';
    case Samberigi = 'ssx';
    case Saho = 'ssy';
    case Sengseng = 'ssz';
    case Settla = 'sta';
    case Northern_Subanen = 'stb';
    case Sentinel = 'std';
    case Liana_Seti = 'ste';
    case Seta = 'stf';
    case Trieng = 'stg';
    case Shelta = 'sth';
    case Bulo_Stieng = 'sti';
    case Matya_Samo = 'stj';
    case Arammba = 'stk';
    case Stellingwerfs = 'stl';
    case Setaman = 'stm';
    case Owa = 'stn';
    case Stoney = 'sto';
    case Southeastern_Tepehuan = 'stp';
    case Saterfriesisch = 'stq';
    case Straits_Salish = 'str';
    case Shumashti = 'sts';
    case Budeh_Stieng = 'stt';
    case Samtao = 'stu';
    case Silt_e = 'stv';
    case Satawalese = 'stw';
    case Siberian_Tatar = 'sty';
    case Sulka = 'sua';
    case Suku = 'sub';
    case Western_Subanon = 'suc';
    case Suena = 'sue';
    case Suganga = 'sug';
    case Suki = 'sui';
    case Shubi = 'suj';
    case Sukuma = 'suk';
    case Sundanese = 'sun';
    case Bouni = 'suo';
    case Tirmaga_Chai_Suri = 'suq';
    case Mwaghavul = 'sur';
    case Susu = 'sus';
    case Subtiaba = 'sut';
    case Puroik = 'suv';
    case Sumbwa = 'suw';
    case Sumerian = 'sux';
    case Suya = 'suy';
    case Sunwar = 'suz';
    case Svan = 'sva';
    case Ulau_Suain = 'svb';
    case Vincentian_Creole_English = 'svc';
    case Serili = 'sve';
    case Slovakian_Sign_Language = 'svk';
    case Slavomolisano = 'svm';
    case Savosavo = 'svs';
    case Skalvian = 'svx';
    case Swahili_macrolanguage = 'swa';
    case Maore_Comorian = 'swb';
    case Congo_Swahili = 'swc';
    case Swedish = 'swe';
    case Sere = 'swf';
    case Swabian = 'swg';
    case Swahili_individual_language = 'swh';
    case Sui = 'swi';
    case Sira = 'swj';
    case Malawi_Sena = 'swk';
    case Swedish_Sign_Language = 'swl';
    case Samosa = 'swm';
    case Sawknah = 'swn';
    case Shanenawa = 'swo';
    case Suau = 'swp';
    case Sharwa = 'swq';
    case Saweru = 'swr';
    case Seluwasan = 'sws';
    case Sawila = 'swt';
    case Suwawa = 'swu';
    case Shekhawati = 'swv';
    case Sowa = 'sww';
    case Suruaha = 'swx';
    case Sarua = 'swy';
    case Suba = 'sxb';
    case Sicanian = 'sxc';
    case Sighu = 'sxe';
    case Shuhi = 'sxg';
    case Southern_Kalapuya = 'sxk';
    case Selian = 'sxl';
    case Samre = 'sxm';
    case Sangir = 'sxn';
    case Sorothaptic = 'sxo';
    case Saaroa = 'sxr';
    case Sasaru = 'sxs';
    case Upper_Saxon = 'sxu';
    case Saxwe_Gbe = 'sxw';
    case Siang = 'sya';
    case Central_Subanen = 'syb';
    case Classical_Syriac = 'syc';
    case Seki = 'syi';
    case Sukur = 'syk';
    case Sylheti = 'syl';
    case Maya_Samo = 'sym';
    case Senaya = 'syn';
    case Suoy = 'syo';
    case Syriac = 'syr';
    case Sinyar = 'sys';
    case Kagate = 'syw';
    case Samay = 'syx';
    case Al_Sayyid_Bedouin_Sign_Language = 'syy';
    case Semelai = 'sza';
    case Ngalum = 'szb';
    case Semaq_Beri = 'szc';
    case Seze = 'sze';
    case Sengele = 'szg';
    case Silesian = 'szl';
    case Sula = 'szn';
    case Suabo = 'szp';
    case Solomon_Islands_Sign_Language = 'szs';
    case Isu_Fako_Division = 'szv';
    case Sawai = 'szw';
    case Sakizaya = 'szy';
    case Lower_Tanana = 'taa';
    case Tabassaran = 'tab';
    case Lowland_Tarahumara = 'tac';
    case Tause = 'tad';
    case Tariana = 'tae';
    case Tapirape = 'taf';
    case Tagoi = 'tag';
    case Tahitian = 'tah';
    case Eastern_Tamang = 'taj';
    case Tala = 'tak';
    case Tal = 'tal';
    case Tamil = 'tam';
    case Tangale = 'tan';
    case Yami = 'tao';
    case Taabwa = 'tap';
    case Tamasheq = 'taq';
    case Central_Tarahumara = 'tar';
    case Tay_Boi = 'tas';
    case Tatar = 'tat';
    case Upper_Tanana = 'tau';
    case Tatuyo = 'tav';
    case Tai = 'taw';
    case Tamki = 'tax';
    case Atayal = 'tay';
    case Tocho = 'taz';
    case Aikana = 'tba';
    case Takia = 'tbc';
    case Kaki_Ae = 'tbd';
    case Tanimbili = 'tbe';
    case Mandara = 'tbf';
    case North_Tairora = 'tbg';
    case Dharawal = 'tbh';
    case Gaam = 'tbi';
    case Tiang = 'tbj';
    case Calamian_Tagbanwa = 'tbk';
    case Tboli = 'tbl';
    case Tagbu = 'tbm';
    case Barro_Negro_Tunebo = 'tbn';
    case Tawala = 'tbo';
    case Taworta = 'tbp';
    case Tumtum = 'tbr';
    case Tanguat = 'tbs';
    case Tembo_Kitembo = 'tbt';
    case Tubar = 'tbu';
    case Tobo = 'tbv';
    case Tagbanwa = 'tbw';
    case Kapin = 'tbx';
    case Tabaru = 'tby';
    case Ditammari = 'tbz';
    case Ticuna = 'tca';
    case Tanacross = 'tcb';
    case Datooga = 'tcc';
    case Tafi = 'tcd';
    case Southern_Tutchone = 'tce';
    case Malinaltepec_Me_phaa = 'tcf';
    case Tamagario = 'tcg';
    case Turks_And_Caicos_Creole_English = 'tch';
    case Wara = 'tci';
    case Tchitchege = 'tck';
    case Taman_Myanmar = 'tcl';
    case Tanahmerah = 'tcm';
    case Tichurong = 'tcn';
    case Taungyo = 'tco';
    case Tawr_Chin = 'tcp';
    case Kaiy = 'tcq';
    case Torres_Strait_Creole = 'tcs';
    case T_en = 'tct';
    case Southeastern_Tarahumara = 'tcu';
    case Tecpatlan_Totonac = 'tcw';
    case Toda = 'tcx';
    case Tulu = 'tcy';
    case Thado_Chin = 'tcz';
    case Tagdal = 'tda';
    case Panchpargania = 'tdb';
    case Embera_Tado = 'tdc';
    case Tai_Nua = 'tdd';
    case Tiranige_Diga_Dogon = 'tde';
    case Talieng = 'tdf';
    case Western_Tamang = 'tdg';
    case Thulung = 'tdh';
    case Tomadino = 'tdi';
    case Tajio = 'tdj';
    case Tambas = 'tdk';
    case Sur = 'tdl';
    case Taruma = 'tdm';
    case Tondano = 'tdn';
    case Teme = 'tdo';
    case Tita = 'tdq';
    case Todrah = 'tdr';
    case Doutai = 'tds';
    case Tetun_Dili = 'tdt';
    case Toro = 'tdv';
    case Tandroy_Mahafaly_Malagasy = 'tdx';
    case Tadyawan = 'tdy';
    case Temiar = 'tea';
    case Tetete = 'teb';
    case Terik = 'tec';
    case Tepo_Krumen = 'ted';
    case Huehuetla_Tepehua = 'tee';
    case Teressa = 'tef';
    case Teke_Tege = 'teg';
    case Tehuelche = 'teh';
    case Torricelli = 'tei';
    case Ibali_Teke = 'tek';
    case Telugu = 'tel';
    case Timne = 'tem';
    case Tama_Colombia = 'ten';
    case Teso = 'teo';
    case Tepecano = 'tep';
    case Temein = 'teq';
    case Tereno = 'ter';
    case Tengger = 'tes';
    case Tetum = 'tet';
    case Soo = 'teu';
    case Teor = 'tev';
    case Tewa_USA = 'tew';
    case Tennet = 'tex';
    case Tulishi = 'tey';
    case Tetserret = 'tez';
    case Tofin_Gbe = 'tfi';
    case Tanaina = 'tfn';
    case Tefaro = 'tfo';
    case Teribe = 'tfr';
    case Ternate = 'tft';
    case Sagalla = 'tga';
    case Tobilung = 'tgb';
    case Tigak = 'tgc';
    case Ciwogai = 'tgd';
    case Eastern_Gorkha_Tamang = 'tge';
    case Chalikha = 'tgf';
    case Tobagonian_Creole_English = 'tgh';
    case Lawunuia = 'tgi';
    case Tagin = 'tgj';
    case Tajik = 'tgk';
    case Tagalog = 'tgl';
    case Tandaganon = 'tgn';
    case Sudest = 'tgo';
    case Tangoa = 'tgp';
    case Tring = 'tgq';
    case Tareng = 'tgr';
    case Nume = 'tgs';
    case Central_Tagbanwa = 'tgt';
    case Tanggu = 'tgu';
    case Tingui_Boto = 'tgv';
    case Tagwana_Senoufo = 'tgw';
    case Tagish = 'tgx';
    case Togoyo = 'tgy';
    case Tagalaka = 'tgz';
    case Thai = 'tha';
    case Kuuk_Thaayorre = 'thd';
    case Chitwania_Tharu = 'the';
    case Thangmi = 'thf';
    case Northern_Tarahumara = 'thh';
    case Tai_Long = 'thi';
    case Tharaka = 'thk';
    case Dangaura_Tharu = 'thl';
    case Aheu = 'thm';
    case Thachanadan = 'thn';
    case Thompson = 'thp';
    case Kochila_Tharu = 'thq';
    case Rana_Tharu = 'thr';
    case Thakali = 'ths';
    case Tahltan = 'tht';
    case Thuri = 'thu';
    case Tahaggart_Tamahaq = 'thv';
    case Tha = 'thy';
    case Tayart_Tamajeq = 'thz';
    case Tidikelt_Tamazight = 'tia';
    case Tira = 'tic';
    case Tifal = 'tif';
    case Tigre = 'tig';
    case Timugon_Murut = 'tih';
    case Tiene = 'tii';
    case Tilung = 'tij';
    case Tikar = 'tik';
    case Tillamook = 'til';
    case Timbe = 'tim';
    case Tindi = 'tin';
    case Teop = 'tio';
    case Trimuris = 'tip';
    case Tiefo = 'tiq';
    case Tigrinya = 'tir';
    case Masadiit_Itneg = 'tis';
    case Tinigua = 'tit';
    case Adasen = 'tiu';
    case Tiv = 'tiv';
    case Tiwi = 'tiw';
    case Southern_Tiwa = 'tix';
    case Tiruray = 'tiy';
    case Tai_Hongjin = 'tiz';
    case Tajuasohn = 'tja';
    case Tunjung = 'tjg';
    case Northern_Tujia = 'tji';
    case Tjungundji = 'tjj';
    case Tai_Laing = 'tjl';
    case Timucua = 'tjm';
    case Tonjon = 'tjn';
    case Temacine_Tamazight = 'tjo';
    case Tjupany = 'tjp';
    case Southern_Tujia = 'tjs';
    case Tjurruru = 'tju';
    case Djabwurrung = 'tjw';
    case Truka = 'tka';
    case Buksa = 'tkb';
    case Tukudede = 'tkd';
    case Takwane = 'tke';
    case Tukumanfed = 'tkf';
    case Tesaka_Malagasy = 'tkg';
    case Tokelau = 'tkl';
    case Takelma = 'tkm';
    case Toku_No_Shima = 'tkn';
    case Tikopia = 'tkp';
    case Tee = 'tkq';
    case Tsakhur = 'tkr';
    case Takestani = 'tks';
    case Kathoriya_Tharu = 'tkt';
    case Upper_Necaxa_Totonac = 'tku';
    case Mur_Pano = 'tkv';
    case Teanu = 'tkw';
    case Tangko = 'tkx';
    case Takua = 'tkz';
    case Southwestern_Tepehuan = 'tla';
    case Tobelo = 'tlb';
    case Yecuatla_Totonac = 'tlc';
    case Talaud = 'tld';
    case Telefol = 'tlf';
    case Tofanma = 'tlg';
    case Klingon = 'tlh';
    case Tlingit = 'tli';
    case Talinga_Bwisi = 'tlj';
    case Taloki = 'tlk';
    case Tetela = 'tll';
    case Tolomako = 'tlm';
    case Talondo = 'tln';
    case Talodi = 'tlo';
    case Filomena_Mata_Coahuitlan_Totonac = 'tlp';
    case Tai_Loi = 'tlq';
    case Talise = 'tlr';
    case Tambotalo = 'tls';
    case Sou_Nama = 'tlt';
    case Tulehu = 'tlu';
    case Taliabu = 'tlv';
    case Khehek = 'tlx';
    case Talysh = 'tly';
    case Tama_Chad = 'tma';
    case Katbol = 'tmb';
    case Tumak = 'tmc';
    case Haruai = 'tmd';
    case Tremembe = 'tme';
    case Toba_Maskoy = 'tmf';
    case Ternateno = 'tmg';
    case Tamashek = 'tmh';
    case Tutuba = 'tmi';
    case Samarokena = 'tmj';
    case Tamnim_Citak = 'tml';
    case Tai_Thanh = 'tmm';
    case Taman_Indonesia = 'tmn';
    case Temoq = 'tmo';
    case Tumleo = 'tmq';
    case Jewish_Babylonian_Aramaic_ca_200_1200_CE = 'tmr';
    case Tima = 'tms';
    case Tasmate = 'tmt';
    case Iau = 'tmu';
    case Tembo_Motembo = 'tmv';
    case Temuan = 'tmw';
    case Tami = 'tmy';
    case Tamanaku = 'tmz';
    case Tacana = 'tna';
    case Western_Tunebo = 'tnb';
    case Tanimuca_Retuara = 'tnc';
    case Angosturas_Tunebo = 'tnd';
    case Tobanga = 'tng';
    case Maiani = 'tnh';
    case Tandia = 'tni';
    case Kwamera = 'tnk';
    case Lenakel = 'tnl';
    case Tabla = 'tnm';
    case North_Tanna = 'tnn';
    case Toromono = 'tno';
    case Whitesands = 'tnp';
    case Taino = 'tnq';
    case Menik = 'tnr';
    case Tenis = 'tns';
    case Tontemboan = 'tnt';
    case Tay_Khang = 'tnu';
    case Tangchangya = 'tnv';
    case Tonsawang = 'tnw';
    case Tanema = 'tnx';
    case Tongwe = 'tny';
    case Ten_edn = 'tnz';
    case Toba = 'tob';
    case Coyutla_Totonac = 'toc';
    case Toma = 'tod';
    case Gizrra = 'tof';
    case Tonga_Nyasa = 'tog';
    case Gitonga = 'toh';
    case Tonga_Zambia = 'toi';
    case Tojolabal = 'toj';
    case Toki_Pona = 'tok';
    case Tolowa = 'tol';
    case Tombulu = 'tom';
    case Tonga_Tonga_Islands = 'ton';
    case Xicotepec_De_Juarez_Totonac = 'too';
    case Papantla_Totonac = 'top';
    case Toposa = 'toq';
    case Togbo_Vara_Banda = 'tor';
    case Highland_Totonac = 'tos';
    case Tho = 'tou';
    case Upper_Taromi = 'tov';
    case Jemez = 'tow';
    case Tobian = 'tox';
    case Topoiyo = 'toy';
    case To = 'toz';
    case Taupota = 'tpa';
    case Azoyu_Me_phaa = 'tpc';
    case Tippera = 'tpe';
    case Tarpia = 'tpf';
    case Kula = 'tpg';
    case Tok_Pisin = 'tpi';
    case Tapiete = 'tpj';
    case Tupinikin = 'tpk';
    case Tlacoapa_Me_phaa = 'tpl';
    case Tampulma = 'tpm';
    case Tupinamba = 'tpn';
    case Tai_Pao = 'tpo';
    case Pisaflores_Tepehua = 'tpp';
    case Tukpa = 'tpq';
    case Tupari = 'tpr';
    case Tlachichilco_Tepehua = 'tpt';
    case Tampuan = 'tpu';
    case Tanapag = 'tpv';
    case Acatepec_Me_phaa = 'tpx';
    case Trumai = 'tpy';
    case Tinputz = 'tpz';
    case Tembe = 'tqb';
    case Lehali = 'tql';
    case Turumsa = 'tqm';
    case Tenino = 'tqn';
    case Toaripi = 'tqo';
    case Tomoip = 'tqp';
    case Tunni = 'tqq';
    case Torona = 'tqr';
    case Western_Totonac = 'tqt';
    case Touo = 'tqu';
    case Tonkawa = 'tqw';
    case Tirahi = 'tra';
    case Terebu = 'trb';
    case Copala_Triqui = 'trc';
    case Turi = 'trd';
    case East_Tarangan = 'tre';
    case Trinidadian_Creole_English = 'trf';
    case Lishan_Didan = 'trg';
    case Turaka = 'trh';
    case Trio = 'tri';
    case Toram = 'trj';
    case Traveller_Scottish = 'trl';
    case Tregami = 'trm';
    case Trinitario = 'trn';
    case Tarao_Naga = 'tro';
    case Kok_Borok = 'trp';
    case San_Martin_Itunyoso_Triqui = 'trq';
    case Taushiro = 'trr';
    case Chicahuaxtla_Triqui = 'trs';
    case Tunggare = 'trt';
    case Turoyo = 'tru';
    case Sediq = 'trv';
    case Torwali = 'trw';
    case Tringgus_Sembaan_Bidayuh = 'trx';
    case Turung = 'try';
    case Tora = 'trz';
    case Tsaangi = 'tsa';
    case Tsamai = 'tsb';
    case Tswa = 'tsc';
    case Tsakonian = 'tsd';
    case Tunisian_Sign_Language = 'tse';
    case Tausug = 'tsg';
    case Tsuvan = 'tsh';
    case Tsimshian = 'tsi';
    case Tshangla = 'tsj';
    case Tseku = 'tsk';
    case Ts_un_Lao = 'tsl';
    case Turkish_Sign_Language = 'tsm';
    case Tswana = 'tsn';
    case Tsonga = 'tso';
    case Northern_Toussian = 'tsp';
    case Thai_Sign_Language = 'tsq';
    case Akei = 'tsr';
    case Taiwan_Sign_Language = 'tss';
    case Tondi_Songway_Kiini = 'tst';
    case Tsou = 'tsu';
    case Tsogo = 'tsv';
    case Tsishingini = 'tsw';
    case Mubami = 'tsx';
    case Tebul_Sign_Language = 'tsy';
    case Purepecha = 'tsz';
    case Tutelo = 'tta';
    case Gaa = 'ttb';
    case Tektiteko = 'ttc';
    case Tauade = 'ttd';
    case Bwanabwana = 'tte';
    case Tuotomb = 'ttf';
    case Tutong = 'ttg';
    case Upper_Ta_oih = 'tth';
    case Tobati = 'tti';
    case Tooro = 'ttj';
    case Totoro = 'ttk';
    case Totela = 'ttl';
    case Northern_Tutchone = 'ttm';
    case Towei = 'ttn';
    case Lower_Ta_oih = 'tto';
    case Tombelala = 'ttp';
    case Tawallammat_Tamajaq = 'ttq';
    case Tera = 'ttr';
    case Northeastern_Thai = 'tts';
    case Muslim_Tat = 'ttt';
    case Torau = 'ttu';
    case Titan = 'ttv';
    case Long_Wat = 'ttw';
    case Sikaritai = 'tty';
    case Tsum = 'ttz';
    case Wiarumus = 'tua';
    case Tubatulabal = 'tub';
    case Mutu = 'tuc';
    case Tuxa = 'tud';
    case Tuyuca = 'tue';
    case Central_Tunebo = 'tuf';
    case Tunia = 'tug';
    case Taulil = 'tuh';
    case Tupuri = 'tui';
    case Tugutil = 'tuj';
    case Turkmen = 'tuk';
    case Tula = 'tul';
    case Tumbuka = 'tum';
    case Tunica = 'tun';
    case Tucano = 'tuo';
    case Tedaga = 'tuq';
    case Turkish = 'tur';
    case Tuscarora = 'tus';
    case Tututni = 'tuu';
    case Turkana = 'tuv';
    case Tuxinawa = 'tux';
    case Tugen = 'tuy';
    case Turka = 'tuz';
    case Vaghua = 'tva';
    case Tsuvadi = 'tvd';
    case Te_un = 'tve';
    case Tulai = 'tvi';
    case Southeast_Ambrym = 'tvk';
    case Tuvalu = 'tvl';
    case Tela_Masbuar = 'tvm';
    case Tavoyan = 'tvn';
    case Tidore = 'tvo';
    case Taveta = 'tvs';
    case Tutsa_Naga = 'tvt';
    case Tunen = 'tvu';
    case Sedoa = 'tvw';
    case Taivoan = 'tvx';
    case Timor_Pidgin = 'tvy';
    case Twana = 'twa';
    case Western_Tawbuid = 'twb';
    case Teshenawa = 'twc';
    case Twents = 'twd';
    case Tewa_Indonesia = 'twe';
    case Northern_Tiwa = 'twf';
    case Tereweng = 'twg';
    case Tai_Don = 'twh';
    case Twi = 'twi';
    case Tawara = 'twl';
    case Tawang_Monpa = 'twm';
    case Twendi = 'twn';
    case Tswapong = 'two';
    case Ere = 'twp';
    case Tasawaq = 'twq';
    case Southwestern_Tarahumara = 'twr';
    case Turiwara = 'twt';
    case Termanu = 'twu';
    case Tuwari = 'tww';
    case Tewe = 'twx';
    case Tawoyan = 'twy';
    case Tombonuo = 'txa';
    case Tokharian_B = 'txb';
    case Tsetsaut = 'txc';
    case Totoli = 'txe';
    case Tangut = 'txg';
    case Thracian = 'txh';
    case Ikpeng = 'txi';
    case Tarjumo = 'txj';
    case Tomini = 'txm';
    case West_Tarangan = 'txn';
    case Toto = 'txo';
    case Tii = 'txq';
    case Tartessian = 'txr';
    case Tonsea = 'txs';
    case Citak = 'txt';
    case Kayapo = 'txu';
    case Tatana = 'txx';
    case Tanosy_Malagasy = 'txy';
    case Tauya = 'tya';
    case Kyanga = 'tye';
    case O_du = 'tyh';
    case Teke_Tsaayi = 'tyi';
    case Tai_Do = 'tyj';
    case Thu_Lao = 'tyl';
    case Kombai = 'tyn';
    case Thaypan = 'typ';
    case Tai_Daeng = 'tyr';
    case Tay_Sa_Pa = 'tys';
    case Tay_Tac = 'tyt';
    case Kua = 'tyu';
    case Tuvinian = 'tyv';
    case Teke_Tyee = 'tyx';
    case Tiyaa = 'tyy';
    case Tay = 'tyz';
    case Tanzanian_Sign_Language = 'tza';
    case Tzeltal = 'tzh';
    case Tz_utujil = 'tzj';
    case Talossan = 'tzl';
    case Central_Atlas_Tamazight = 'tzm';
    case Tugun = 'tzn';
    case Tzotzil = 'tzo';
    case Tabriak = 'tzx';
    case Uamue = 'uam';
    case Kuan = 'uan';
    case Tairuma = 'uar';
    case Ubang = 'uba';
    case Ubi = 'ubi';
    case Buhi_non_Bikol = 'ubl';
    case Ubir = 'ubr';
    case Umbu_Ungu = 'ubu';
    case Ubykh = 'uby';
    case Uda = 'uda';
    case Udihe = 'ude';
    case Muduga = 'udg';
    case Udi = 'udi';
    case Ujir = 'udj';
    case Wuzlam = 'udl';
    case Udmurt = 'udm';
    case Uduk = 'udu';
    case Kioko = 'ues';
    case Ufim = 'ufi';
    case Ugaritic = 'uga';
    case Kuku_Ugbanh = 'ugb';
    case Ughele = 'uge';
    case Kubachi = 'ugh';
    case Ugandan_Sign_Language = 'ugn';
    case Ugong = 'ugo';
    case Uruguayan_Sign_Language = 'ugy';
    case Uhami = 'uha';
    case Damal = 'uhn';
    case Uighur = 'uig';
    case Uisai = 'uis';
    case Iyive = 'uiv';
    case Tanjijili = 'uji';
    case Kaburi = 'uka';
    case Ukuriguma = 'ukg';
    case Ukhwejo = 'ukh';
    case Kui_India = 'uki';
    case Muak_Sa_aak = 'ukk';
    case Ukrainian_Sign_Language = 'ukl';
    case Ukpe_Bayobiri = 'ukp';
    case Ukwa = 'ukq';
    case Ukrainian = 'ukr';
    case Urubu_Kaapor_Sign_Language = 'uks';
    case Ukue = 'uku';
    case Kuku = 'ukv';
    case Ukwuani_Aboh_Ndoni = 'ukw';
    case Kuuk_Yak = 'uky';
    case Fungwa = 'ula';
    case Ulukwumi = 'ulb';
    case Ulch = 'ulc';
    case Lule = 'ule';
    case Usku = 'ulf';
    case Ulithian = 'uli';
    case Meriam_Mir = 'ulk';
    case Ullatan = 'ull';
    case Ulumanda = 'ulm';
    case Unserdeutsch = 'uln';
    case Uma_Lung = 'ulu';
    case Ulwa = 'ulw';
    case Buli = 'uly';
    case Umatilla = 'uma';
    case Umbundu = 'umb';
    case Marrucinian = 'umc';
    case Umbindhamu = 'umd';
    case Morrobalama = 'umg';
    case Ukit = 'umi';
    case Umon = 'umm';
    case Makyan_Naga = 'umn';
    case Umotina = 'umo';
    case Umpila = 'ump';
    case Umbugarla = 'umr';
    case Pendau = 'ums';
    case Munsee = 'umu';
    case North_Watut = 'una';
    case Undetermined = 'und';
    case Uneme = 'une';
    case Ngarinyin = 'ung';
    case Uni = 'uni';
    case Enawene_Nawe = 'unk';
    case Unami = 'unm';
    case Kurnai = 'unn';
    case Mundari = 'unr';
    case Unubahe = 'unu';
    case Munda = 'unx';
    case Unde_Kaili = 'unz';
    case Kulon = 'uon';
    case Umeda = 'upi';
    case Uripiv_Wala_Rano_Atchin = 'upv';
    case Urarina = 'ura';
    case Urubu_Kaapor = 'urb';
    case Urningangg = 'urc';
    case Urdu = 'urd';
    case Uru = 'ure';
    case Uradhi = 'urf';
    case Urigina = 'urg';
    case Urhobo = 'urh';
    case Urim = 'uri';
    case Urak_Lawoi = 'urk';
    case Urali = 'url';
    case Urapmin = 'urm';
    case Uruangnirin = 'urn';
    case Ura_Papua_New_Guinea = 'uro';
    case Uru_Pa_In = 'urp';
    case Lehalurup = 'urr';
    case Urat = 'urt';
    case Urumi = 'uru';
    case Uruava = 'urv';
    case Sop = 'urw';
    case Urimo = 'urx';
    case Orya = 'ury';
    case Uru_Eu_Wau_Wau = 'urz';
    case Usarufa = 'usa';
    case Ushojo = 'ush';
    case Usui = 'usi';
    case Usaghade = 'usk';
    case Uspanteco = 'usp';
    case us_Saare = 'uss';
    case Uya = 'usu';
    case Otank = 'uta';
    case Ute_Southern_Paiute = 'ute';
    case ut_Hun = 'uth';
    case Amba_Solomon_Islands = 'utp';
    case Etulo = 'utr';
    case Utu = 'utu';
    case Urum = 'uum';
    case Ura_Vanuatu = 'uur';
    case U = 'uuu';
    case West_Uvean = 'uve';
    case Uri = 'uvh';
    case Lote = 'uvl';
    case Kuku_Uwanh = 'uwa';
    case Doko_Uyanga = 'uya';
    case Uzbek = 'uzb';
    case Northern_Uzbek = 'uzn';
    case Southern_Uzbek = 'uzs';
    case Vaagri_Booli = 'vaa';
    case Vale = 'vae';
    case Vafsi = 'vaf';
    case Vagla = 'vag';
    case Varhadi_Nagpuri = 'vah';
    case Vai = 'vai';
    case Sekele = 'vaj';
    case Vehes = 'val';
    case Vanimo = 'vam';
    case Valman = 'van';
    case Vao = 'vao';
    case Vaiphei = 'vap';
    case Huarijio = 'var';
    case Vasavi = 'vas';
    case Vanuma = 'vau';
    case Varli = 'vav';
    case Wayu = 'vay';
    case Southeast_Babar = 'vbb';
    case Southwestern_Bontok = 'vbk';
    case Venetian = 'vec';
    case Veddah = 'ved';
    case Veluws = 'vel';
    case Vemgo_Mabas = 'vem';
    case Venda = 'ven';
    case Ventureno = 'veo';
    case Veps = 'vep';
    case Mom_Jango = 'ver';
    case Vaghri = 'vgr';
    case Vlaamse_Gebarentaal = 'vgt';
    case Virgin_Islands_Creole_English = 'vic';
    case Vidunda = 'vid';
    case Vietnamese = 'vie';
    case Vili = 'vif';
    case Viemo = 'vig';
    case Vilela = 'vil';
    case Vinza = 'vin';
    case Vishavan = 'vis';
    case Viti = 'vit';
    case Iduna = 'viv';
    case Bajjika = 'vjk';
    case Kariyarra = 'vka';
    case Kujarge = 'vkj';
    case Kaur = 'vkk';
    case Kulisusu = 'vkl';
    case Kamakan = 'vkm';
    case Koro_Nulu = 'vkn';
    case Kodeoha = 'vko';
    case Korlai_Creole_Portuguese = 'vkp';
    case Tenggarong_Kutai_Malay = 'vkt';
    case Kurrama = 'vku';
    case Koro_Zuba = 'vkz';
    case Valpei = 'vlp';
    case Vlaams = 'vls';
    case Martuyhunira = 'vma';
    case Barbaram = 'vmb';
    case Juxtlahuaca_Mixtec = 'vmc';
    case Mudu_Koraga = 'vmd';
    case East_Masela = 'vme';
    case Mainfrankisch = 'vmf';
    case Lungalunga = 'vmg';
    case Maraghei = 'vmh';
    case Miwa = 'vmi';
    case Ixtayutla_Mixtec = 'vmj';
    case Makhuwa_Shirima = 'vmk';
    case Malgana = 'vml';
    case Mitlatongo_Mixtec = 'vmm';
    case Soyaltepec_Mazatec = 'vmp';
    case Soyaltepec_Mixtec = 'vmq';
    case Marenje = 'vmr';
    case Moksela = 'vms';
    case Muluridyi = 'vmu';
    case Valley_Maidu = 'vmv';
    case Makhuwa = 'vmw';
    case Tamazola_Mixtec = 'vmx';
    case Ayautla_Mazatec = 'vmy';
    case Mazatlan_Mazatec = 'vmz';
    case Vano = 'vnk';
    case Vinmavis = 'vnm';
    case Vunapu = 'vnp';
    case Volapuk = 'vol';
    case Voro = 'vor';
    case Votic = 'vot';
    case Vera_a = 'vra';
    case Voro_2 = 'vro';
    case Varisi = 'vrs';
    case Burmbar = 'vrt';
    case Moldova_Sign_Language = 'vsi';
    case Venezuelan_Sign_Language = 'vsl';
    case Vedic_Sanskrit = 'vsn';
    case Valencian_Sign_Language = 'vsv';
    case Vitou = 'vto';
    case Vumbu = 'vum';
    case Vunjo = 'vun';
    case Vute = 'vut';
    case Awa_China = 'vwa';
    case Walla_Walla = 'waa';
    case Wab = 'wab';
    case Wasco_Wishram = 'wac';
    case Wamesa = 'wad';
    case Walser = 'wae';
    case Wakona = 'waf';
    case Wa_ema = 'wag';
    case Watubela = 'wah';
    case Wares = 'wai';
    case Waffa = 'waj';
    case Wolaytta = 'wal';
    case Wampanoag = 'wam';
    case Wan = 'wan';
    case Wappo = 'wao';
    case Wapishana = 'wap';
    case Wagiman = 'waq';
    case Waray_Philippines = 'war';
    case Washo = 'was';
    case Kaninuwa = 'wat';
    case Waura = 'wau';
    case Waka = 'wav';
    case Waiwai = 'waw';
    case Watam = 'wax';
    case Wayana = 'way';
    case Wampur = 'waz';
    case Warao = 'wba';
    case Wabo = 'wbb';
    case Waritai = 'wbe';
    case Wara_2 = 'wbf';
    case Wanda = 'wbh';
    case Vwanji = 'wbi';
    case Alagwa = 'wbj';
    case Waigali = 'wbk';
    case Wakhi = 'wbl';
    case Wa = 'wbm';
    case Warlpiri = 'wbp';
    case Waddar = 'wbq';
    case Wagdi = 'wbr';
    case West_Bengal_Sign_Language = 'wbs';
    case Warnman = 'wbt';
    case Wajarri = 'wbv';
    case Woi = 'wbw';
    case Yanomami = 'wca';
    case Waci_Gbe = 'wci';
    case Wandji = 'wdd';
    case Wadaginam = 'wdg';
    case Wadjiginy = 'wdj';
    case Wadikali = 'wdk';
    case Wendat = 'wdt';
    case Wadjigu = 'wdu';
    case Wadjabangayi = 'wdy';
    case Wewaw = 'wea';
    case We_Western = 'wec';
    case Wedau = 'wed';
    case Wergaia = 'weg';
    case Weh = 'weh';
    case Kiunum = 'wei';
    case Weme_Gbe = 'wem';
    case Wemale = 'weo';
    case Westphalien = 'wep';
    case Weri = 'wer';
    case Cameroon_Pidgin = 'wes';
    case Perai = 'wet';
    case Rawngtu_Chin = 'weu';
    case Wejewa = 'wew';
    case Yafi = 'wfg';
    case Wagaya = 'wga';
    case Wagawaga = 'wgb';
    case Wangkangurru = 'wgg';
    case Wahgi = 'wgi';
    case Waigeo = 'wgo';
    case Wirangu = 'wgu';
    case Warrgamay = 'wgy';
    case Sou_Upaa = 'wha';
    case North_Wahgi = 'whg';
    case Wahau_Kenyah = 'whk';
    case Wahau_Kayan = 'whu';
    case Southern_Toussian = 'wib';
    case Wichita = 'wic';
    case Wik_Epa = 'wie';
    case Wik_Keyangan = 'wif';
    case Wik_Ngathan = 'wig';
    case Wik_Me_anha = 'wih';
    case Minidien = 'wii';
    case Wik_Iiyanh = 'wij';
    case Wikalkan = 'wik';
    case Wilawila = 'wil';
    case Wik_Mungkan = 'wim';
    case Ho_Chunk = 'win';
    case Wirafed = 'wir';
    case Wiru = 'wiu';
    case Vitu = 'wiv';
    case Wiyot = 'wiy';
    case Waja = 'wja';
    case Warji = 'wji';
    case Kw_adza = 'wka';
    case Kumbaran = 'wkb';
    case Wakde = 'wkd';
    case Kalanadi = 'wkl';
    case Keerray_Woorroong = 'wkr';
    case Kunduvadi = 'wku';
    case Wakawaka = 'wkw';
    case Wangkayutyuru = 'wky';
    case Walio = 'wla';
    case Mwali_Comorian = 'wlc';
    case Wolane = 'wle';
    case Kunbarlang = 'wlg';
    case Welaun = 'wlh';
    case Waioli = 'wli';
    case Wailaki = 'wlk';
    case Wali_Sudan = 'wll';
    case Middle_Welsh = 'wlm';
    case Walloon = 'wln';
    case Wolio = 'wlo';
    case Wailapa = 'wlr';
    case Wallisian = 'wls';
    case Wuliwuli = 'wlu';
    case Wichi_Lhamtes_Vejoz = 'wlv';
    case Walak = 'wlw';
    case Wali_Ghana = 'wlx';
    case Waling = 'wly';
    case Mawa_Nigeria = 'wma';
    case Wambaya = 'wmb';
    case Wamas = 'wmc';
    case Mamainde = 'wmd';
    case Wambule = 'wme';
    case Western_Minyag = 'wmg';
    case Waima_a = 'wmh';
    case Wamin = 'wmi';
    case Maiwa_Indonesia = 'wmm';
    case Waamwang = 'wmn';
    case Wom_Papua_New_Guinea = 'wmo';
    case Wambon = 'wms';
    case Walmajarri = 'wmt';
    case Mwani = 'wmw';
    case Womo = 'wmx';
    case Mokati = 'wnb';
    case Wantoat = 'wnc';
    case Wandarang = 'wnd';
    case Waneci = 'wne';
    case Wanggom = 'wng';
    case Ndzwani_Comorian = 'wni';
    case Wanukaka = 'wnk';
    case Wanggamala = 'wnm';
    case Wunumara = 'wnn';
    case Wano = 'wno';
    case Wanap = 'wnp';
    case Usan = 'wnu';
    case Wintu = 'wnw';
    case Wanyi = 'wny';
    case Kuwema = 'woa';
    case We_Northern = 'wob';
    case Wogeo = 'woc';
    case Wolani = 'wod';
    case Woleaian = 'woe';
    case Gambian_Wolof = 'wof';
    case Wogamusin = 'wog';
    case Kamang = 'woi';
    case Longto = 'wok';
    case Wolof = 'wol';
    case Wom_Nigeria = 'wom';
    case Wongo = 'won';
    case Manombai = 'woo';
    case Woria = 'wor';
    case Hanga_Hundi = 'wos';
    case Wawonii = 'wow';
    case Weyto = 'woy';
    case Maco = 'wpc';
    case Waluwarra = 'wrb';
    case Warungu = 'wrg';
    case Wiradjuri = 'wrh';
    case Wariyangga = 'wri';
    case Garrwa = 'wrk';
    case Warlmanpa = 'wrl';
    case Warumungu = 'wrm';
    case Warnang = 'wrn';
    case Worrorra = 'wro';
    case Waropen = 'wrp';
    case Wardaman = 'wrr';
    case Waris = 'wrs';
    case Waru = 'wru';
    case Waruna = 'wrv';
    case Gugu_Warra = 'wrw';
    case Wae_Rana = 'wrx';
    case Merwari = 'wry';
    case Waray_Australia = 'wrz';
    case Warembori = 'wsa';
    case Adilabad_Gondi = 'wsg';
    case Wusi = 'wsi';
    case Waskia = 'wsk';
    case Owenia = 'wsr';
    case Wasa = 'wss';
    case Wasu = 'wsu';
    case Wotapuri_Katarqalai = 'wsv';
    case Matambwe = 'wtb';
    case Watiwa = 'wtf';
    case Wathawurrung = 'wth';
    case Berta = 'wti';
    case Watakataui = 'wtk';
    case Mewati = 'wtm';
    case Wotu = 'wtw';
    case Wikngenchera = 'wua';
    case Wunambal = 'wub';
    case Wudu = 'wud';
    case Wutunhua = 'wuh';
    case Silimo = 'wul';
    case Wumbvu = 'wum';
    case Bungu = 'wun';
    case Wurrugu = 'wur';
    case Wutung = 'wut';
    case Wu_Chinese = 'wuu';
    case Wuvulu_Aua = 'wuv';
    case Wulna = 'wux';
    case Wauyai = 'wuy';
    case Waama = 'wwa';
    case Wakabunga = 'wwb';
    case Wetamut = 'wwo';
    case Warrwa = 'wwr';
    case Wawa = 'www';
    case Waxianghua = 'wxa';
    case Wardandi = 'wxw';
    case Wangaaybuwan_Ngiyambaa = 'wyb';
    case Woiwurrung = 'wyi';
    case Wymysorys = 'wym';
    case Wyandot = 'wyn';
    case Wayoro = 'wyr';
    case Western_Fijian = 'wyy';
    case Andalusian_Arabic = 'xaa';
    case Sambe = 'xab';
    case Kachari = 'xac';
    case Adai = 'xad';
    case Aequian = 'xae';
    case Aghwan = 'xag';
    case Kaimbe = 'xai';
    case Ararandewara = 'xaj';
    case Maku = 'xak';
    case Kalmyk = 'xal';
    case Xam = 'xam';
    case Xamtanga = 'xan';
    case Khao = 'xao';
    case Apalachee = 'xap';
    case Aquitanian = 'xaq';
    case Karami = 'xar';
    case Kamas = 'xas';
    case Katawixi = 'xat';
    case Kauwera = 'xau';
    case Xavante = 'xav';
    case Kawaiisu = 'xaw';
    case Kayan_Mahakam = 'xay';
    case Lower_Burdekin = 'xbb';
    case Bactrian = 'xbc';
    case Bindal = 'xbd';
    case Bigambal = 'xbe';
    case Bunganditj = 'xbg';
    case Kombio = 'xbi';
    case Birrpayi = 'xbj';
    case Middle_Breton = 'xbm';
    case Kenaboi = 'xbn';
    case Bolgarian = 'xbo';
    case Bibbulman = 'xbp';
    case Kambera = 'xbr';
    case Kambiwa = 'xbw';
    case Batjala = 'xby';
    case Cumbric = 'xcb';
    case Camunic = 'xcc';
    case Celtiberian = 'xce';
    case Cisalpine_Gaulish = 'xcg';
    case Chemakum = 'xch';
    case Classical_Armenian = 'xcl';
    case Comecrudo = 'xcm';
    case Cotoname = 'xcn';
    case Chorasmian = 'xco';
    case Carian = 'xcr';
    case Classical_Tibetan = 'xct';
    case Curonian = 'xcu';
    case Chuvantsy = 'xcv';
    case Coahuilteco = 'xcw';
    case Cayuse = 'xcy';
    case Darkinyung = 'xda';
    case Dacian = 'xdc';
    case Dharuk = 'xdk';
    case Edomite = 'xdm';
    case Kwandu = 'xdo';
    case Kaitag = 'xdq';
    case Malayic_Dayak = 'xdy';
    case Eblan = 'xeb';
    case Hdi = 'xed';
    case Xegwi = 'xeg';
    case Kelo = 'xel';
    case Kembayan = 'xem';
    case Epi_Olmec = 'xep';
    case Xerente = 'xer';
    case Kesawai = 'xes';
    case Xeta = 'xet';
    case Keoru_Ahia = 'xeu';
    case Faliscan = 'xfa';
    case Galatian = 'xga';
    case Gbin = 'xgb';
    case Gudang = 'xgd';
    case Gabrielino_Fernandeno = 'xgf';
    case Goreng = 'xgg';
    case Garingbal = 'xgi';
    case Galindan = 'xgl';
    case Dharumbal = 'xgm';
    case Garza = 'xgr';
    case Unggumi = 'xgu';
    case Guwa = 'xgw';
    case Harami = 'xha';
    case Hunnic = 'xhc';
    case Hadrami = 'xhd';
    case Khetrani = 'xhe';
    case Middle_Khmer_1400_to_1850_CE = 'xhm';
    case Xhosa = 'xho';
    case Hernican = 'xhr';
    case Hattic = 'xht';
    case Hurrian = 'xhu';
    case Khua = 'xhv';
    case Iberian = 'xib';
    case Xiri = 'xii';
    case Illyrian = 'xil';
    case Xinca = 'xin';
    case Xiriana = 'xir';
    case Kisan = 'xis';
    case Indus_Valley_Language = 'xiv';
    case Xipaya = 'xiy';
    case Minjungbal = 'xjb';
    case Jaitmatang = 'xjt';
    case Kalkoti = 'xka';
    case Northern_Nago = 'xkb';
    case Kho_ini = 'xkc';
    case Mendalam_Kayan = 'xkd';
    case Kereho = 'xke';
    case Khengkha = 'xkf';
    case Kagoro = 'xkg';
    case Kenyan_Sign_Language = 'xki';
    case Kajali = 'xkj';
    case Kachok = 'xkk';
    case Mainstream_Kenyah = 'xkl';
    case Kayan_River_Kayan = 'xkn';
    case Kiorr = 'xko';
    case Kabatei = 'xkp';
    case Koroni = 'xkq';
    case Xakriaba = 'xkr';
    case Kumbewaha = 'xks';
    case Kantosi = 'xkt';
    case Kaamba = 'xku';
    case Kgalagadi = 'xkv';
    case Kembra = 'xkw';
    case Karore = 'xkx';
    case Uma_Lasan = 'xky';
    case Kurtokha = 'xkz';
    case Kamula = 'xla';
    case Loup_B = 'xlb';
    case Lycian = 'xlc';
    case Lydian = 'xld';
    case Lemnian = 'xle';
    case Ligurian_Ancient = 'xlg';
    case Liburnian = 'xli';
    case Alanic = 'xln';
    case Loup_A = 'xlo';
    case Lepontic = 'xlp';
    case Lusitanian = 'xls';
    case Cuneiform_Luwian = 'xlu';
    case Elymian = 'xly';
    case Mushungulu = 'xma';
    case Mbonga = 'xmb';
    case Makhuwa_Marrevone = 'xmc';
    case Mbudum = 'xmd';
    case Median = 'xme';
    case Mingrelian = 'xmf';
    case Mengaka = 'xmg';
    case Kugu_Muminh = 'xmh';
    case Majera = 'xmj';
    case Ancient_Macedonian = 'xmk';
    case Malaysian_Sign_Language = 'xml';
    case Manado_Malay = 'xmm';
    case Manichaean_Middle_Persian = 'xmn';
    case Morerebi = 'xmo';
    case Kuku_Mu_inh = 'xmp';
    case Kuku_Mangk = 'xmq';
    case Meroitic = 'xmr';
    case Moroccan_Sign_Language = 'xms';
    case Matbat = 'xmt';
    case Kamu = 'xmu';
    case Antankarana_Malagasy = 'xmv';
    case Tsimihety_Malagasy = 'xmw';
    case Salawati = 'xmx';
    case Mayaguduna = 'xmy';
    case Mori_Bawah = 'xmz';
    case Ancient_North_Arabian = 'xna';
    case Kanakanabu = 'xnb';
    case Middle_Mongolian = 'xng';
    case Kuanhua = 'xnh';
    case Ngarigu = 'xni';
    case Ngoni_Tanzania = 'xnj';
    case Nganakarti = 'xnk';
    case Ngumbarl = 'xnm';
    case Northern_Kankanay = 'xnn';
    case Anglo_Norman = 'xno';
    case Ngoni_Mozambique = 'xnq';
    case Kangri = 'xnr';
    case Kanashi = 'xns';
    case Narragansett = 'xnt';
    case Nukunul = 'xnu';
    case Nyiyaparli = 'xny';
    case Kenzi = 'xnz';
    case O_chi_chi = 'xoc';
    case Kokoda = 'xod';
    case Soga = 'xog';
    case Kominimung = 'xoi';
    case Xokleng = 'xok';
    case Komo_Sudan = 'xom';
    case Konkomba = 'xon';
    case Xukuru = 'xoo';
    case Kopar = 'xop';
    case Korubo = 'xor';
    case Kowaki = 'xow';
    case Pirriya = 'xpa';
    case Northeastern_Tasmanian = 'xpb';
    case Pecheneg = 'xpc';
    case Oyster_Bay_Tasmanian = 'xpd';
    case Liberia_Kpelle = 'xpe';
    case Southeast_Tasmanian = 'xpf';
    case Phrygian = 'xpg';
    case North_Midlands_Tasmanian = 'xph';
    case Pictish = 'xpi';
    case Mpalitjanh = 'xpj';
    case Kulina_Pano = 'xpk';
    case Port_Sorell_Tasmanian = 'xpl';
    case Pumpokol = 'xpm';
    case Kapinawa = 'xpn';
    case Pochutec = 'xpo';
    case Puyo_Paekche = 'xpp';
    case Mohegan_Pequot = 'xpq';
    case Parthian = 'xpr';
    case Pisidian = 'xps';
    case Punthamara = 'xpt';
    case Punic = 'xpu';
    case Northern_Tasmanian = 'xpv';
    case Northwestern_Tasmanian = 'xpw';
    case Southwestern_Tasmanian = 'xpx';
    case Puyo = 'xpy';
    case Bruny_Island_Tasmanian = 'xpz';
    case Karakhanid = 'xqa';
    case Qatabanian = 'xqt';
    case Kraho = 'xra';
    case Eastern_Karaboro = 'xrb';
    case Gundungurra = 'xrd';
    case Kreye = 'xre';
    case Minang = 'xrg';
    case Krikati_Timbira = 'xri';
    case Armazic = 'xrm';
    case Arin = 'xrn';
    case Raetic = 'xrr';
    case Aranama_Tamique = 'xrt';
    case Marriammu = 'xru';
    case Karawa = 'xrw';
    case Sabaean = 'xsa';
    case Sambal = 'xsb';
    case Scythian = 'xsc';
    case Sidetic = 'xsd';
    case Sempan = 'xse';
    case Shamang = 'xsh';
    case Sio = 'xsi';
    case Subi = 'xsj';
    case South_Slavey = 'xsl';
    case Kasem = 'xsm';
    case Sanga_Nigeria = 'xsn';
    case Solano = 'xso';
    case Silopi = 'xsp';
    case Makhuwa_Saka = 'xsq';
    case Sherpa = 'xsr';
    case Sanuma = 'xsu';
    case Sudovian = 'xsv';
    case Saisiyat = 'xsy';
    case Alcozauca_Mixtec = 'xta';
    case Chazumba_Mixtec = 'xtb';
    case Katcha_Kadugli_Miri = 'xtc';
    case Diuxi_Tilantongo_Mixtec = 'xtd';
    case Ketengban = 'xte';
    case Transalpine_Gaulish = 'xtg';
    case Yitha_Yitha = 'xth';
    case Sinicahua_Mixtec = 'xti';
    case San_Juan_Teita_Mixtec = 'xtj';
    case Tijaltepec_Mixtec = 'xtl';
    case Magdalena_Penasco_Mixtec = 'xtm';
    case Northern_Tlaxiaco_Mixtec = 'xtn';
    case Tokharian_A = 'xto';
    case San_Miguel_Piedras_Mixtec = 'xtp';
    case Tumshuqese = 'xtq';
    case Early_Tripuri = 'xtr';
    case Sindihui_Mixtec = 'xts';
    case Tacahua_Mixtec = 'xtt';
    case Cuyamecalco_Mixtec = 'xtu';
    case Thawa = 'xtv';
    case Tawande = 'xtw';
    case Yoloxochitl_Mixtec = 'xty';
    case Alu_Kurumba = 'xua';
    case Betta_Kurumba = 'xub';
    case Umiida = 'xud';
    case Kunigami = 'xug';
    case Jennu_Kurumba = 'xuj';
    case Ngunawal = 'xul';
    case Umbrian = 'xum';
    case Unggaranggu = 'xun';
    case Kuo = 'xuo';
    case Upper_Umpqua = 'xup';
    case Urartian = 'xur';
    case Kuthant = 'xut';
    case Kxoe = 'xuu';
    case Venetic = 'xve';
    case Kamviri = 'xvi';
    case Vandalic = 'xvn';
    case Volscian = 'xvo';
    case Vestinian = 'xvs';
    case Kwaza = 'xwa';
    case Woccon = 'xwc';
    case Wadi_Wadi = 'xwd';
    case Xwela_Gbe = 'xwe';
    case Kwegu = 'xwg';
    case Wajuk = 'xwj';
    case Wangkumara = 'xwk';
    case Western_Xwla_Gbe = 'xwl';
    case Written_Oirat = 'xwo';
    case Kwerba_Mamberamo = 'xwr';
    case Wotjobaluk = 'xwt';
    case Wemba_Wemba = 'xww';
    case Boro_Ghana = 'xxb';
    case Ke_o = 'xxk';
    case Minkin = 'xxm';
    case Koropo = 'xxr';
    case Tambora = 'xxt';
    case Yaygir = 'xya';
    case Yandjibara = 'xyb';
    case Mayi_Yapi = 'xyj';
    case Mayi_Kulan = 'xyk';
    case Yalakalore = 'xyl';
    case Mayi_Thakurti = 'xyt';
    case Yorta_Yorta = 'xyy';
    case Zhang_Zhung = 'xzh';
    case Zemgalian = 'xzm';
    case Ancient_Zapotec = 'xzp';
    case Yaminahua = 'yaa';
    case Yuhup = 'yab';
    case Pass_Valley_Yali = 'yac';
    case Yagua = 'yad';
    case Pume = 'yae';
    case Yaka_Democratic_Republic_of_Congo = 'yaf';
    case Yamana = 'yag';
    case Yazgulyam = 'yah';
    case Yagnobi = 'yai';
    case Banda_Yangere = 'yaj';
    case Yakama = 'yak';
    case Yalunka = 'yal';
    case Yamba = 'yam';
    case Mayangna = 'yan';
    case Yao = 'yao';
    case Yapese = 'yap';
    case Yaqui = 'yaq';
    case Yabarana = 'yar';
    case Nugunu_Cameroon = 'yas';
    case Yambeta = 'yat';
    case Yuwana = 'yau';
    case Yangben = 'yav';
    case Yawalapiti = 'yaw';
    case Yauma = 'yax';
    case Agwagwune = 'yay';
    case Lokaa = 'yaz';
    case Yala = 'yba';
    case Yemba = 'ybb';
    case West_Yugur = 'ybe';
    case Yakha = 'ybh';
    case Yamphu = 'ybi';
    case Hasha = 'ybj';
    case Bokha = 'ybk';
    case Yukuben = 'ybl';
    case Yaben = 'ybm';
    case Yabaana = 'ybn';
    case Yabong = 'ybo';
    case Yawiyo = 'ybx';
    case Yaweyuha = 'yby';
    case Chesu = 'ych';
    case Lolopo = 'ycl';
    case Yucuna = 'ycn';
    case Chepya = 'ycp';
    case Yilan_Creole = 'ycr';
    case Yanda = 'yda';
    case Eastern_Yiddish = 'ydd';
    case Yangum_Dey = 'yde';
    case Yidgha = 'ydg';
    case Yoidik = 'ydk';
    case Ravula = 'yea';
    case Yeniche = 'yec';
    case Yimas = 'yee';
    case Yeni = 'yei';
    case Yevanic = 'yej';
    case Yela = 'yel';
    case Tarok = 'yer';
    case Nyankpa = 'yes';
    case Yetfa = 'yet';
    case Yerukula = 'yeu';
    case Yapunda = 'yev';
    case Yeyi = 'yey';
    case Malyangapa = 'yga';
    case Yiningayi = 'ygi';
    case Yangum_Gel = 'ygl';
    case Yagomi = 'ygm';
    case Gepo = 'ygp';
    case Yagaria = 'ygr';
    case Yol_u_Sign_Language = 'ygs';
    case Yugul = 'ygu';
    case Yagwoia = 'ygw';
    case Baha_Buyang = 'yha';
    case Judeo_Iraqi_Arabic = 'yhd';
    case Hlepho_Phowa = 'yhl';
    case Yan_nhangu_Sign_Language = 'yhs';
    case Yinggarda = 'yia';
    case Yiddish = 'yid';
    case Ache_2 = 'yif';
    case Wusa_Nasu = 'yig';
    case Western_Yiddish = 'yih';
    case Yidiny = 'yii';
    case Yindjibarndi = 'yij';
    case Dongshanba_Lalo = 'yik';
    case Yindjilandji = 'yil';
    case Yimchungru_Naga = 'yim';
    case Riang_Lai = 'yin';
    case Pholo = 'yip';
    case Miqie = 'yiq';
    case North_Awyu = 'yir';
    case Yis = 'yis';
    case Eastern_Lalu = 'yit';
    case Awu = 'yiu';
    case Northern_Nisu = 'yiv';
    case Axi_Yi = 'yix';
    case Azhe = 'yiz';
    case Yakan = 'yka';
    case Northern_Yukaghir = 'ykg';
    case Khamnigan_Mongol = 'ykh';
    case Yoke = 'yki';
    case Yakaikeke = 'ykk';
    case Khlula = 'ykl';
    case Kap = 'ykm';
    case Kua_nsi = 'ykn';
    case Yasa = 'yko';
    case Yekora = 'ykr';
    case Kathu = 'ykt';
    case Kuamasi = 'yku';
    case Yakoma = 'yky';
    case Yaul = 'yla';
    case Yaleba = 'ylb';
    case Yele = 'yle';
    case Yelogu = 'ylg';
    case Angguruk_Yali = 'yli';
    case Yil = 'yll';
    case Limi = 'ylm';
    case Langnian_Buyang = 'yln';
    case Naluo_Yi = 'ylo';
    case Yalarnnga = 'ylr';
    case Aribwaung = 'ylu';
    case Nyalayu = 'yly';
    case Yambes = 'ymb';
    case Southern_Muji = 'ymc';
    case Muda = 'ymd';
    case Yameo = 'yme';
    case Yamongeri = 'ymg';
    case Mili = 'ymh';
    case Moji = 'ymi';
    case Makwe = 'ymk';
    case Iamalele = 'yml';
    case Maay = 'ymm';
    case Yamna = 'ymn';
    case Yangum_Mon = 'ymo';
    case Yamap = 'ymp';
    case Qila_Muji = 'ymq';
    case Malasar = 'ymr';
    case Mysian = 'yms';
    case Northern_Muji = 'ymx';
    case Muzi = 'ymz';
    case Aluo = 'yna';
    case Yamben = 'ynb';
    case Yandruwandha = 'ynd';
    case Lang_e = 'yne';
    case Yango = 'yng';
    case Naukan_Yupik = 'ynk';
    case Yangulam = 'ynl';
    case Yana = 'ynn';
    case Yong = 'yno';
    case Yendang = 'ynq';
    case Yansi = 'yns';
    case Yahuna = 'ynu';
    case Yoba = 'yob';
    case Yogad = 'yog';
    case Yonaguni = 'yoi';
    case Yokuts = 'yok';
    case Yola = 'yol';
    case Yombe = 'yom';
    case Yongkom = 'yon';
    case Yoruba = 'yor';
    case Yotti = 'yot';
    case Yoron = 'yox';
    case Yoy = 'yoy';
    case Phala = 'ypa';
    case Labo_Phowa = 'ypb';
    case Phola = 'ypg';
    case Phupha = 'yph';
    case Phuma = 'ypm';
    case Ani_Phowa = 'ypn';
    case Alo_Phola = 'ypo';
    case Phupa = 'ypp';
    case Phuza = 'ypz';
    case Yerakai = 'yra';
    case Yareba = 'yrb';
    case Yaoure = 'yre';
    case Nenets = 'yrk';
    case Nhengatu = 'yrl';
    case Yirrk_Mel = 'yrm';
    case Yerong = 'yrn';
    case Yaroame = 'yro';
    case Yarsun = 'yrs';
    case Yarawata = 'yrw';
    case Yarluyandi = 'yry';
    case Yassic = 'ysc';
    case Samatao = 'ysd';
    case Sonaga = 'ysg';
    case Yugoslavian_Sign_Language = 'ysl';
    case Myanmar_Sign_Language = 'ysm';
    case Sani = 'ysn';
    case Nisi_China = 'yso';
    case Southern_Lolopo = 'ysp';
    case Sirenik_Yupik = 'ysr';
    case Yessan_Mayo = 'yss';
    case Sanie = 'ysy';
    case Talu = 'yta';
    case Tanglang = 'ytl';
    case Thopho = 'ytp';
    case Yout_Wam = 'ytw';
    case Yatay = 'yty';
    case Yucateco = 'yua';
    case Yugambal = 'yub';
    case Yuchi = 'yuc';
    case Judeo_Tripolitanian_Arabic = 'yud';
    case Yue_Chinese = 'yue';
    case Havasupai_Walapai_Yavapai = 'yuf';
    case Yug = 'yug';
    case Yuruti = 'yui';
    case Karkar_Yuri = 'yuj';
    case Yuki = 'yuk';
    case Yulu = 'yul';
    case Quechan = 'yum';
    case Bena_Nigeria = 'yun';
    case Yukpa = 'yup';
    case Yuqui = 'yuq';
    case Yurok = 'yur';
    case Yopno = 'yut';
    case Yau_Morobe_Province = 'yuw';
    case Southern_Yukaghir = 'yux';
    case East_Yugur = 'yuy';
    case Yuracare = 'yuz';
    case Yawa = 'yva';
    case Yavitero = 'yvt';
    case Kalou = 'ywa';
    case Yinhawangka = 'ywg';
    case Western_Lalu = 'ywl';
    case Yawanawa = 'ywn';
    case Wuding_Luquan_Yi = 'ywq';
    case Yawuru = 'ywr';
    case Xishanba_Lalo = 'ywt';
    case Wumeng_Nasu = 'ywu';
    case Yawarawarga = 'yww';
    case Mayawali = 'yxa';
    case Yagara = 'yxg';
    case Yardliyawarra = 'yxl';
    case Yinwum = 'yxm';
    case Yuyu = 'yxu';
    case Yabula_Yabula = 'yxy';
    case Yir_Yoront = 'yyr';
    case Yau_Sandaun_Province = 'yyu';
    case Ayizi = 'yyz';
    case E_ma_Buyang = 'yzg';
    case Zokhuo = 'yzk';
    case Sierra_de_Juarez_Zapotec = 'zaa';
    case Western_Tlacolula_Valley_Zapotec = 'zab';
    case Ocotlan_Zapotec = 'zac';
    case Cajonos_Zapotec = 'zad';
    case Yareni_Zapotec = 'zae';
    case Ayoquesco_Zapotec = 'zaf';
    case Zaghawa = 'zag';
    case Zangwal = 'zah';
    case Isthmus_Zapotec = 'zai';
    case Zaramo = 'zaj';
    case Zanaki = 'zak';
    case Zauzou = 'zal';
    case Miahuatlan_Zapotec = 'zam';
    case Ozolotepec_Zapotec = 'zao';
    case Zapotec = 'zap';
    case Aloapam_Zapotec = 'zaq';
    case Rincon_Zapotec = 'zar';
    case Santo_Domingo_Albarradas_Zapotec = 'zas';
    case Tabaa_Zapotec = 'zat';
    case Zangskari = 'zau';
    case Yatzachi_Zapotec = 'zav';
    case Mitla_Zapotec = 'zaw';
    case Xadani_Zapotec = 'zax';
    case Zayse_Zergulla = 'zay';
    case Zari = 'zaz';
    case Balaibalan = 'zba';
    case Central_Berawan = 'zbc';
    case East_Berawan = 'zbe';
    case Blissymbols = 'zbl';
    case Batui = 'zbt';
    case Bu_Bauchi_State = 'zbu';
    case West_Berawan = 'zbw';
    case Coatecas_Altas_Zapotec = 'zca';
    case Las_Delicias_Zapotec = 'zcd';
    case Central_Hongshuihe_Zhuang = 'zch';
    case Ngazidja_Comorian = 'zdj';
    case Zeeuws = 'zea';
    case Zenag = 'zeg';
    case Eastern_Hongshuihe_Zhuang = 'zeh';
    case Zeem = 'zem';
    case Zenaga = 'zen';
    case Kinga = 'zga';
    case Guibei_Zhuang = 'zgb';
    case Standard_Moroccan_Tamazight = 'zgh';
    case Minz_Zhuang = 'zgm';
    case Guibian_Zhuang = 'zgn';
    case Magori = 'zgr';
    case Zhuang = 'zha';
    case Zhaba = 'zhb';
    case Dai_Zhuang = 'zhd';
    case Zhire = 'zhi';
    case Nong_Zhuang = 'zhn';
    case Chinese = 'zho';
    case Zhoa = 'zhw';
    case Zia = 'zia';
    case Zimbabwe_Sign_Language = 'zib';
    case Zimakani = 'zik';
    case Zialo = 'zil';
    case Mesme = 'zim';
    case Zinza = 'zin';
    case Zigula = 'ziw';
    case Zizilivakan = 'ziz';
    case Kaimbulawa = 'zka';
    case Kadu = 'zkd';
    case Koguryo = 'zkg';
    case Khorezmian = 'zkh';
    case Karankawa = 'zkk';
    case Kanan = 'zkn';
    case Kott = 'zko';
    case Sao_Paulo_Kaingang = 'zkp';
    case Zakhring = 'zkr';
    case Kitan = 'zkt';
    case Kaurna = 'zku';
    case Krevinian = 'zkv';
    case Khazar = 'zkz';
    case Zula = 'zla';
    case Liujiang_Zhuang = 'zlj';
    case Malay_individual_language = 'zlm';
    case Lianshan_Zhuang = 'zln';
    case Liuqian_Zhuang = 'zlq';
    case Zul = 'zlu';
    case Manda_Australia = 'zma';
    case Zimba = 'zmb';
    case Margany = 'zmc';
    case Maridan = 'zmd';
    case Mangerr = 'zme';
    case Mfinu = 'zmf';
    case Marti_Ke = 'zmg';
    case Makolkol = 'zmh';
    case Negeri_Sembilan_Malay = 'zmi';
    case Maridjabin = 'zmj';
    case Mandandanyi = 'zmk';
    case Matngala = 'zml';
    case Marimanindji = 'zmm';
    case Mbangwe = 'zmn';
    case Molo = 'zmo';
    case Mpuono = 'zmp';
    case Mituku = 'zmq';
    case Maranunggu = 'zmr';
    case Mbesa = 'zms';
    case Maringarr = 'zmt';
    case Muruwari = 'zmu';
    case Mbariman_Gudhinma = 'zmv';
    case Mbo_Democratic_Republic_of_Congo = 'zmw';
    case Bomitaba = 'zmx';
    case Mariyedi = 'zmy';
    case Mbandja = 'zmz';
    case Zan_Gula = 'zna';
    case Zande_individual_language = 'zne';
    case Mang = 'zng';
    case Manangkari = 'znk';
    case Mangas = 'zns';
    case Copainala_Zoque = 'zoc';
    case Chimalapa_Zoque = 'zoh';
    case Zou = 'zom';
    case Asuncion_Mixtepec_Zapotec = 'zoo';
    case Tabasco_Zoque = 'zoq';
    case Rayon_Zoque = 'zor';
    case Francisco_Leon_Zoque = 'zos';
    case Lachiguiri_Zapotec = 'zpa';
    case Yautepec_Zapotec = 'zpb';
    case Choapan_Zapotec = 'zpc';
    case Southeastern_Ixtlan_Zapotec = 'zpd';
    case Petapa_Zapotec = 'zpe';
    case San_Pedro_Quiatoni_Zapotec = 'zpf';
    case Guevea_De_Humboldt_Zapotec = 'zpg';
    case Totomachapan_Zapotec = 'zph';
    case Santa_Maria_Quiegolani_Zapotec = 'zpi';
    case Quiavicuzas_Zapotec = 'zpj';
    case Tlacolulita_Zapotec = 'zpk';
    case Lachixio_Zapotec = 'zpl';
    case Mixtepec_Zapotec = 'zpm';
    case Santa_Ines_Yatzechi_Zapotec = 'zpn';
    case Amatlan_Zapotec = 'zpo';
    case El_Alto_Zapotec = 'zpp';
    case Zoogocho_Zapotec = 'zpq';
    case Santiago_Xanica_Zapotec = 'zpr';
    case Coatlan_Zapotec = 'zps';
    case San_Vicente_Coatlan_Zapotec = 'zpt';
    case Yalalag_Zapotec = 'zpu';
    case Chichicapan_Zapotec = 'zpv';
    case Zaniza_Zapotec = 'zpw';
    case San_Baltazar_Loxicha_Zapotec = 'zpx';
    case Mazaltepec_Zapotec = 'zpy';
    case Texmelucan_Zapotec = 'zpz';
    case Qiubei_Zhuang = 'zqe';
    case Kara_Korea = 'zra';
    case Mirgan = 'zrg';
    case Zerenkel = 'zrn';
    case Zaparo = 'zro';
    case Zarphatic = 'zrp';
    case Mairasi = 'zrs';
    case Sarasira = 'zsa';
    case Kaskean = 'zsk';
    case Zambian_Sign_Language = 'zsl';
    case Standard_Malay = 'zsm';
    case Southern_Rincon_Zapotec = 'zsr';
    case Sukurum = 'zsu';
    case Elotepec_Zapotec = 'zte';
    case Xanaguia_Zapotec = 'ztg';
    case Lapaguia_Guivini_Zapotec = 'ztl';
    case San_Agustin_Mixtepec_Zapotec = 'ztm';
    case Santa_Catarina_Albarradas_Zapotec = 'ztn';
    case Loxicha_Zapotec = 'ztp';
    case Quioquitani_Quieri_Zapotec = 'ztq';
    case Tilquiapan_Zapotec = 'zts';
    case Tejalapan_Zapotec = 'ztt';
    case Guila_Zapotec = 'ztu';
    case Zaachila_Zapotec = 'ztx';
    case Yatee_Zapotec = 'zty';
    case Tokano = 'zuh';
    case Zulu = 'zul';
    case Kumzari = 'zum';
    case Zuni = 'zun';
    case Zumaya = 'zuy';
    case Zay = 'zwa';
    case No_linguistic_content = 'zxx';
    case Yongbei_Zhuang = 'zyb';
    case Yang_Zhuang = 'zyg';
    case Youjiang_Zhuang = 'zyj';
    case Yongnan_Zhuang = 'zyn';
    case Zyphe_Chin = 'zyp';
    case Zaza = 'zza';
    case Zuojiang_Zhuang = 'zzj';

    /** @deprecated Has been removed from the specification but is maintained here for Backwards Compatibility reasons */
    case Dek = 'dek';

    /** @deprecated Has been removed from the specification but is maintained here for Backwards Compatibility reasons */
    case Nathembo = 'nte';

    public function getNameForCountry(CountryAlpha2 $country): ?string {
        return $country->getNameInLanguage($this);
    }

    /**
     * @param list<LanguageTagVariant> $variantSubtag ,
     * @param list<string> $extensionSubtag
     * @throws InvalidArgumentException
     */
    public function toLanguageTag(
        LanguageAlpha3Terminology|LanguageAlpha3Extensive|null     $extendedLanguageSubtag = null,
        ScriptCode|null                                            $scriptSubtag = null,
        CountryAlpha2|GeographicRegion|PrivateUseRegionSubtag|null $regionSubtag = null,
        array                                                      $variantSubtag = [],
        array                                                      $extensionSubtag = [],
        string|null                                                $privateUseSubtag = null,
    ): LanguageTag {
        return new LanguageTag(
            $this,
            $extendedLanguageSubtag,
            $scriptSubtag,
            $regionSubtag,
            $variantSubtag,
            $extensionSubtag,
            $privateUseSubtag,
        );
    }
}
